/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.PreferenceListener;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.pipeline.graph.VtkPipeLineGraphModel;
import com.artenum.cassandra.pipeline.graph.VtkPipeLinePanel;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.ActorList;
import com.artenum.cassandra.ui.CassandraTree;
import com.artenum.jyconsole.JyConsole;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class CassandraGUI
extends JPanel
implements PreferenceListener {
    public static final String PREF_SCRIPT_DIR = "cassandra.pref.script.dir";
    private JSplitPane pipeLine_renderer;
    private JSplitPane console;
    private JyConsole consolePython;
    private Hashtable prefTable;
    private int preferedControlPanel = 2;
    private JTabbedPane pipelineControlPane;
    private VtkPipeLineGraphModel graphModel;

    public CassandraGUI(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        super(new BorderLayout());
        this.initComponents(pipeLineManager, pluginManager, true);
    }

    public CassandraGUI(PipeLineManager pipeLineManager, PluginManager pluginManager, boolean activateJyConsole) {
        super(new BorderLayout());
        this.initComponents(pipeLineManager, pluginManager, activateJyConsole);
    }

    private void initComponents(PipeLineManager pipeLineManager, PluginManager pluginManager, boolean activateJyConsole) {
        if (activateJyConsole) {
            this.consolePython = new JyConsole();
        }
        this.pipelineControlPane = new JTabbedPane();
        this.pipelineControlPane.addTab("View", new JScrollPane(new ActorList(new String[]{"Actor", "Scalar bar", "Text"}, new VtkObjectListModel[]{pipeLineManager.getActorList(), pipeLineManager.getScalarBarList(), pipeLineManager.getTextActorList()}, pipeLineManager)));
        this.pipelineControlPane.addTab("Tree", new JScrollPane(new CassandraTree(pipeLineManager, pluginManager)));
        this.graphModel = new VtkPipeLineGraphModel(pipeLineManager, pluginManager);
        this.pipelineControlPane.addTab("Pipeline", new JScrollPane(new VtkPipeLinePanel(this.graphModel)));
        this.pipelineControlPane.setSelectedIndex(this.preferedControlPanel);
        this.pipeLine_renderer = new JSplitPane(1, this.pipelineControlPane, (Component)pipeLineManager.getCassandraView());
        this.pipeLine_renderer.setOneTouchExpandable(true);
        this.console = new JSplitPane(0, this.pipeLine_renderer, (Component)this.consolePython);
        this.console.setOneTouchExpandable(true);
        this.console.setResizeWeight(1.0);
        this.console.setDividerLocation(1.0);
        this.add((Component)this.console, "Center");
        if (this.preferedControlPanel < 0) {
            this.pipeLine_renderer.setDividerLocation(0);
        } else if (this.preferedControlPanel == 2) {
            this.pipeLine_renderer.setDividerLocation(450);
        } else {
            this.pipeLine_renderer.setDividerLocation(0.5);
        }
    }

    public void showConsole() {
        this.console.setDividerLocation(0.5);
    }

    public void hideConsole() {
        this.console.setDividerLocation(50000);
    }

    public void showPipeLine() {
        this.pipeLine_renderer.setDividerLocation(0.5);
    }

    public void hidePipeLine() {
        this.pipeLine_renderer.setDividerLocation(0);
    }

    public void showRenderer() {
        this.pipeLine_renderer.setDividerLocation(0.5);
    }

    public void hideRenderer() {
        this.pipeLine_renderer.setDividerLocation(50000);
    }

    public void setPipeLineRendererDividerLocation(int pos) {
        this.pipeLine_renderer.setDividerLocation(pos);
    }

    public JyConsole getPyConsole() {
        return this.consolePython;
    }

    @Override
    public void preferenceChanged() {
        if (this.prefTable != null && this.prefTable.get(PREF_SCRIPT_DIR) != null) {
            this.consolePython.getPreferences().put("jyconsole.pref.script.dir", ((File)this.prefTable.get(PREF_SCRIPT_DIR)).getAbsolutePath());
        }
    }

    public void setPreferences(Hashtable prefTable) {
        this.prefTable = prefTable;
    }

    public int getPreferedControlPanel() {
        return this.preferedControlPanel;
    }

    public void setPreferedControlPanel(int preferedControlPanel) {
        this.preferedControlPanel = preferedControlPanel;
        this.pipelineControlPane.setSelectedIndex(preferedControlPanel);
    }

    public void addControlePanel(String paneName, JScrollPane pane) {
        this.pipelineControlPane.addTab(paneName, pane);
    }

    public JTabbedPane getPipelineEditor() {
        return this.pipelineControlPane;
    }

    public void update() {
        this.graphModel.contentsChanged(null);
    }
}

