/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.util;

import com.artenum.nisaba.util.MatrixUtilDouble;
import com.artenum.nisaba.util.VectorUtilDouble;
import com.artenum.penelope.mesh.BoundingBox;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.iterator.SingleVertexIterator;
import com.artenum.penelope.mesh.mask.EdgeMeshMask;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import com.artenum.penelope.mesh.mask.PolyhedronMeshMask;
import com.artenum.penelope.mesh.mask.VertexMeshMask;
import java.util.Iterator;

public class GeometryUtil {
    private static double epsilon = 1.0E-8f;

    public static void setEpsilon(double epsilon) {
        GeometryUtil.epsilon = epsilon;
    }

    private GeometryUtil() {
    }

    public static boolean isInsideTriangle(Vertex node, Face triangle) {
        double[] p = new double[]{node.getPoint().getCoord()[0], node.getPoint().getCoord()[1], node.getPoint().getCoord()[2]};
        return GeometryUtil.isInsideTriangle(p, triangle);
    }

    public static boolean isInsideTriangle(double[] node, Face triangle) {
        double areaPCA;
        double areaPBC;
        double areaPAB;
        double[] a = new double[]{triangle.getVertexAt(0).getPoint().getCoord()[0], triangle.getVertexAt(0).getPoint().getCoord()[1], triangle.getVertexAt(0).getPoint().getCoord()[2]};
        double[] b = new double[]{triangle.getVertexAt(1).getPoint().getCoord()[0], triangle.getVertexAt(1).getPoint().getCoord()[1], triangle.getVertexAt(1).getPoint().getCoord()[2]};
        double[] c = new double[]{triangle.getVertexAt(2).getPoint().getCoord()[0], triangle.getVertexAt(2).getPoint().getCoord()[1], triangle.getVertexAt(2).getPoint().getCoord()[2]};
        double[] ab = VectorUtilDouble.minusWithNew(b, a);
        double[] ac = VectorUtilDouble.minusWithNew(c, a);
        double[] pa = VectorUtilDouble.minusWithNew(a, node);
        double[] pb = VectorUtilDouble.minusWithNew(b, node);
        double[] pc = VectorUtilDouble.minusWithNew(c, node);
        double areaABC = VectorUtilDouble.norm3(VectorUtilDouble.dotProduct3(ab, ac));
        return areaABC - ((areaPAB = VectorUtilDouble.norm3(VectorUtilDouble.dotProduct3(pa, pb))) + (areaPBC = VectorUtilDouble.norm3(VectorUtilDouble.dotProduct3(pb, pc))) + (areaPCA = VectorUtilDouble.norm3(VectorUtilDouble.dotProduct3(pc, pa)))) < epsilon && areaABC - (areaPAB + areaPBC + areaPCA) > -epsilon;
    }

    public static boolean isInsideTetrahedron(Vertex node, Polyhedron tetra) {
        double[] n = new double[]{node.getPoint().getCoord()[0], node.getPoint().getCoord()[1], node.getPoint().getCoord()[2]};
        return GeometryUtil.isInsideTetrahedron(n, tetra);
    }

    public static boolean isInsideTetrahedron(double[] node, Polyhedron tetra) {
        double[] t0 = new double[]{tetra.getVertexAt(0).getPoint().getCoord()[0], tetra.getVertexAt(0).getPoint().getCoord()[1], tetra.getVertexAt(0).getPoint().getCoord()[2]};
        double[] t1 = new double[]{tetra.getVertexAt(1).getPoint().getCoord()[0], tetra.getVertexAt(1).getPoint().getCoord()[1], tetra.getVertexAt(1).getPoint().getCoord()[2]};
        double[] t2 = new double[]{tetra.getVertexAt(2).getPoint().getCoord()[0], tetra.getVertexAt(2).getPoint().getCoord()[1], tetra.getVertexAt(2).getPoint().getCoord()[2]};
        double[] t3 = new double[]{tetra.getVertexAt(3).getPoint().getCoord()[0], tetra.getVertexAt(3).getPoint().getCoord()[1], tetra.getVertexAt(3).getPoint().getCoord()[2]};
        double[] dArray = new double[]{t0[0], t0[1], t0[2], 1.0, t1[0], t1[1], t1[2], 1.0, t2[0], t2[1], t2[2], 1.0, t3[0], t3[1], t3[2], 1.0};
        double d0 = MatrixUtilDouble.detM4(dArray);
        if (d0 < epsilon && d0 > -epsilon) {
            return false;
        }
        double d1 = MatrixUtilDouble.detM4(new double[]{node[0], node[1], node[2], 1.0, t1[0], t1[1], t1[2], 1.0, t2[0], t2[1], t2[2], 1.0, t3[0], t3[1], t3[2], 1.0});
        if (d0 > epsilon && d1 < -epsilon || d0 < -epsilon && d1 > epsilon) {
            return false;
        }
        double d2 = MatrixUtilDouble.detM4(new double[]{t0[0], t0[1], t0[2], 1.0, node[0], node[1], node[2], 1.0, t2[0], t2[1], t2[2], 1.0, t3[0], t3[1], t3[2], 1.0});
        if (d0 > epsilon && d2 < -epsilon || d0 < -epsilon && d2 > epsilon) {
            return false;
        }
        double d3 = MatrixUtilDouble.detM4(new double[]{t0[0], t0[1], t0[2], 1.0, t1[0], t1[1], t1[2], 1.0, node[0], node[1], node[2], 1.0, t3[0], t3[1], t3[2], 1.0});
        if (d0 > epsilon && d3 < -epsilon || d0 < -epsilon && d3 > epsilon) {
            return false;
        }
        double d4 = MatrixUtilDouble.detM4(new double[]{t0[0], t0[1], t0[2], 1.0, t1[0], t1[1], t1[2], 1.0, t2[0], t2[1], t2[2], 1.0, node[0], node[1], node[2], 1.0});
        return !(d0 > epsilon && d4 < -epsilon) && (!(d0 < -epsilon) || !(d4 > epsilon));
    }

    public static double[] tetrahedronBarycenter(Polyhedron tetra) {
        double[] t0 = new double[]{tetra.getVertexAt(0).getPoint().getCoord()[0], tetra.getVertexAt(0).getPoint().getCoord()[1], tetra.getVertexAt(0).getPoint().getCoord()[2]};
        double[] t1 = new double[]{tetra.getVertexAt(1).getPoint().getCoord()[0], tetra.getVertexAt(1).getPoint().getCoord()[1], tetra.getVertexAt(1).getPoint().getCoord()[2]};
        double[] t2 = new double[]{tetra.getVertexAt(2).getPoint().getCoord()[0], tetra.getVertexAt(2).getPoint().getCoord()[1], tetra.getVertexAt(2).getPoint().getCoord()[2]};
        double[] t3 = new double[]{tetra.getVertexAt(3).getPoint().getCoord()[0], tetra.getVertexAt(3).getPoint().getCoord()[1], tetra.getVertexAt(3).getPoint().getCoord()[2]};
        return new double[]{(t0[0] + t1[0] + t2[0] + t3[0]) / 4.0, (t0[1] + t1[1] + t2[1] + t3[1]) / 4.0, (t0[2] + t1[2] + t2[2] + t3[2]) / 4.0};
    }

    public static double[] triangleBarycenter(Face triangle) {
        double[] t0 = new double[]{triangle.getVertexAt(0).getPoint().getCoord()[0], triangle.getVertexAt(0).getPoint().getCoord()[1], triangle.getVertexAt(0).getPoint().getCoord()[2]};
        double[] t1 = new double[]{triangle.getVertexAt(1).getPoint().getCoord()[0], triangle.getVertexAt(1).getPoint().getCoord()[1], triangle.getVertexAt(1).getPoint().getCoord()[2]};
        double[] t2 = new double[]{triangle.getVertexAt(2).getPoint().getCoord()[0], triangle.getVertexAt(2).getPoint().getCoord()[1], triangle.getVertexAt(2).getPoint().getCoord()[2]};
        return new double[]{(t0[0] + t1[0] + t2[0]) / 3.0, (t0[1] + t1[1] + t2[1]) / 3.0, (t0[2] + t1[2] + t2[2]) / 3.0};
    }

    public static boolean isInsideBoundingBox(double[] barycentre, BoundingBox bbox) {
        if (barycentre[0] < bbox.getMin()[0]) {
            return false;
        }
        if (barycentre[1] < bbox.getMin()[1]) {
            return false;
        }
        if (barycentre[2] < bbox.getMin()[2]) {
            return false;
        }
        if (barycentre[0] > bbox.getMax()[0]) {
            return false;
        }
        if (barycentre[1] > bbox.getMax()[1]) {
            return false;
        }
        return !(barycentre[2] > bbox.getMax()[2]);
    }

    public static double[] computeVectorProduct(double[] firstVector, double[] secondVector) throws IllegalArgumentException {
        if (firstVector.length != 3 || firstVector.length != secondVector.length) {
            throw new IllegalArgumentException("the vector product asked is between a first vector with a dimension of : " + firstVector.length + ", and the dimension of the second vector is : " + secondVector.length);
        }
        double[] answer = new double[]{firstVector[1] * secondVector[2] - firstVector[2] * secondVector[1], firstVector[2] * secondVector[0] - firstVector[0] * secondVector[2], firstVector[0] * secondVector[1] - firstVector[1] * secondVector[0]};
        return answer;
    }

    public static void meshTranslation(double xTranslation, double yTranslation, double zTranslation, VertexMeshMask vertexMeshMask) {
        Iterator<Vertex> vertexIterator = vertexMeshMask.getMeshElementIterator();
        while (vertexIterator.hasNext()) {
            Vertex vertex = vertexIterator.next();
            double[] coord = vertex.getPoint().getCoord();
            coord[0] = coord[0] + xTranslation;
            coord[1] = coord[1] + yTranslation;
            coord[2] = coord[2] + zTranslation;
        }
    }

    public static void meshTranslation(double xTranslation, double yTranslation, double zTranslation, EdgeMeshMask edgeMeshMask) {
        Iterator<Edge> edgeIterator = edgeMeshMask.getMeshElementIterator();
        SingleVertexIterator singleVertexIterator = new SingleVertexIterator(edgeIterator);
        while (singleVertexIterator.hasNext()) {
            Vertex vertex = singleVertexIterator.next();
            double[] coord = vertex.getPoint().getCoord();
            coord[0] = coord[0] + xTranslation;
            coord[1] = coord[1] + yTranslation;
            coord[2] = coord[2] + zTranslation;
        }
    }

    public static void meshTranslation(double xTranslation, double yTranslation, double zTranslation, FaceMeshMask faceMeshMask) {
        Iterator<Face> faceIterator = faceMeshMask.getMeshElementIterator();
        SingleVertexIterator singleVertexIterator = new SingleVertexIterator(faceIterator);
        while (singleVertexIterator.hasNext()) {
            Vertex vertex = singleVertexIterator.next();
            double[] coord = vertex.getPoint().getCoord();
            coord[0] = coord[0] + xTranslation;
            coord[1] = coord[1] + yTranslation;
            coord[2] = coord[2] + zTranslation;
        }
    }

    public static void meshTranslation(double xTranslation, double yTranslation, double zTranslation, PolyhedronMeshMask polyhedronMeshMask) {
        Iterator<Polyhedron> polyhedronIterator = polyhedronMeshMask.getMeshElementIterator();
        SingleVertexIterator singleVertexIterator = new SingleVertexIterator(polyhedronIterator);
        while (singleVertexIterator.hasNext()) {
            Vertex vertex = singleVertexIterator.next();
            double[] coord = vertex.getPoint().getCoord();
            coord[0] = coord[0] + xTranslation;
            coord[1] = coord[1] + yTranslation;
            coord[2] = coord[2] + zTranslation;
        }
    }

    public static <ME extends MeshElement> void meshTranslation(double xTranslation, double yTranslation, double zTranslation, MeshMask<ME> meshMask) {
        MeshType meshType = meshMask.getMeshType();
        switch (meshType) {
            case EDGE: {
                GeometryUtil.meshTranslation(xTranslation, yTranslation, zTranslation, (EdgeMeshMask)meshMask);
                break;
            }
            case FACE: {
                GeometryUtil.meshTranslation(xTranslation, yTranslation, zTranslation, (FaceMeshMask)meshMask);
                break;
            }
            case POLYHEDRON: {
                GeometryUtil.meshTranslation(xTranslation, yTranslation, zTranslation, (PolyhedronMeshMask)meshMask);
                break;
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException("the mesh mask :\n" + meshMask + ", can not be translated because this mesh mask is define on a dimansion (vertex, edge, face, polyhedron) wich is not define!");
            }
            case VERTEX: {
                GeometryUtil.meshTranslation(xTranslation, yTranslation, zTranslation, (VertexMeshMask)meshMask);
            }
        }
    }
}

