/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkOBJReader;
import vtk.vtkPolyDataMapper;

public class ImportFromOBJ
implements ActionListener {
    private PipeLineManager pipelineManager;
    private Frame owner;
    private vtkOBJReader reader;

    public ImportFromOBJ(PipeLineManager pipelineManager, Frame owner) {
        this.pipelineManager = pipelineManager;
        this.owner = owner;
        this.reader = new vtkOBJReader();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".obj");
            }

            @Override
            public String getDescription() {
                return "OBJ files";
            }
        });
        if (chooser.showOpenDialog(this.owner) == 0) {
            String file = chooser.getSelectedFile().getAbsolutePath();
            try {
                this.reader.SetFileName(file);
                this.reader.Update();
                this.pipelineManager.addDataSet((Object)this.reader.GetOutput(), chooser.getSelectedFile().getName());
                vtkPolyDataMapper mapper = new vtkPolyDataMapper();
                mapper.SetInput(this.reader.GetOutput());
                this.pipelineManager.addMapper((Object)mapper, "");
                vtkActor actor = new vtkActor();
                actor.SetMapper((vtkMapper)mapper);
                this.pipelineManager.addActor((Object)actor, "");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this.owner, "Unable to load: " + file);
            }
        }
    }
}

