/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.list;

import com.artenum.tk.ui.api.ListItem;
import com.artenum.tk.ui.api.SingleSelectionListener;
import com.artenum.tk.ui.api.SingleSelectionValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SingleSelectionInput
extends DefaultComboBoxModel
implements SingleSelectionValue,
ActionListener {
    private static final long serialVersionUID = 1L;
    private ArrayList<SingleSelectionListener> listeners = new ArrayList();
    private ArrayList<ListItem> data = new ArrayList();
    private JComboBox selector = new JComboBox(this);
    private String defaultValue;
    private JPanel ui;

    public SingleSelectionInput(String name) {
        this.selector.addActionListener(this);
        this.ui = new JPanel();
        this.ui.setLayout(new BoxLayout(this.ui, 0));
        this.ui.add(new JLabel(name));
        this.ui.add(Box.createHorizontalStrut(5));
        this.ui.add(this.selector);
    }

    @Override
    public void addSingleSelectionListener(SingleSelectionListener l) {
        this.listeners.add(l);
    }

    @Override
    public String getSelectedValue() {
        return ((ListItem)this.selector.getSelectedItem()).getValue();
    }

    @Override
    public JComponent getUI() {
        return this.ui;
    }

    @Override
    public void removeSingleSelectionListener(SingleSelectionListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        if (defaultValue != null) {
            int index = 0;
            for (ListItem item : this.data) {
                if (item.getValue().equals(defaultValue)) break;
                ++index;
            }
            if (this.data.size() > 0 && this.data.size() > index) {
                this.selector.setSelectedIndex(index);
            } else {
                this.selector.setSelectedIndex(0);
            }
        }
    }

    @Override
    public void setValues(List<ListItem> items) {
        this.data.clear();
        this.data.addAll(items);
        this.update();
    }

    public void update() {
        this.fireContentsChanged(this, 0, this.getSize());
        if (this.getSize() > 0 && this.defaultValue != null) {
            this.setDefaultValue(this.defaultValue);
        } else {
            this.setSelectedItem("");
        }
    }

    @Override
    public Object getElementAt(int indice) {
        return this.data.get(indice);
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        for (SingleSelectionListener l : this.listeners) {
            l.singleSelectionChanged(this.getSelectedValue());
        }
    }
}

