/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.io;

import com.artenum.jyconsole.ui.Prompt;
import java.awt.FontMetrics;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;

public class InteractiveCommandLine
implements DocumentListener {
    private String styleName;
    private StyledDocument doc;
    private JTextPane uiPart;
    private Prompt prompt;
    private boolean needToUpdateCompletionModel;
    private String completionPart;
    private int completionCmdPos;
    private String filterPart;
    private int filterPos;
    private StringBuffer txtBefore;
    private String txtAfter;

    public InteractiveCommandLine(StyledDocument styledDocument, JTextPane jTextPane, Prompt prompt, String string) {
        this.doc = styledDocument;
        this.styleName = string;
        this.uiPart = jTextPane;
        this.prompt = prompt;
        styledDocument.addDocumentListener(this);
        this.needToUpdateCompletionModel = true;
    }

    public int getCaretPosition() {
        return this.uiPart.getCaretPosition();
    }

    public String getCmdLine() {
        try {
            return this.doc.getText(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
    }

    public void append(String string) {
        try {
            this.doc.insertString(this.getCaretPosition(), string, this.doc.getStyle(this.styleName));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.prompt.updateLineView();
    }

    public void reset() {
        try {
            this.doc.remove(0, this.doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.uiPart.setCaretPosition(0);
        this.prompt.updateLineView();
    }

    public Point getCaretPositionPoint() {
        FontMetrics fontMetrics = this.uiPart.getFontMetrics(this.uiPart.getFont());
        int n = 1;
        int n2 = 0;
        int n3 = -1;
        String string = "";
        try {
            string = this.doc.getText(0, this.getCaretPosition());
        }
        catch (Exception exception) {
            // empty catch block
        }
        while ((n3 = string.indexOf("\n")) != -1) {
            n2 += n3 + 1;
            string = string.substring(n3 + 1);
            ++n;
        }
        try {
            return new Point(fontMetrics.stringWidth(this.doc.getText(n2, this.filterPos + 1 - n2)) + 4, n * fontMetrics.getHeight() + 2);
        }
        catch (BadLocationException badLocationException) {
            return new Point(0, 0);
        }
    }

    public boolean askForDictionnary() {
        if (this.needToUpdateCompletionModel) {
            this.updateCompletionModel();
        }
        return this.completionPart.length() == 0 || this.completionPart.equals(this.filterPart);
    }

    public String getCompletionCmd() {
        if (this.needToUpdateCompletionModel) {
            this.updateCompletionModel();
        }
        return this.completionPart;
    }

    public String getFilterCmd() {
        if (this.needToUpdateCompletionModel) {
            this.updateCompletionModel();
        }
        return this.filterPart;
    }

    public void setCompletionCmd(String string) {
        try {
            this.doc.remove(this.completionCmdPos, this.completionPart.length());
            this.doc.insertString(this.completionCmdPos, string, this.doc.getStyle("default"));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.uiPart.setCaretPosition(this.completionCmdPos + string.length());
    }

    public void setFilteredCmd(String string) {
        try {
            this.doc.remove(this.filterPos + 1, this.filterPart.length());
            this.doc.insertString(this.filterPos + 1, string, this.doc.getStyle("default"));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.uiPart.setCaretPosition(this.filterPos + 1 + string.length());
    }

    private void updateCompletionModel() {
        StringBuffer stringBuffer = new StringBuffer(this.doc.getLength());
        try {
            stringBuffer.append(this.doc.getText(0, this.doc.getLength()));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.txtBefore = new StringBuffer();
        this.txtAfter = stringBuffer.substring(this.uiPart.getCaretPosition());
        stringBuffer.delete(this.uiPart.getCaretPosition(), stringBuffer.length());
        if (stringBuffer.indexOf("\n") != -1) {
            this.txtBefore.append(stringBuffer.substring(0, stringBuffer.lastIndexOf("\n")));
            stringBuffer.delete(0, stringBuffer.lastIndexOf("\n"));
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '(') {
                arrayList.add(new Integer(i));
            }
            if (stringBuffer.charAt(i) != ')') continue;
            arrayList.remove(arrayList.size() - 1);
        }
        if (arrayList.size() > 0) {
            this.txtBefore.append(stringBuffer.substring(0, 1 + (Integer)arrayList.get(arrayList.size() - 1)));
            stringBuffer.delete(0, 1 + (Integer)arrayList.get(arrayList.size() - 1));
        }
        if (stringBuffer.indexOf(" ") != -1) {
            this.txtBefore.append(stringBuffer.substring(0, stringBuffer.lastIndexOf(" ") + 1));
            stringBuffer.delete(0, stringBuffer.lastIndexOf(" ") + 1);
        }
        this.completionPart = stringBuffer.toString();
        if (stringBuffer.indexOf(".") != -1) {
            this.completionPart = stringBuffer.toString().substring(0, stringBuffer.lastIndexOf("."));
            stringBuffer.delete(0, stringBuffer.lastIndexOf(".") + 1);
        }
        this.filterPart = stringBuffer.toString();
        this.completionCmdPos = this.txtBefore.length();
        this.filterPos = this.completionCmdPos + this.completionPart.length();
        this.needToUpdateCompletionModel = false;
    }

    public void backSpace() {
        try {
            if (this.getCaretPosition() > 0) {
                this.doc.remove(this.getCaretPosition() - 1, 1);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.needToUpdateCompletionModel = true;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.needToUpdateCompletionModel = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.needToUpdateCompletionModel = true;
    }

    public void getFocus() {
        this.uiPart.grabFocus();
    }
}

