/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field;

import com.artenum.penelope.field.interfaces.DataArray;
import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Identifiable;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Unit;

public abstract class AbstractDataField<DataType, MeshElementType extends MeshElement>
implements DataField<DataType, MeshElementType> {
    private int id = -1;
    private String name;
    private String description = "";
    private final MeshType localisation;
    private boolean isValid = false;
    private int timeStamp = -1;
    private Unit unit;
    private MeshType vtkFormatPrefered;
    private MeshMask<MeshElementType> meshMask;
    private DataArray<DataType> dataArray = null;

    public AbstractDataField(int id, MeshType meshType, String name, String description, MeshMask<MeshElementType> meshField) {
        this(id, meshType, name, description, meshField, null);
    }

    public AbstractDataField(int id, MeshType meshType, String name, String aDescription, MeshMask<MeshElementType> meshField, DataArray<DataType> dataArray) {
        this.id = id;
        this.localisation = meshType;
        this.name = name;
        if (aDescription != null) {
            this.description = aDescription;
        }
        this.meshMask = meshField;
        this.dataArray = dataArray;
        if (this.meshMask != null) {
            this.meshMask.addDataField(this);
        }
    }

    @Override
    public void setDataArray(DataArray<DataType> dataArray) {
        this.dataArray = dataArray;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getBeautifiedName() {
        char[] bannedChar = new char[]{' ', '/', '\\', '*', '$', '@', '#', '&', '\"', '\'', '(', ')', '{', '}', '[', ']', '=', '+', '?', ':', ';', '%'};
        int REPLACEMENT_CHAR = 95;
        String beautifiedName = this.getName();
        for (int i = 0; i < bannedChar.length; ++i) {
            beautifiedName = beautifiedName.replace(bannedChar[i], '_');
        }
        return beautifiedName;
    }

    @Override
    public void setDescription(String aDescription) {
        this.description = aDescription != null ? aDescription : "";
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MeshType getMeshType() {
        return this.localisation;
    }

    @Override
    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    @Override
    public Unit getUnit() {
        return this.unit;
    }

    @Override
    public void setMeshMask(MeshMask<MeshElementType> meshMask) {
        this.meshMask = meshMask;
        this.meshMask.addDataField(this);
    }

    @Override
    public MeshMask<MeshElementType> getMeshMask() {
        return this.meshMask;
    }

    public int getIdOfLinkedMeshField() {
        if (this.meshMask != null) {
            return this.meshMask.getId();
        }
        return -1;
    }

    @Override
    public int getNbMeshElements() {
        return this.dataArray.getNbData();
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(int timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public String getMetaDataAsString() {
        return this.getId() + "\n" + this.getName() + "\n" + this.getDescription() + "\n" + (Object)((Object)this.getMeshType()) + "\n" + this.getNbMeshElements() + "\n" + this.getIdOfLinkedMeshField() + "\n";
    }

    @Override
    public int compareTo(Identifiable o) {
        return this.getId() - o.getId();
    }

    @Override
    public DataArray<DataType> getDataArray() {
        return this.dataArray;
    }

    public String toString() {
        return "AbstractDataField [id=" + this.id + ", name=" + this.name + ", localisation=" + (Object)((Object)this.localisation) + ", isValid=" + this.isValid + ", timeStamp=" + this.timeStamp + ", unit=" + this.unit + ", meshMask=" + this.meshMask + ", dataArray=" + this.dataArray + "]";
    }

    @Override
    public MeshType getVtkFormatPrefered() {
        return this.vtkFormatPrefered;
    }

    @Override
    public void setVtkFormatPrefered(MeshType vtkFormatPrefered) {
        this.vtkFormatPrefered = vtkFormatPrefered;
    }
}

