/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field.data;

import com.artenum.penelope.field.data.AbstractDataArray;
import com.artenum.penelope.field.data.DataType;
import java.util.Arrays;

public class TupleOfIntDataArray
extends AbstractDataArray<int[]> {
    private final int[][] tupleArray;
    private int dim = 1;

    public TupleOfIntDataArray(int dim) {
        this.nbData = 0;
        this.dim = dim;
        this.tupleArray = new int[dim][40960];
    }

    public TupleOfIntDataArray(int dim, int size) {
        this.nbData = 0;
        this.dim = dim;
        this.tupleArray = new int[dim][size];
    }

    public TupleOfIntDataArray(int[][] tupleArray) {
        this.tupleArray = tupleArray;
        this.dim = tupleArray.length;
        this.nbData = tupleArray[0] != null ? tupleArray[0].length : 0;
    }

    @Override
    public void set(int index, int[] tuple) {
        for (int col = 0; col < this.dim; ++col) {
            this.tupleArray[col][index] = tuple[col];
        }
        if (index > this.currentLastIndex) {
            this.currentLastIndex = index;
        }
    }

    @Override
    public int[] get(int index) {
        int[] tuple = new int[this.dim];
        for (int col = 0; col < tuple.length; ++col) {
            tuple[col] = this.tupleArray[col][index];
        }
        return tuple;
    }

    @Override
    public void add(int[] tuple) {
        if (this.currentLastIndex > this.tupleArray[0].length - 1) {
            this.extendArraySize(this.tupleArray[0].length + 40960);
        }
        for (int col = 0; col < this.dim; ++col) {
            int value = tuple[col];
            int[] is = this.tupleArray[col];
            is[this.currentLastIndex] = value;
        }
        ++this.currentLastIndex;
        ++this.nbData;
    }

    @Override
    public void extendArraySize(int newSize) {
        for (int col = 0; col < this.dim; ++col) {
            int[] newArray = new int[newSize];
            System.arraycopy(this.tupleArray[col], 0, newArray, 0, this.tupleArray[col].length);
            this.tupleArray[col] = newArray;
        }
    }

    @Override
    public void packArray() {
        for (int col = 0; col < this.dim; ++col) {
            int[] newArray = new int[this.nbData];
            System.arraycopy(this.tupleArray[col], 0, newArray, 0, this.nbData);
            this.tupleArray[col] = newArray;
        }
    }

    @Override
    public int getArraySize() {
        return this.tupleArray.length;
    }

    @Override
    public int getNbData() {
        return this.nbData;
    }

    @Override
    public int getDataDimension() {
        return this.dim;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dim;
        result = 31 * result + Arrays.hashCode((Object[])this.tupleArray);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleOfIntDataArray other = (TupleOfIntDataArray)obj;
        if (this.dim != other.dim) {
            return false;
        }
        return Arrays.equals((Object[])this.tupleArray, (Object[])other.tupleArray);
    }

    @Override
    public DataType getDataType() {
        return DataType.INT;
    }
}

