/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.element.AbstractFace;
import com.artenum.penelope.mesh.element.Segment;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Vertex;

public class Triangle
extends AbstractFace {
    public Triangle(int uniqueId, Mesh aMesh, Vertex firstVertex, Vertex secondVertex, Vertex thirdVertex) {
        super(uniqueId, 3, aMesh, firstVertex, secondVertex, thirdVertex);
    }

    public Triangle(int uniqueId, Mesh aMesh, Vertex firstVertex, Vertex secondVertex, Vertex thirdVertex, int firstEdgeId, int secondEdgeId, int thirdEdgeId) {
        super(uniqueId, 3, aMesh, firstVertex, secondVertex, thirdVertex);
        this.getEdgeIds()[0] = firstEdgeId;
        this.getEdgeIds()[1] = secondEdgeId;
        this.getEdgeIds()[2] = thirdEdgeId;
    }

    public Triangle(Mesh aMesh, Vertex firstVertex, Vertex secondVertex, Vertex thirdVertex) {
        super(3, aMesh, firstVertex, secondVertex, thirdVertex);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" com.artenum.penelope.mesh.element.Triangle(id:");
        stringBuilder.append(this.getId());
        stringBuilder.append("), on vertices: ");
        boolean first = true;
        for (Vertex vertex : this.getVertices()) {
            if (first) {
                first = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(vertex.getId());
        }
        return stringBuilder.toString();
    }

    @Override
    public Edge getEdgeAt(int position) {
        Segment edge = null;
        switch (position) {
            case 0: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(0), this.getVertexAt(1));
                break;
            }
            case 1: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(1), this.getVertexAt(2));
                break;
            }
            case 2: {
                edge = new Segment(this.getEdgeIds()[position], this.getMesh(), this.getVertexAt(2), this.getVertexAt(0));
                break;
            }
            default: {
                throw new RuntimeException("Edge number outside the range\nposition is : " + position);
            }
        }
        return edge;
    }

    @Override
    public Edge[] getEdgesOnVertexAt(int position) {
        Edge[] edges = new Edge[2];
        switch (position) {
            case 0: {
                edges[0] = this.getEdgeAt(0);
                edges[1] = this.getEdgeAt(2);
                break;
            }
            case 1: {
                edges[0] = this.getEdgeAt(0);
                edges[1] = this.getEdgeAt(1);
                break;
            }
            case 2: {
                edges[0] = this.getEdgeAt(1);
                edges[1] = this.getEdgeAt(2);
                break;
            }
            default: {
                throw new RuntimeException("Node position outside the range");
            }
        }
        return edges;
    }

    @Override
    public int[] getVertexPositionsOnEdge(int edgePosition) {
        int[] positionsList = new int[2];
        switch (edgePosition) {
            case 0: {
                positionsList[0] = 0;
                positionsList[1] = 1;
                break;
            }
            case 1: {
                positionsList[0] = 1;
                positionsList[1] = 2;
                break;
            }
            case 2: {
                positionsList[0] = 2;
                positionsList[1] = 0;
                break;
            }
            default: {
                throw new RuntimeException("Edge number outside the range");
            }
        }
        return positionsList;
    }

    @Override
    public Vertex[] getVerticesOnEdgeAt(int edgePosition) {
        Vertex[] idsList = new Vertex[2];
        switch (edgePosition) {
            case 0: {
                idsList[0] = this.getVertices()[0];
                idsList[1] = this.getVertices()[1];
                break;
            }
            case 1: {
                idsList[0] = this.getVertices()[1];
                idsList[1] = this.getVertices()[2];
                break;
            }
            case 2: {
                idsList[0] = this.getVertices()[2];
                idsList[1] = this.getVertices()[0];
                break;
            }
            default: {
                throw new RuntimeException("Edge number outside the range");
            }
        }
        return idsList;
    }
}

