/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import vtk.vtkLookupTable;

public class VtkObjectUI2
extends JLabel
implements VtkObjectUI {
    private CassandraObject object;
    protected final Dimension size = new Dimension(59, 66);
    protected Point position;
    protected String txt;
    protected ImageIcon glassIcon;
    protected ImageIcon glassIcon2;
    protected ImageIcon icon;
    protected int leftMarging = 0;
    protected Font iconTextFont;
    private final int deltaX = 75;
    private final int deltaY = 60;

    public int getDeltaX() {
        return 75;
    }

    public int getDeltaY() {
        return 60;
    }

    public VtkObjectUI2(CassandraObject object) {
        this.object = object;
        this.position = new Point(10, 10);
        this.iconTextFont = new Font("Lucida Grande", 0, 10);
        this.txt = object.getName();
        this.setToolTipText(this.txt);
        if (this.txt.length() > 8) {
            this.txt = this.txt.substring(0, 8);
            this.txt = this.txt + "...";
        }
        switch (object.getType()) {
            case 1: {
                this.icon = VtkObjectUI2.createImageIcon("icon/actor.png", "Actor");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/actorEye.png", "Visible");
                this.position.x = 75 * (this.leftMarging + 3);
                this.position.y += (object.getLocalTypeId() - 1) * 60;
                break;
            }
            case 2: {
                this.icon = VtkObjectUI2.createImageIcon("icon/mapper.png", "Mapper");
                this.txt = "";
                this.position.x = 75 * (this.leftMarging + 2);
                this.position.y += (object.getLocalTypeId() - 1) * 60;
                break;
            }
            case 3: {
                this.icon = VtkObjectUI2.createImageIcon("icon/dataset.png", "DataSet");
                this.position.x = 75 * (this.leftMarging + 1);
                this.position.y += (object.getLocalTypeId() - 1) * 60;
                break;
            }
            case 4: {
                this.icon = VtkObjectUI2.createImageIcon("icon/filter.png", "Filter");
                this.position.x = 75 * this.leftMarging;
                this.position.y += (object.getLocalTypeId() - 1) * 60;
                break;
            }
            case 5: {
                this.icon = VtkObjectUI2.createImageIcon("icon/lookuptable.png", "Lookup Table");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/linearLT.png", "Lookup Table");
                this.glassIcon2 = VtkObjectUI2.createImageIcon("icon/logLT.png", "Lookup Table");
                this.position.x = 75 * (this.leftMarging + 4);
                this.position.y += (object.getLocalTypeId() - 1) * 60;
                break;
            }
            case 6: {
                this.icon = VtkObjectUI2.createImageIcon("icon/scalarBar.png", "ScalarBar");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/actorEye.png", "Visible");
                this.position.x = 75 * (this.leftMarging + 5);
                this.position.y += (object.getLocalTypeId() - 1) * 60;
                break;
            }
            case 7: {
                this.icon = VtkObjectUI2.createImageIcon("icon/txtActor.png", "Text actor");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/txtActorEye.png", "Visible");
                this.position.x = 75 * (this.leftMarging + 6);
                this.position.y += (object.getLocalTypeId() - 1) * 60;
            }
        }
        this.setIcon(this.icon);
    }

    @Override
    public void setName(String newName) {
        this.txt = newName;
        this.repaint();
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = VtkObjectCellAdapter.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + imgURL);
        return null;
    }

    public void savePosition() {
        this.position = this.getLocation();
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    public void setPosition(Point p) {
        this.position = p;
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if ((this.object.getType() == 1 || this.object.getType() == 6 || this.object.getType() == 7) && this.object.getMetaData().get("ACTOR_VISIBLE") != null) {
            if (((String)this.object.getMetaData().get("ACTOR_VISIBLE")).equals("true")) {
                g.drawImage(this.glassIcon.getImage(), 0, 0, this.glassIcon.getImageObserver());
            }
        } else if (this.object.getType() == 5) {
            if (((vtkLookupTable)this.object.getVtkObject()).GetScale() == 0) {
                g.drawImage(this.glassIcon.getImage(), 0, 0, this.glassIcon.getImageObserver());
            } else {
                g.drawImage(this.glassIcon2.getImage(), 0, 0, this.glassIcon2.getImageObserver());
            }
        }
        Rectangle2D txtR = g.getFontMetrics().getStringBounds(this.txt, g);
        g.setFont(this.iconTextFont);
        int dx = (int)(this.size.getWidth() - txtR.getWidth()) / 2;
        if (dx < 0) {
            dx = 0;
        }
        g.drawString(this.txt, dx, 50);
    }
}

