/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.popup.ActorPopupMenu;
import com.artenum.cassandra.ui.popup.DataSetPopupMenu;
import com.artenum.cassandra.ui.popup.LookupTablePopupMenu;
import com.artenum.cassandra.ui.popup.MapperPopupMenu;
import com.artenum.cassandra.ui.popup.ScalarBarPopupMenu;
import com.artenum.cassandra.ui.popup.TxtActorPopupMenu;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import java.awt.Component;
import javax.swing.JPopupMenu;

public class VtkObjectPopupMenuDipatcher {
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private CassandraObject vtkObject;
    private JPopupMenu currentMenu;
    private DataSetPopupMenu dataSetMenu;
    private LookupTablePopupMenu lookupTableMenu;
    private ActorPopupMenu actorMenu;
    private TxtActorPopupMenu txtActorMenu;
    private ScalarBarPopupMenu scalarBarMenu;
    private MapperPopupMenu mapperMenu;

    public VtkObjectPopupMenuDipatcher(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        CascadeRemoveManager crm = new CascadeRemoveManager(pipeLineManager);
        this.dataSetMenu = new DataSetPopupMenu(pipeLineManager, crm);
        this.lookupTableMenu = new LookupTablePopupMenu(pipeLineManager, crm);
        this.actorMenu = new ActorPopupMenu(pipeLineManager, crm);
        this.txtActorMenu = new TxtActorPopupMenu(pipeLineManager, crm);
        this.scalarBarMenu = new ScalarBarPopupMenu(pipeLineManager, crm);
        this.mapperMenu = new MapperPopupMenu(pipeLineManager, crm);
    }

    private JPopupMenu getPopup() {
        JPopupMenu result = (JPopupMenu)this.vtkObject.getMetaData().get("POPUP_MENU");
        if (result != null) {
            return result;
        }
        switch (this.vtkObject.getType()) {
            case 1: {
                return this.actorMenu;
            }
            case 6: {
                return this.scalarBarMenu;
            }
            case 7: {
                return this.txtActorMenu;
            }
            case 2: {
                return this.mapperMenu;
            }
            case 3: {
                return this.dataSetMenu;
            }
            case 5: {
                return this.lookupTableMenu;
            }
        }
        return null;
    }

    public void showPopupMenu(Component invoker, int x, int y, CassandraObject vtkObject2) {
        this.vtkObject = vtkObject2;
        this.currentMenu = this.getPopup();
        if (this.currentMenu != null) {
            if (this.currentMenu instanceof VtkObjectPopupMenu) {
                ((VtkObjectPopupMenu)((Object)this.currentMenu)).setCurrentVtkOject(vtkObject2);
            }
            this.currentMenu.show(invoker, x, y);
        }
    }
}

