/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import vtk.vtkActor;
import vtk.vtkCutter;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkImplicitFunction;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;

public class CuttingPlanePipeLine {
    private vtkDataSet dataset;
    private vtkPolyDataMapper mapper;
    private vtkActor actor;
    private double nx;
    private double ny;
    private double nz;
    private double cx;
    private double cy;
    private double cz;
    private vtkPlane plane;
    private vtkCutter planeCut;

    public CuttingPlanePipeLine(vtkDataSet dataset, double nx, double ny, double nz, double cx, double cy, double cz) {
        this.dataset = dataset;
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.plane = new vtkPlane();
        this.plane.SetOrigin(cx, cy, cz);
        this.plane.SetNormal(nx, ny, nz);
        this.planeCut = new vtkCutter();
        this.planeCut.SetCutFunction((vtkImplicitFunction)this.plane);
        this.planeCut.SetInput((vtkDataObject)dataset);
        this.mapper = new vtkPolyDataMapper();
        this.mapper.SetInput(this.planeCut.GetOutput());
        this.mapper.SetScalarRange(dataset.GetPointData().GetScalars().GetRange());
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)this.mapper);
        dataset.Update();
    }

    public void setNormal(double nx, double ny, double nz) {
        this.nx = nx;
        this.ny = ny;
        this.nz = nz;
        this.plane.SetNormal(nx, ny, nz);
        this.planeCut.Update();
    }

    public void setOrigine(double cx, double cy, double cz) {
        this.cx = cx;
        this.cy = cy;
        this.cz = cz;
        this.plane.SetOrigin(cx, cy, cz);
        this.planeCut.Update();
    }

    public void updatePipeLine() {
        this.dataset.Update();
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public vtkDataSet getDataset() {
        return this.dataset;
    }

    public vtkMapper getMapper() {
        return this.mapper;
    }
}

