/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.geo.model;

import com.artenum.penelope.plugin.gmsh.geo.model.GeoGroup;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class GeoGroupReader {
    private static final String GROUP = "Physical";
    private static final String GROUP_TYPE_POINT = "Point";
    private static final String GROUP_TYPE_LINE = "Line";
    private static final String GROUP_TYPE_SURFACE = "Surface";
    private static final String GROUP_TYPE_VOLUME = "Volume";
    private final ArrayList<GeoGroup> geoGroups = new ArrayList();
    private String currentLine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(String filePath, boolean clearPreviousGroup) throws IOException {
        if (clearPreviousGroup) {
            this.geoGroups.clear();
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(filePath));
            while ((this.currentLine = br.readLine()) != null) {
                if (!this.currentLine.startsWith(GROUP)) continue;
                this.currentLine = this.currentLine.substring(0, this.currentLine.indexOf("="));
                if (this.currentLine.indexOf(GROUP_TYPE_POINT) != -1) {
                    this.geoGroups.add(new GeoGroup(this.extractId(this.currentLine), 0));
                    continue;
                }
                if (this.currentLine.indexOf(GROUP_TYPE_LINE) != -1) {
                    this.geoGroups.add(new GeoGroup(this.extractId(this.currentLine), 1));
                    continue;
                }
                if (this.currentLine.indexOf(GROUP_TYPE_SURFACE) != -1) {
                    this.geoGroups.add(new GeoGroup(this.extractId(this.currentLine), 2));
                    continue;
                }
                if (this.currentLine.indexOf(GROUP_TYPE_VOLUME) == -1) continue;
                this.geoGroups.add(new GeoGroup(this.extractId(this.currentLine), 3));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private int extractId(String line) {
        int a = line.indexOf(40) + 1;
        int b = line.indexOf(41);
        return Integer.parseInt(line.substring(a, b).trim());
    }

    public ArrayList<GeoGroup> getGeoGroups() {
        return this.geoGroups;
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        System.out.println("Start reading file: " + args[0]);
        GeoGroupReader geoReader = new GeoGroupReader();
        geoReader.readFile(args[0], true);
        long endTime = System.currentTimeMillis();
        System.out.println("Reading time: " + (endTime - startTime) + " ms");
        ArrayList<GeoGroup> geoGroups = geoReader.getGeoGroups();
        System.out.println("Found " + geoGroups.size() + " groups.");
        for (GeoGroup geoGroup : geoGroups) {
            System.out.println(geoGroup);
        }
    }
}

