/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Iterator;
import vtk.vtkAbstractArray;
import vtk.vtkDataArray;
import vtk.vtkDataSet;
import vtk.vtkFloatArray;
import vtk.vtkIdList;
import vtk.vtkPoints;
import vtk.vtkUnstructuredGrid;

public class Line3dWithData {
    private ArrayList pointList = new ArrayList();
    private ArrayList dataList = new ArrayList();
    private vtkUnstructuredGrid grid = null;
    private int[] nbParamByData;

    public Line3dWithData(int[] nbParamByData) {
        this.nbParamByData = nbParamByData;
    }

    public void load(String filePath) throws IOException {
        FileReader fr = new FileReader(filePath);
        LineNumberReader lnr = new LineNumberReader(fr);
        String line = null;
        String[] split = null;
        double[] point = new double[3];
        DataObject data = null;
        while ((line = lnr.readLine()) != null) {
            split = line.split(" ");
            int currentIndex = 0;
            System.out.println("A");
            data = new DataObject(this.nbParamByData);
            System.out.println("B");
            for (int i = 0; i < split.length; ++i) {
                System.out.println("C");
                if (split[i].trim().length() <= 0) continue;
                if (currentIndex < point.length) {
                    System.out.println("Set point: " + split[i]);
                    point[currentIndex++] = Double.parseDouble(split[i]);
                    continue;
                }
                System.out.println("Set data: " + split[i]);
                data.addData(Double.parseDouble(split[i]));
            }
            this.addPoint(point[0], point[1], point[2]);
            this.addData(data);
        }
        lnr.close();
    }

    public void addPoint(double x, double y, double z) {
        this.pointList.add(new double[]{x, y, z});
    }

    public void addData(DataObject data) {
        this.dataList.add(data);
    }

    public void reset() {
        this.pointList.clear();
        this.grid = null;
    }

    private void buildVtkDataSet() {
        Object point = null;
        vtkIdList idList = null;
        int id = 0;
        this.grid = new vtkUnstructuredGrid();
        this.grid.Allocate(this.pointList.size() - 1, this.pointList.size());
        vtkPoints points = new vtkPoints();
        vtkFloatArray pcoords = new vtkFloatArray();
        pcoords.SetNumberOfComponents(3);
        pcoords.SetNumberOfTuples(this.pointList.size());
        Iterator i = this.pointList.iterator();
        while (i.hasNext()) {
            points.InsertPoint(id++, (double[])i.next());
        }
        this.grid.SetPoints(points);
        for (int i2 = 0; i2 < id - 1; ++i2) {
            idList = new vtkIdList();
            idList.InsertNextId(i2);
            idList.InsertNextId(i2 + 1);
            this.grid.InsertNextCell(3, idList);
        }
        vtkDataArray currentVtkData = null;
        System.out.println("Param " + this.nbParamByData.length + " / " + this.dataList.size());
        for (int i3 = 0; i3 < this.nbParamByData.length; ++i3) {
            System.out.println("i: " + i3);
            currentVtkData = new vtkDataArray();
            currentVtkData.SetNumberOfComponents(this.dataList.size());
            currentVtkData.SetNumberOfTuples(this.nbParamByData[i3] * this.dataList.size());
            int currentNodeId = 0;
            block10: for (int j = i3; j < this.dataList.size(); j += i3) {
                System.out.println("j: " + j);
                double[] data = ((DataObject)this.dataList.get(j)).getDataAt(i3);
                System.out.println("nodeID: " + currentNodeId);
                switch (data.length) {
                    case 1: {
                        currentVtkData.InsertTuple1(currentNodeId++, data[0]);
                        continue block10;
                    }
                    case 2: {
                        currentVtkData.InsertTuple2(currentNodeId++, data[0], data[1]);
                        continue block10;
                    }
                    case 3: {
                        currentVtkData.InsertTuple3(currentNodeId++, data[0], data[1], data[2]);
                        continue block10;
                    }
                    case 4: {
                        currentVtkData.InsertTuple4(currentNodeId++, data[0], data[1], data[2], data[3]);
                        continue block10;
                    }
                    case 9: {
                        currentVtkData.InsertTuple9(currentNodeId++, data[0], data[1], data[2], data[3], data[4], data[5], data[6], data[7], data[8]);
                        continue block10;
                    }
                    default: {
                        throw new RuntimeException("DataSize on node of " + data.length + " data is not supported.");
                    }
                }
            }
            System.out.println("AddArray");
            System.out.flush();
            this.grid.GetPointData().AddArray((vtkAbstractArray)currentVtkData);
        }
        this.grid.Update();
    }

    public vtkDataSet getDataSet() {
        if (this.grid == null) {
            this.buildVtkDataSet();
        }
        return this.grid;
    }

    public class DataObject {
        private ArrayList data;
        private double[] currentData;
        private int currentDataIndex;
        private int currentIndex;

        public DataObject(int[] nbParamByData) {
            System.out.println("A a");
            this.data = new ArrayList();
            this.currentDataIndex = 0;
            this.currentIndex = 0;
            for (int i = 0; i < nbParamByData.length; ++i) {
                System.out.println("A b");
                this.currentData = new double[nbParamByData[i]];
                this.data.add(this.currentData);
            }
            System.out.println("A c");
            this.currentData = this.getDataAt(this.currentIndex++);
            System.out.println("A d");
        }

        public void addData(double value) {
            if (this.currentIndex == this.currentData.length) {
                this.currentIndex = 0;
                this.currentData = this.getDataAt(this.currentDataIndex++);
            }
            this.currentData[this.currentIndex++] = value;
        }

        public int getNbData() {
            return this.data.size();
        }

        public double[] getDataAt(int index) {
            return (double[])this.data.get(index);
        }
    }
}

