/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.defaults;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.defaults.Line3dWithData;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkMapper;

public class Open3DDataLineFile
implements ActionListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private Frame owner;
    private JComboBox input;

    public Open3DDataLineFile(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame owner) {
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.owner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Txt files";
            }
        });
        if (chooser.showOpenDialog(this.owner) == 0) {
            File[] files = chooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                try {
                    Line3dWithData line = new Line3dWithData(new int[]{1, 3});
                    line.load(files[i].getAbsolutePath());
                    vtkDataSetMapper mapper = new vtkDataSetMapper();
                    mapper.SetInput(line.getDataSet());
                    mapper.Update();
                    vtkActor actor = new vtkActor();
                    actor.SetMapper((vtkMapper)mapper);
                    this.pipelineManager.addDataSet((Object)line.getDataSet(), files[i].getName());
                    this.pipelineManager.addMapper((Object)mapper, files[i].getName());
                    this.pipelineManager.setActorVisible(this.pipelineManager.addActor((Object)actor, files[i].getName()), true);
                    continue;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(this.owner, "Unable to load: " + files[i].getAbsolutePath());
                }
            }
        }
    }
}

