/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.ColorSaxHandler;
import com.artenum.tk.color.ColorXMLWriter;
import com.artenum.tk.color.IConfigurableLookupTable;
import com.artenum.tk.color.ILookupTableListener;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LookupTable
implements IConfigurableLookupTable {
    private final Log logger = LogFactory.getLog(LookupTable.class);
    private static final Color DEFAULT_START_COLOR = Color.BLUE;
    private static final Color DEFAULT_COLOR1 = Color.CYAN;
    private static final Color DEFAULT_COLOR2 = Color.GREEN;
    private static final Color DEFAULT_COLOR3 = Color.YELLOW;
    private static final Color DEFAULT_END_COLOR = Color.RED;
    private static final int DEFAULT_COLORS_NB = 50;
    private Map<Integer, Color> colorPositions;
    private int colorsNb;
    private double minValue;
    private double maxValue;
    private Color[] colors;
    private List<ILookupTableListener> listeners;
    private String name;

    public LookupTable() {
        this.listeners = new LinkedList<ILookupTableListener>();
        this.colorsNb = 50;
        this.colorPositions = new HashMap<Integer, Color>();
        this.colorPositions.put(0, DEFAULT_START_COLOR);
        this.colorPositions.put(this.colorsNb / 4, DEFAULT_COLOR1);
        this.colorPositions.put(this.colorsNb / 2, DEFAULT_COLOR2);
        this.colorPositions.put(3 * this.colorsNb / 4, DEFAULT_COLOR3);
        this.colorPositions.put(this.colorsNb - 1, DEFAULT_END_COLOR);
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.buildLookupTable();
    }

    public LookupTable(IConfigurableLookupTable aLookupTable) {
        this.listeners = new LinkedList<ILookupTableListener>();
        this.colorPositions = new HashMap<Integer, Color>();
        this.colorsNb = aLookupTable.getNbColors();
        for (Integer i : aLookupTable.getColorPositionsMap().keySet()) {
            this.colorPositions.put(i, aLookupTable.getColorPositionsMap().get(i));
        }
        this.minValue = aLookupTable.getMinScalarValue();
        this.maxValue = aLookupTable.getMaxScalarValue();
        this.name = aLookupTable.getName();
        this.buildLookupTable();
    }

    public LookupTable(Color startingColor, Color endingColor, Map<Integer, Color> intermediateColorsPositions, int nbColors) {
        this.colorsNb = nbColors;
        this.listeners = new LinkedList<ILookupTableListener>();
        this.colorPositions = new HashMap<Integer, Color>();
        this.colorPositions.put(0, startingColor);
        this.colorPositions.put(this.colorsNb - 1, endingColor);
        for (Integer i : intermediateColorsPositions.keySet()) {
            if (i < this.colorsNb - 1 && i > 0) continue;
            this.logger.error((Object)"Colors outside the color table !");
            return;
        }
        this.colorPositions.putAll(intermediateColorsPositions);
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.buildLookupTable();
    }

    public LookupTable(File xmlFile) {
        this.listeners = new LinkedList<ILookupTableListener>();
        this.minValue = 0.0;
        this.maxValue = 100.0;
        this.readFromXML(xmlFile);
    }

    private void buildLookupTable() {
        this.colors = new Color[this.colorsNb];
        LinkedList<Integer> indexes = new LinkedList<Integer>(this.colorPositions.keySet());
        Collections.sort(indexes);
        indexes.remove(0);
        int iMin = 0;
        this.colors[0] = this.colorPositions.get(0);
        for (Integer index : indexes) {
            int iMax = index;
            Color startColor = this.colorPositions.get(iMin);
            Color endColor = this.colorPositions.get(iMax);
            for (int i = iMin + 1; i < iMax; ++i) {
                float ratio = (float)(i - iMin) / (float)(iMax - iMin);
                int red = (int)((float)endColor.getRed() * ratio + (float)startColor.getRed() * (1.0f - ratio));
                int green = (int)((float)endColor.getGreen() * ratio + (float)startColor.getGreen() * (1.0f - ratio));
                int blue = (int)((float)endColor.getBlue() * ratio + (float)startColor.getBlue() * (1.0f - ratio));
                try {
                    this.colors[i] = new Color(red, green, blue);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    System.out.println("i = " + i + " / IMin = " + iMin + " / iMax = " + iMax);
                    System.out.println("ratio = " + ratio);
                    System.out.println("RGB = " + red + " " + green + " " + blue);
                }
            }
            this.colors[iMax] = endColor;
            iMin = index;
        }
    }

    @Override
    public int getColorIndex(double value) {
        if (value < this.minValue) {
            return 0;
        }
        if (value >= this.maxValue) {
            return this.colorsNb - 1;
        }
        return (int)((double)this.colorsNb * (value - this.minValue) / (this.maxValue - this.minValue));
    }

    @Override
    public final Color getColor(double value) {
        return this.colors[this.getColorIndex(value)];
    }

    @Override
    public final Color getColorAt(int index) {
        return this.colors[index];
    }

    @Override
    public final void setNbColors(int steps) {
        this.colorPositions.remove(this.colorsNb - 1);
        LinkedList<Integer> list = new LinkedList<Integer>(this.colorPositions.keySet());
        for (Integer it : list) {
            if (it < steps - 1) continue;
            this.colorPositions.remove(it);
        }
        this.colorPositions.put(steps - 1, this.colors[this.colorsNb - 1]);
        this.colorsNb = steps;
        this.buildLookupTable();
        for (ILookupTableListener listener : this.listeners) {
            listener.nbColorsChanged(this.colorsNb);
        }
    }

    @Override
    public final int getNbColors() {
        return this.colorsNb;
    }

    @Override
    public final void setScalarRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        this.buildLookupTable();
        for (ILookupTableListener listener : this.listeners) {
            listener.scalarRangeChanged(this.minValue, this.maxValue);
        }
    }

    @Override
    public final void addFixedColor(Color newColor, int position) {
        if (position < this.colorsNb - 1 && position > 0) {
            this.colorPositions.put(position, newColor);
            this.buildLookupTable();
            for (ILookupTableListener listener : this.listeners) {
                listener.fixedColorAdded(newColor, position);
            }
        }
    }

    @Override
    public final void removeFixedColorAt(int position) {
        this.colorPositions.remove(position);
        this.buildLookupTable();
        for (ILookupTableListener listener : this.listeners) {
            listener.fixedColorRemovedAt(position);
        }
    }

    @Override
    public final void moveFixedColor(int oldPosition, int newPosition) {
        if (this.colorPositions.containsKey(oldPosition) && oldPosition != newPosition) {
            Color tmpColor = this.colorPositions.get(oldPosition);
            int tmpPosition = newPosition;
            if (tmpPosition < this.colorsNb - 1 && tmpPosition > 0 && !this.colorPositions.containsKey(tmpPosition)) {
                this.colorPositions.remove(oldPosition);
                this.colorPositions.put(tmpPosition, tmpColor);
                this.buildLookupTable();
                for (ILookupTableListener listener : this.listeners) {
                    listener.fixedColorMoved(oldPosition, tmpPosition);
                }
            }
        }
    }

    @Override
    public final Map<Integer, Color> getColorPositionsMap() {
        return this.colorPositions;
    }

    @Override
    public final double getMaxScalarValue() {
        return this.maxValue;
    }

    @Override
    public final double getMinScalarValue() {
        return this.minValue;
    }

    public final String toString() {
        String desc = "LookupTable: " + this.name + "\n";
        desc = desc + "Nb Colors: " + this.colorsNb + "\n";
        for (Integer i : this.colorPositions.keySet()) {
            desc = desc + "Color at i=" + i + " : " + this.colorPositions.get(i) + " / " + this.getColorCodeAt(i) + "\n";
        }
        return desc;
    }

    @Override
    public final boolean writeToXML(File xmlFile) {
        if (xmlFile != null) {
            ColorXMLWriter writer = new ColorXMLWriter();
            try {
                writer.writeTo(xmlFile, this);
                return true;
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public final boolean readFromXML(File xmlFile) {
        boolean result = false;
        if (xmlFile != null && xmlFile.exists()) {
            this.name = xmlFile.getName();
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                ColorSaxHandler handler = new ColorSaxHandler();
                parser.parse(xmlFile, (DefaultHandler)handler);
                this.colorsNb = handler.getNbColors();
                this.colorPositions = new HashMap<Integer, Color>();
                this.colorPositions.put(0, handler.getStartColor());
                this.colorPositions.put(this.colorsNb - 1, handler.getEndColor());
                for (Integer i : handler.getIntermediateColorsPositions().keySet()) {
                    if (i < this.colorsNb - 1 && i > 0) continue;
                    this.logger.error((Object)"Colors outside the color table !");
                    return false;
                }
                this.colorPositions.putAll(handler.getIntermediateColorsPositions());
                this.buildLookupTable();
                result = true;
            }
            catch (ParserConfigurationException e) {
                result = false;
                e.printStackTrace();
                this.logger.error((Object)e);
            }
            catch (SAXException e) {
                result = false;
                e.printStackTrace();
                this.logger.error((Object)e);
            }
            catch (IOException e) {
                result = false;
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public final void addLookupTableListener(ILookupTableListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final void removeLookupTableListener(ILookupTableListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public final double[] getValueRangeAt(int index) {
        double[] valueRange = new double[]{this.minValue + (double)index / (double)this.colorsNb * (this.maxValue - this.minValue), this.minValue + (double)(index + 1) / (double)this.colorsNb * (this.maxValue - this.minValue)};
        return valueRange;
    }

    @Override
    public final String getColorCode(double value) {
        String rgb = Integer.toHexString(this.colors[this.getColorIndex(value)].getRGB());
        rgb = rgb.substring(2, rgb.length());
        rgb = "#" + rgb;
        return rgb;
    }

    @Override
    public String getColorCodeAt(int index) {
        index = Math.min(index, this.colorsNb - 1);
        String rgb = Integer.toHexString(this.colors[index].getRGB());
        rgb = rgb.substring(2, rgb.length());
        rgb = "#" + rgb;
        return rgb;
    }

    @Override
    public boolean readFromXML(String xmlFileName) {
        return this.readFromXML(new File(xmlFileName));
    }

    @Override
    public boolean writeToXML(String xmlFileName) {
        return this.writeToXML(new File(xmlFileName));
    }

    @Override
    public void setColorAt(int position, Color newColor) {
        if (this.colorPositions.containsKey(position)) {
            this.colorPositions.put(position, newColor);
        }
        this.buildLookupTable();
        for (ILookupTableListener listener : this.listeners) {
            listener.fixedColorAdded(newColor, position);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String aName) {
        this.name = aName;
    }

    @Override
    public double getValueAt(int index) {
        return this.minValue + (double)index * (this.maxValue - this.minValue) / (double)(this.colorsNb - 1);
    }
}

