/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.sample.color;

import com.artenum.tk.color.ColorGradientSliderPanel;
import com.artenum.tk.color.ColorGradientView;
import com.artenum.tk.color.IConfigurableLookupTable;
import com.artenum.tk.color.LookupTable;
import com.artenum.tk.panel.GridBagPanel;
import com.artenum.tk.panel.PanelType;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;

public class ColorGradientSample
extends JFrame {
    private static final long serialVersionUID = 4697311905584939043L;
    private IConfigurableLookupTable table1;

    public ColorGradientSample() {
        super("Color gradient sample");
        this.setDefaultCloseOperation(3);
    }

    public static void main(String[] args) {
        final ColorGradientSample sample = new ColorGradientSample();
        File xmlFile = new File(ColorGradientSample.class.getResource("/com/artenum/tk/sample/color/Bright38.xml").getFile());
        sample.table1 = new LookupTable(xmlFile);
        System.out.println("Table 1: " + sample.table1);
        sample.table1.setScalarRange(0.0, 49.0);
        ColorGradientSliderPanel hColorPanel = new ColorGradientSliderPanel(sample.table1, 0);
        hColorPanel.setBackground(Color.WHITE);
        hColorPanel.setPreferredSize(new Dimension(500, 80));
        hColorPanel.setToolTipVisible(true);
        JButton saveButton = new JButton("Save gradient");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sample.table1.writeToXML("Bright38_" + System.currentTimeMillis() + ".xml");
            }
        });
        GridBagPanel vBox1 = new GridBagPanel.Builder("Horitontal gradient with white background (built from XML file)").build(PanelType.VBOX);
        vBox1.addComponent(hColorPanel);
        vBox1.fill(0).addComponent(saveButton);
        LookupTable table2 = new LookupTable();
        System.out.println("Table 2: " + table2);
        table2.setScalarRange(-10.0, 90.0);
        ColorGradientSliderPanel vColorPanel1 = new ColorGradientSliderPanel(table2, 1);
        vColorPanel1.setPreferredSize(new Dimension(80, 200));
        ColorGradientSliderPanel vColorPanel2 = new ColorGradientSliderPanel(table2, 1);
        vColorPanel2.setThumbsVisible(false);
        vColorPanel2.setPreferredSize(new Dimension(80, 200));
        GridBagPanel hBox2 = new GridBagPanel.Builder("Two vertical representations of the same gradient").fill(0).build(PanelType.HBOX);
        hBox2.addComponent(vColorPanel1);
        hBox2.addComponent(vColorPanel2);
        Vector<IConfigurableLookupTable> tables = new Vector<IConfigurableLookupTable>();
        tables.add(sample.table1);
        tables.add(table2);
        JList list = new JList(tables);
        list.setCellRenderer(new ColorGradientView(100, 20));
        GridBagPanel hBox3 = new GridBagPanel.Builder("List containing both gradients").build(PanelType.HBOX);
        hBox3.addComponent(list);
        JComboBox combo = new JComboBox(tables);
        combo.setRenderer(new ColorGradientView(100, 20));
        GridBagPanel hBox4 = new GridBagPanel.Builder("Combo box containing both gradients").build(PanelType.HBOX);
        hBox4.addComponent(combo);
        GridBagPanel panel = new GridBagPanel.Builder().build(PanelType.VBOX);
        panel.addComponent(vBox1);
        panel.addComponent(hBox2);
        panel.addComponent(hBox3);
        panel.addComponent(hBox4);
        sample.add(panel);
        sample.pack();
        sample.setLocationRelativeTo(null);
        sample.setVisible(true);
    }
}

