/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.basic;

import com.artenum.tk.ui.api.BooleanListener;
import com.artenum.tk.ui.api.BooleanValue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class BooleanInput
implements BooleanValue,
ActionListener {
    private JCheckBox checkBox;
    private ArrayList<BooleanListener> listeners;

    public BooleanInput(String name) {
        this.checkBox = new JCheckBox(name);
        this.checkBox.addActionListener(this);
        this.listeners = new ArrayList();
    }

    @Override
    public void addBooleanListener(BooleanListener l) {
        this.listeners.add(l);
    }

    @Override
    public JComponent getUI() {
        return this.checkBox;
    }

    @Override
    public boolean getValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public void notifyListener() {
        for (BooleanListener l : this.listeners) {
            l.valueChanged(this.checkBox.isSelected());
        }
    }

    @Override
    public void removeBooleanListener(BooleanListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void setValue(boolean value, boolean notify) {
        this.checkBox.setSelected(value);
        if (notify) {
            this.notifyListener();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.notifyListener();
    }
}

