/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.basic;

import com.artenum.tk.ui.api.FloatListener;
import com.artenum.tk.ui.api.FloatValue;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class FloatTextInput
implements ActionListener,
FocusListener,
FloatValue,
FloatListener {
    private float value;
    private float min;
    private float max;
    private final JTextField valueUI;
    private final ArrayList<FloatListener> listeners;

    public FloatTextInput() {
        this(0.0f);
    }

    public FloatTextInput(float value) {
        this(0.0f, -1.0f, 1.0f);
    }

    public FloatTextInput(float value, float min, float max) {
        this.valueUI = new JTextField(Float.toString(value));
        this.valueUI.addActionListener(this);
        this.valueUI.addFocusListener(this);
        Dimension size = this.valueUI.getPreferredSize();
        size.height = this.valueUI.getMinimumSize().height;
        this.valueUI.setPreferredSize(size);
        size = this.valueUI.getMaximumSize();
        size.height = this.valueUI.getMinimumSize().height;
        this.valueUI.setMaximumSize(size);
        this.listeners = new ArrayList();
        this.value = value;
        this.min = min;
        this.max = max;
    }

    @Override
    public float getValue() {
        return this.value;
    }

    @Override
    public void setValue(float newValue, boolean notify) {
        this.value = newValue;
        this.value = Math.min(this.value, this.max);
        this.value = Math.max(this.value, this.min);
        this.valueUI.setText(Float.toString(this.value));
        if (notify) {
            this.notifyListener();
        }
    }

    @Override
    public JComponent getUI() {
        return this.valueUI;
    }

    @Override
    public void setRange(float min, float max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public float[] getRange() {
        return new float[]{this.min, this.max};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.setValue(Float.parseFloat(this.valueUI.getText()), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.valueUI.setText(Float.toString(this.value));
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            this.setValue(Float.parseFloat(this.valueUI.getText()), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.valueUI.setText(Float.toString(this.value));
    }

    @Override
    public void addFloatListener(FloatListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeFloatListener(FloatListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void notifyListener() {
        for (FloatListener l : this.listeners) {
            l.valueChanged(this.value);
        }
    }

    @Override
    public void valueChanged(float newValue) {
        this.setValue(newValue, false);
    }
}

