/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.dynamic.dataset;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.dynamic.dataset.DynamicDatasetPlugin;
import com.artenum.cassandra.plugin.dynamic.dataset.FileToolBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class DynamicDatasetControlUI
extends PlugInControlUI
implements Observer {
    private PipeLineManager pipeLineManager;
    private JTextField firstFileName;
    private JButton browse;
    private JSpinner step;
    private JCheckBox searchForNextFile;
    private JCheckBox loop;
    private JLabel currentFileName;
    private JSlider slider;
    private JSpinner timeBetweenFrame;
    private JCheckBox play;
    private JCheckBox saveFile;
    private Timer timer;
    private Timer timerSearch;
    private DynamicDatasetPlugin plugin;
    private File currentDirectory;

    public DynamicDatasetControlUI(PipeLineManager pipeLineManager, DynamicDatasetPlugin plugin, Frame owner) {
        super(owner, "Dynamic dataset configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel block = new JPanel();
        block.setLayout(new BoxLayout(block, 1));
        block.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Setup"));
        this.getContentPane().add(block);
        this.firstFileName = new JTextField(((File)plugin.getVtkFileList().get(0)).getAbsolutePath());
        this.browse = new JButton("Browse");
        this.browse.setActionCommand("BROWSE");
        this.browse.addActionListener((ActionListener)((Object)this));
        JPanel line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(new JLabel("First file: "));
        line.add(this.firstFileName);
        line.add(this.browse);
        block.add(line);
        this.step = new JSpinner(new SpinnerNumberModel(1, 1, 1000, 1));
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(new JLabel("Step number between files: "));
        line.add(this.step);
        block.add(line);
        this.searchForNextFile = new JCheckBox("Search next file");
        this.searchForNextFile.setActionCommand("SEARCH_NEXT");
        this.searchForNextFile.addActionListener((ActionListener)((Object)this));
        this.loop = new JCheckBox("Loop");
        this.saveFile = new JCheckBox("Save image");
        block = new JPanel();
        block.setLayout(new BoxLayout(block, 1));
        block.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), "Movie"));
        this.getContentPane().add(block);
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        this.currentFileName = new JLabel(((File)plugin.getVtkFileList().get(0)).getName());
        line.add(new JLabel("Current file: "));
        line.add(this.currentFileName);
        line.add(Box.createHorizontalGlue());
        block.add(line);
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        this.timeBetweenFrame = new JSpinner(new SpinnerNumberModel(1000, 1000, 5000, 250));
        line.add(new JLabel("Number of ms between frame: "));
        line.add(this.timeBetweenFrame);
        block.add(line);
        this.slider = new JSlider(0, plugin.getVtkFileList().size() - 1);
        this.slider.addChangeListener((ChangeListener)((Object)this));
        block.add(this.slider);
        this.play = new JCheckBox("Play");
        this.play.setActionCommand("PLAY");
        this.play.addActionListener((ActionListener)((Object)this));
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.add(this.searchForNextFile);
        line.add(this.loop);
        line.add(this.play);
        line.add(this.saveFile);
        block.add(line);
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 2));
        line.add(Box.createHorizontalGlue());
        line.add(cancel);
        this.getContentPane().add(line);
        this.pack();
        Dimension size = this.getSize();
        size.setSize(size.getWidth() + 100.0, size.getHeight());
        this.setSize(size);
        this.setLocationRelativeTo(null);
        plugin.addObserver(this);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("PLAY")) {
            if (this.play.isSelected()) {
                this.timer = new Timer();
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        if (DynamicDatasetControlUI.this.loop.isSelected() || DynamicDatasetControlUI.this.slider.getValue() + 1 <= DynamicDatasetControlUI.this.slider.getMaximum()) {
                            DynamicDatasetControlUI.this.slider.setValue((DynamicDatasetControlUI.this.slider.getValue() + 1) % (DynamicDatasetControlUI.this.slider.getMaximum() + 1));
                        }
                    }
                }, 0L, ((Number)this.timeBetweenFrame.getValue()).longValue());
            } else {
                this.timer.cancel();
                this.timer = null;
            }
        }
        if (command.equals("CANCEL")) {
            this.dispose();
        }
        if (command.equals("SEARCH_NEXT")) {
            System.out.println("SEARCH_NEXT");
            if (this.searchForNextFile.isSelected()) {
                this.timerSearch = new Timer();
                this.timerSearch.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DynamicDatasetControlUI.this.searchNextFile();
                    }
                }, 10L, 5000L);
            } else {
                this.timerSearch.cancel();
                this.timerSearch = null;
            }
        }
        if (command.equals("BROWSE")) {
            JFileChooser chooser = new JFileChooser(this.currentDirectory);
            chooser.setMultiSelectionEnabled(false);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".vtk");
                }

                @Override
                public String getDescription() {
                    return "Vtk files";
                }
            });
            if (chooser.showOpenDialog((Component)((Object)this)) != 0) {
                return;
            }
            this.currentDirectory = chooser.getSelectedFile().getParentFile();
            this.firstFileName.setText(chooser.getSelectedFile().getAbsolutePath());
            this.plugin.setFirstFile(chooser.getSelectedFile());
        }
    }

    public void setCurrentDirectory(File currentDirectory) {
        this.currentDirectory = currentDirectory;
    }

    public void searchNextFile() {
        File f = (File)this.plugin.getVtkFileList().get(this.plugin.getVtkFileList().size() - 1);
        ArrayList fileDecomposition = FileToolBox.splitNumbers(f.getName());
        StringBuffer currentPart2 = null;
        int numberPos = 0;
        ArrayList<Integer> listOfNumberPos = new ArrayList<Integer>();
        for (StringBuffer currentPart2 : fileDecomposition) {
            if (currentPart2.charAt(0) >= '0' && currentPart2.charAt(0) <= '9') {
                listOfNumberPos.add(new Integer(numberPos));
            }
            ++numberPos;
        }
        int[] realNumberPos = new int[listOfNumberPos.size()];
        for (int i = 0; i < realNumberPos.length; ++i) {
            realNumberPos[i] = (Integer)listOfNumberPos.get(i);
        }
        File fileToCheck = null;
        for (int i = 1; i <= 10; ++i) {
            for (int j = 0; j < realNumberPos.length; ++j) {
                StringBuffer fileToSearchFor = new StringBuffer();
                for (int k = 0; k < fileDecomposition.size(); ++k) {
                    if (k == realNumberPos[j]) {
                        int length = ((StringBuffer)fileDecomposition.get(k)).length();
                        String number = Integer.toString(Integer.parseInt(((StringBuffer)fileDecomposition.get(k)).toString()) + ((Number)this.step.getValue()).intValue() * i);
                        if (number.length() < length) {
                            for (int nbZ = 0; nbZ < length - number.length(); ++nbZ) {
                                fileToSearchFor.append("0");
                            }
                        }
                        fileToSearchFor.append(number);
                        continue;
                    }
                    fileToSearchFor.append((StringBuffer)fileDecomposition.get(k));
                }
                fileToCheck = new File(f.getParentFile(), fileToSearchFor.toString());
                if (!fileToCheck.exists()) continue;
                this.plugin.addVtkFile(fileToCheck);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                File f = (File)DynamicDatasetControlUI.this.plugin.getVtkFileList().get(DynamicDatasetControlUI.this.slider.getValue());
                DynamicDatasetControlUI.this.currentFileName.setText(f.getName());
                DynamicDatasetControlUI.this.plugin.updateInputFile(f, DynamicDatasetControlUI.this.saveFile.isSelected());
            }
        });
    }

    public boolean isSaveFileSelected() {
        return this.saveFile.isSelected();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.slider.getValue() > this.plugin.getVtkFileList().size() - 1) {
            this.slider.setValue(this.plugin.getVtkFileList().size() - 1);
        }
        this.slider.setMaximum(this.plugin.getVtkFileList().size() - 1);
    }

    public void itemStateChanged(ItemEvent arg0) {
    }
}

