/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.ConnectivityListener;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectAdapter;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.renderer.vtk.CassandraView;
import com.artenum.cassandra.ui.DefaultAxes;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Observable;
import vtk.vtkActor;
import vtk.vtkAlgorithm;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkObject;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkTextActor;
import vtk.vtkUnstructuredGrid;
import vtk.vtkXMLUnstructuredGridReader;

public class SimplePipeLineManager
extends Observable
implements PipeLineManager {
    private CassandraView view;
    private final ArrayList connectivityListener;
    private Hashtable<Integer, CassandraObject> vtkObjectHashtable;
    private final VtkObjectListModel actorList;
    private final VtkObjectListModel mapperList;
    private final VtkObjectListModel datasetList;
    private final VtkObjectListModel filterList;
    private final VtkObjectListModel lookupTableList;
    private final VtkObjectListModel scalarBarList;
    private final VtkObjectListModel txtActorList;
    private Integer vtkObjectIndex = new Integer(0);
    private final int pluginNumber = 1;
    private int actorNumber = 1;
    private int sourceNumber = 1;
    private int mapperNumber = 1;
    private int filterNumber = 1;
    private int lookupNumber = 1;
    private int scalarBarNumber = 1;
    private int txtActorNumber = 1;
    private final DefaultAxes axes;

    public Integer getVtkObjectIndex() {
        return this.vtkObjectIndex;
    }

    public SimplePipeLineManager() {
        try {
            this.view = new CassandraView();
        }
        catch (Exception e) {
            System.out.println("Error: impossible to build the VTK based renderer and/or view");
            System.exit(-1);
        }
        this.vtkObjectHashtable = new Hashtable();
        this.actorList = new VtkObjectListModel(1);
        this.mapperList = new VtkObjectListModel(2);
        this.datasetList = new VtkObjectListModel(3);
        this.filterList = new VtkObjectListModel(4);
        this.lookupTableList = new VtkObjectListModel(5);
        this.scalarBarList = new VtkObjectListModel(6);
        this.txtActorList = new VtkObjectListModel(7);
        this.axes = new DefaultAxes(this);
        this.connectivityListener = new ArrayList();
    }

    @Override
    public Hashtable<Integer, CassandraObject> getVtkObjectHashtable() {
        return this.vtkObjectHashtable;
    }

    public void setVtkObjectHashtable(Hashtable vtkObjectHashtable) {
        this.vtkObjectHashtable = vtkObjectHashtable;
    }

    @Override
    public synchronized void addVtkFile(File vtkFile) {
        vtkUnstructuredGrid inputDataSet;
        if (!vtkFile.exists()) {
            System.err.println("File does not exist: " + vtkFile.getAbsolutePath());
            return;
        }
        if (vtkFile.getName().endsWith(".vtu")) {
            vtkXMLUnstructuredGridReader dataSetXMLReader = new vtkXMLUnstructuredGridReader();
            dataSetXMLReader.SetFileName(vtkFile.getAbsolutePath());
            dataSetXMLReader.Update();
            inputDataSet = dataSetXMLReader.GetOutput();
        } else {
            System.out.print("Vtk file loading... ");
            vtkDataSetReader dataSetReader = new vtkDataSetReader();
            dataSetReader.SetFileName(vtkFile.getAbsolutePath());
            dataSetReader.Update();
            inputDataSet = dataSetReader.GetOutput();
            System.out.println("DONE");
        }
        vtkDataSetMapper mapper = new vtkDataSetMapper();
        mapper.SetInput((vtkDataSet)inputDataSet);
        mapper.Update();
        vtkActor actor = new vtkActor();
        actor.SetMapper((vtkMapper)mapper);
        this.addDataSet(inputDataSet, vtkFile.getName());
        this.addMapper(mapper, vtkFile.getName());
        this.setActorVisible(this.addActor(actor, vtkFile.getName()), true);
        if (inputDataSet.GetScalarRange() != null) {
            vtkLookupTable lookupTable = new vtkLookupTable();
            lookupTable.SetHueRange(0.66667, 0.0);
            lookupTable.SetTableRange(inputDataSet.GetScalarRange());
            lookupTable.Build();
            mapper.SetLookupTable((vtkScalarsToColors)lookupTable);
            mapper.SetScalarRange(inputDataSet.GetScalarRange());
            vtkScalarBarActor scalBar = new vtkScalarBarActor();
            scalBar.SetLookupTable((vtkScalarsToColors)lookupTable);
            this.addLookupTable(lookupTable, vtkFile.getName());
            this.setActorVisible(this.addScalarBar(scalBar, vtkFile.getName()), true);
        }
        this.view.resetCamera();
    }

    @Override
    public synchronized void setActorVisible(Integer vtkObjectId, boolean viewActor) {
        this.setActorVisible(this.vtkObjectHashtable.get(vtkObjectId), viewActor);
    }

    @Override
    public synchronized void setActorVisible(CassandraObject cassObject, boolean viewActor) {
        if (cassObject.getType() == 1 || cassObject.getType() == 7 || cassObject.getType() == 6) {
            if (!cassObject.isValide()) {
                return;
            }
            cassObject.getMetaData().put("ACTOR_VISIBLE", Boolean.toString(viewActor));
            if (cassObject.getVtkObject() instanceof vtkActor) {
                if (viewActor) {
                    int vtkActorIndex = this.view.GetRenderer().GetActors().IsItemPresent((vtkObject)((vtkProp)cassObject.getVtkObject()));
                    if (vtkActorIndex != 0) {
                        ((vtkProp)cassObject.getVtkObject()).SetVisibility(1);
                    } else {
                        this.view.GetRenderer().AddActor((vtkProp)cassObject.getVtkObject());
                    }
                } else {
                    int vtkActorIndex = this.view.GetRenderer().GetActors().IsItemPresent((vtkObject)((vtkProp)cassObject.getVtkObject()));
                    if (vtkActorIndex != 0) {
                        ((vtkProp)cassObject.getVtkObject()).SetVisibility(0);
                    }
                }
            } else if (viewActor) {
                int vtkActorIndex = this.view.GetRenderer().GetActors2D().IsItemPresent((vtkObject)((vtkProp)cassObject.getVtkObject()));
                if (vtkActorIndex != 0) {
                    ((vtkProp)cassObject.getVtkObject()).SetVisibility(1);
                } else {
                    this.view.GetRenderer().AddActor2D((vtkProp)cassObject.getVtkObject());
                }
            } else {
                int vtkActorIndex = this.view.GetRenderer().GetActors2D().IsItemPresent((vtkObject)((vtkProp)cassObject.getVtkObject()));
                if (vtkActorIndex != 0) {
                    ((vtkProp)cassObject.getVtkObject()).SetVisibility(0);
                }
            }
        }
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
    }

    @Override
    public CassandraObject getVtkObject(Integer vtkObjectId) {
        return this.vtkObjectHashtable.get(vtkObjectId);
    }

    public Integer getNextVtkObjectId() {
        this.vtkObjectIndex = new Integer(this.vtkObjectIndex + 1);
        return this.vtkObjectIndex;
    }

    @Override
    public VtkObjectListModel getActorList() {
        return this.actorList;
    }

    @Override
    public VtkObjectListModel getDataSetList() {
        return this.datasetList;
    }

    @Override
    public VtkObjectListModel getFilterList() {
        return this.filterList;
    }

    @Override
    public VtkObjectListModel getMapperList() {
        return this.mapperList;
    }

    @Override
    public VtkObjectListModel getLookupTableList() {
        return this.lookupTableList;
    }

    @Override
    public VtkObjectListModel getScalarBarList() {
        return this.scalarBarList;
    }

    @Override
    public VtkObjectListModel getTextActorList() {
        return this.txtActorList;
    }

    @Override
    public synchronized CassandraObject addActor(Object actor, String name) {
        int id = this.actorNumber++;
        String actorId = name + " (" + id + ")";
        VtkObjectAdapter vtkObject2 = new VtkObjectAdapter(actor, 1, actorId, this.getNextVtkObjectId());
        vtkObject2.setLocalTypeId(id);
        this.vtkObjectHashtable.put(vtkObject2.getId(), vtkObject2);
        this.actorList.addVtkObject(vtkObject2);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObject2;
    }

    public synchronized CassandraObject addActor(Object actor, String name, int cellPosX, int cellPosY) {
        CassandraObject casActor = this.addActor(actor, name);
        ((VtkObjectCellAdapter)casActor.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return casActor;
    }

    @Override
    public synchronized CassandraObject addMapper(Object mapper, String name) {
        int id = this.mapperNumber++;
        String mapperId = name + " (" + id + ")";
        ((vtkMapper)mapper).SetInterpolateScalarsBeforeMapping(1);
        VtkObjectAdapter casObject = new VtkObjectAdapter(mapper, 2, mapperId, this.getNextVtkObjectId());
        casObject.setLocalTypeId(id);
        this.vtkObjectHashtable.put(casObject.getId(), casObject);
        this.mapperList.addVtkObject(casObject);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return casObject;
    }

    public synchronized CassandraObject addMapper(Object mapper, String name, int cellPosX, int cellPosY) {
        CassandraObject casMapper = this.addMapper(mapper, name);
        ((VtkObjectCellAdapter)casMapper.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return casMapper;
    }

    @Override
    public synchronized CassandraObject addDataSet(Object dataset, String name) {
        int id = this.sourceNumber++;
        String datasetId = name + " (" + id + ")";
        VtkObjectAdapter vtkObject2 = new VtkObjectAdapter(dataset, 3, datasetId, this.getNextVtkObjectId());
        vtkObject2.setLocalTypeId(id);
        this.vtkObjectHashtable.put(vtkObject2.getId(), vtkObject2);
        this.datasetList.addVtkObject(vtkObject2);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObject2;
    }

    public synchronized CassandraObject addDataSet(Object dataset, String name, int cellPosX, int cellPosY) {
        CassandraObject casDataset = this.addDataSet(dataset, name);
        ((VtkObjectCellAdapter)casDataset.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return casDataset;
    }

    public synchronized void addDataSetAndBuildPipeline(Object dataset, String name) {
        CassandraObject tmpDataSet = this.addDataSet(dataset, name);
        vtkDataSetMapper mapper = new vtkDataSetMapper();
        vtkActor actor = new vtkActor();
        mapper.SetInput((vtkDataSet)dataset);
        actor.SetMapper((vtkMapper)mapper);
        vtkLookupTable lookupTable = new vtkLookupTable();
        lookupTable.SetHueRange(0.66667, 0.0);
        mapper.SetLookupTable((vtkScalarsToColors)lookupTable);
        mapper.SetScalarRange(((vtkDataSet)dataset).GetScalarRange());
        vtkScalarBarActor scalarBar = new vtkScalarBarActor();
        scalarBar.SetLookupTable((vtkScalarsToColors)lookupTable);
        CassandraObject tmpMapper = this.addMapper(mapper, name + " mapper");
        CassandraObject tmpActor = this.addActor(actor, name + " actor");
        this.setActorVisible(tmpActor, true);
        CassandraObject tmpLookUpTable = this.addLookupTable(lookupTable, name + " lookup table");
        this.setActorVisible(this.addScalarBar(scalarBar, name), true);
    }

    public synchronized void addDataSetAndBuildPipeline(Object dataset, String name, String title) {
        CassandraObject tmpDataSet = this.addDataSet(dataset, name);
        vtkDataSetMapper mapper = new vtkDataSetMapper();
        vtkActor actor = new vtkActor();
        mapper.SetInput((vtkDataSet)dataset);
        actor.SetMapper((vtkMapper)mapper);
        vtkLookupTable lookupTable = new vtkLookupTable();
        lookupTable.SetHueRange(0.66667, 0.0);
        mapper.SetLookupTable((vtkScalarsToColors)lookupTable);
        mapper.SetScalarRange(((vtkDataSet)dataset).GetScalarRange());
        vtkScalarBarActor scalarBar = new vtkScalarBarActor();
        scalarBar.SetLookupTable((vtkScalarsToColors)lookupTable);
        scalarBar.SetTitle(title);
        CassandraObject tmpMapper = this.addMapper(mapper, name + " mapper");
        CassandraObject tmpActor = this.addActor(actor, name + " actor");
        this.setActorVisible(tmpActor, true);
        CassandraObject tmpLookUpTable = this.addLookupTable(lookupTable, name + " lookup table");
        this.setActorVisible(this.addScalarBar(scalarBar, name), true);
    }

    @Override
    public synchronized CassandraObject addFilter(Filter filter, String name) {
        int id = this.filterNumber++;
        String filterId = name + " (" + id + ")";
        VtkObjectAdapter cassAdapter = new VtkObjectAdapter(filter, 4, filterId, this.getNextVtkObjectId());
        cassAdapter.setLocalTypeId(id);
        this.vtkObjectHashtable.put(cassAdapter.getId(), cassAdapter);
        this.filterList.addVtkObject(cassAdapter);
        Point tmpPos = ((VtkObjectCellAdapter)cassAdapter.getMetaData().get("CELL")).getPosition();
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        tmpPos = ((VtkObjectCellAdapter)cassAdapter.getMetaData().get("CELL")).getPosition();
        return cassAdapter;
    }

    public synchronized CassandraObject addFilter(Filter filter, String name, int cellPosX, int cellPosY) {
        CassandraObject cassFilter = this.addFilter(filter, name);
        ((VtkObjectCellAdapter)cassFilter.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return cassFilter;
    }

    @Override
    public synchronized CassandraObject addLookupTable(vtkLookupTable lookupTable, String name) {
        int id = this.lookupNumber++;
        String lookupTableId = name + " (" + id + ")";
        VtkObjectAdapter adapter = new VtkObjectAdapter(lookupTable, 5, lookupTableId, this.getNextVtkObjectId());
        adapter.setLocalTypeId(id);
        this.vtkObjectHashtable.put(adapter.getId(), adapter);
        this.lookupTableList.addVtkObject(adapter);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return adapter;
    }

    public synchronized CassandraObject addLookupTable(vtkLookupTable lookupTable, String name, int cellPosX, int cellPosY) {
        CassandraObject cassLookupTable = this.addLookupTable(lookupTable, name);
        ((VtkObjectCellAdapter)cassLookupTable.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return cassLookupTable;
    }

    @Override
    public synchronized CassandraObject addScalarBar(vtkScalarBarActor scalarBar, String name) {
        int id = this.scalarBarNumber++;
        String scalarBarId = name + " (" + id + ")";
        VtkObjectAdapter vtkObject2 = new VtkObjectAdapter(scalarBar, 6, scalarBarId, this.getNextVtkObjectId());
        vtkObject2.setLocalTypeId(id);
        this.vtkObjectHashtable.put(vtkObject2.getId(), vtkObject2);
        this.scalarBarList.addVtkObject(vtkObject2);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObject2;
    }

    public synchronized CassandraObject addScalarBar(vtkScalarBarActor scalarBar, String name, int cellPosX, int cellPosY) {
        CassandraObject cassScalarBar = this.addScalarBar(scalarBar, name);
        ((VtkObjectCellAdapter)cassScalarBar.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return cassScalarBar;
    }

    @Override
    public synchronized CassandraObject addTxtActor(vtkTextActor txtActor, String name) {
        int id = this.txtActorNumber++;
        String txtActorId = name + " (" + id + ")";
        VtkObjectAdapter vtkObject2 = new VtkObjectAdapter(txtActor, 7, txtActorId, this.getNextVtkObjectId());
        vtkObject2.setLocalTypeId(id);
        this.vtkObjectHashtable.put(vtkObject2.getId(), vtkObject2);
        this.txtActorList.addVtkObject(vtkObject2);
        this.setChanged();
        this.notifyObservers(this.vtkObjectHashtable);
        return vtkObject2;
    }

    public synchronized CassandraObject addTxtActor(vtkTextActor txtActor, String name, int cellPosX, int cellPosY) {
        CassandraObject cassTextActor = this.addTxtActor(txtActor, name);
        ((VtkObjectCellAdapter)cassTextActor.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        return cassTextActor;
    }

    @Override
    public synchronized void removeVtkObject(Integer vtkObjectId) {
        CassandraObject vtkObject2 = this.vtkObjectHashtable.remove(vtkObjectId);
        if (vtkObject2 != null) {
            switch (vtkObject2.getType()) {
                case 1: {
                    this.setActorVisible(vtkObject2, false);
                    this.actorList.removeVtkObject(vtkObject2);
                    break;
                }
                case 2: {
                    this.mapperList.removeVtkObject(vtkObject2);
                    break;
                }
                case 3: {
                    this.datasetList.removeVtkObject(vtkObject2);
                    break;
                }
                case 4: {
                    this.filterList.removeVtkObject(vtkObject2);
                    break;
                }
                case 5: {
                    this.lookupTableList.removeVtkObject(vtkObject2);
                    break;
                }
                case 6: {
                    this.setActorVisible(vtkObject2, false);
                    this.scalarBarList.removeVtkObject(vtkObject2);
                    break;
                }
                case 7: {
                    this.setActorVisible(vtkObject2, false);
                    this.txtActorList.removeVtkObject(vtkObject2);
                }
            }
            this.setChanged();
            this.notifyObservers(this.vtkObjectHashtable);
        }
    }

    @Override
    public synchronized void hideInputActor(CassandraObject actor, vtkDataSet vtkDataSet2) {
        int i = 0;
        CassandraObject inputPipelineActor = null;
        vtkDataSet inputDataSet = null;
        vtkObject inputActor = null;
        boolean isValid = true;
        while (!(inputDataSet == vtkDataSet2 && inputActor != actor) && isValid) {
            try {
                inputPipelineActor = (CassandraObject)this.getActorList().getElementAt(i);
            }
            catch (Exception e) {
                System.out.println("Error, actor not found.");
                isValid = false;
            }
            inputActor = (vtkObject)inputPipelineActor.getVtkObject();
            vtkMapper inputMapper = ((vtkActor)inputActor).GetMapper();
            if (inputMapper instanceof vtkDataSetMapper) {
                inputDataSet = ((vtkDataSetMapper)inputMapper).GetInput();
            }
            if (inputMapper instanceof vtkPolyDataMapper) {
                inputDataSet = ((vtkPolyDataMapper)inputMapper).GetInput();
            }
            ++i;
        }
        this.setActorVisible(inputPipelineActor, false);
    }

    @Override
    public synchronized void removeVtkObject(CassandraObject vtkObject2) {
        this.removeVtkObject(vtkObject2.getId());
    }

    @Override
    public CassandraView getCassandraView() {
        return this.view;
    }

    @Override
    public void setAxisVisible(boolean viewAxis) {
        this.axes.setVisible(viewAxis);
    }

    @Override
    public void setParallelProjection(boolean setParallel) {
        int flag = 0;
        flag = setParallel ? 1 : 0;
        this.getCassandraView().GetRenderer().GetActiveCamera().SetParallelProjection(flag);
    }

    @Override
    public void validateViewAndGo() {
        this.getCassandraView().validateViewAndGo();
    }

    @Override
    public void validateViewAndWait() {
        this.getCassandraView().validateViewAndWait();
    }

    @Override
    public void deepValidateView() {
        this.getCassandraView().deepValidateView();
    }

    @Override
    public synchronized void addConnectivityListener(ConnectivityListener l) {
        this.connectivityListener.add(l);
    }

    @Override
    public void notifyConnectivityChange(CassandraObject obj) {
        Iterator i = this.connectivityListener.iterator();
        while (i.hasNext()) {
            ((ConnectivityListener)i.next()).connectivityChange(obj);
        }
    }

    @Override
    public synchronized void removeConnectivityListener(ConnectivityListener l) {
        this.connectivityListener.remove(l);
    }

    public int getNbVtkObjects() {
        return this.vtkObjectHashtable.size();
    }

    @Override
    public CassandraObject getCassandraVtkObjectByTrueVtkObject(vtkObject obj) {
        if (obj instanceof vtkActor) {
            for (CassandraObject pipelineObj : this.actorList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        if (obj instanceof vtkMapper) {
            for (CassandraObject pipelineObj : this.mapperList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        if (obj instanceof vtkDataSet) {
            for (CassandraObject pipelineObj : this.datasetList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        if (obj instanceof vtkAlgorithm) {
            for (CassandraObject pipelineObj : this.filterList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        if (obj instanceof vtkLookupTable) {
            for (CassandraObject pipelineObj : this.lookupTableList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        if (obj instanceof vtkScalarBarActor) {
            for (CassandraObject pipelineObj : this.scalarBarList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        if (obj instanceof vtkTextActor) {
            for (CassandraObject pipelineObj : this.txtActorList.getData()) {
                if (!pipelineObj.getVtkObject().equals(obj)) continue;
                return pipelineObj;
            }
        }
        return null;
    }
}

