/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI2;
import com.artenum.graph.impl.DefaultConnection;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import com.artenum.graph.listener.DragListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class VtkObjectCellAdapter
implements Cell {
    private CassandraObject object;
    private boolean selected;
    private VtkObjectUI2 ui;
    protected Object oldGroupDragListener;
    protected ArrayList connectionList;
    protected Object userObject;
    protected Color selectedBorderColor = Color.BLACK;
    protected int selectedBorderSize = 2;

    public VtkObjectCellAdapter(CassandraObject object) {
        this.object = object;
        this.ui = new VtkObjectUI2(object);
        new DragListener(this, this.ui, this.ui);
        this.connectionList = new ArrayList();
    }

    @Override
    public Component getUI() {
        return this.ui;
    }

    @Override
    public List getConnections() {
        return this.connectionList;
    }

    @Override
    public Point getConnectionPoint(Connection connection) {
        Rectangle remoteBounds = connection.getOtherCell(this).getUI().getBounds();
        Rectangle localBounds = this.ui.getBounds();
        double rx = remoteBounds.getCenterX();
        double ry = remoteBounds.getCenterY();
        double lx = localBounds.getCenterX();
        double ly = localBounds.getCenterY();
        Point result = new Point((int)lx, (int)ly);
        if (localBounds.getMaxX() < rx || rx < localBounds.getMinX()) {
            result.x = localBounds.getMinX() > rx ? (int)localBounds.getMinX() : (int)localBounds.getMaxX();
        } else if (localBounds.getMaxY() < ry || ry < localBounds.getMinY()) {
            result.y = localBounds.getMinY() > ry ? (int)localBounds.getMinY() : (int)localBounds.getMaxY();
        }
        return result;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
        if (this.ui != null && this.ui instanceof JComponent) {
            if (selected) {
                this.ui.setBorder(BorderFactory.createLineBorder(this.selectedBorderColor, this.selectedBorderSize));
            } else {
                this.ui.setBorder(BorderFactory.createEmptyBorder());
            }
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void connectTo(Cell destCell) {
        DefaultConnection connnection = new DefaultConnection(this, destCell);
        this.addConnection(connnection);
        destCell.addConnection(connnection);
    }

    @Override
    public void addConnection(Connection connection) {
        this.connectionList.add(connection);
    }

    @Override
    public void addGroupDragListener(Object mouseListener) {
        if (this.oldGroupDragListener != null) {
            this.ui.removeMouseListener((MouseListener)this.oldGroupDragListener);
            this.ui.removeMouseMotionListener((MouseMotionListener)this.oldGroupDragListener);
        }
        this.ui.addMouseListener((MouseListener)mouseListener);
        this.ui.addMouseMotionListener((MouseMotionListener)mouseListener);
        this.oldGroupDragListener = mouseListener;
    }

    public void setSelectedBorderColor(Color selectedBorderColor) {
        this.selectedBorderColor = selectedBorderColor;
    }

    public void setSelectedBorderSize(int selectedBorderSize) {
        this.selectedBorderSize = selectedBorderSize;
    }

    public CassandraObject getVtkObject() {
        return this.object;
    }

    public void savePosition() {
        this.ui.savePosition();
    }

    public Point getPosition() {
        return this.ui.getPosition();
    }

    public void setPosition(Point point) {
        this.ui.setPosition(point);
    }
}

