/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class ActorList
extends JPanel {
    private ActorTableModel[] model;
    private PipeLineManager pipeLineManager;
    private JTable[] table;

    public ActorList(String[] titles, VtkObjectListModel[] listModel, PipeLineManager pipeLineManager) {
        this.pipeLineManager = pipeLineManager;
        this.model = new ActorTableModel[listModel.length];
        this.table = new JTable[listModel.length];
        this.setLayout(new BoxLayout(this, 1));
        for (int i = 0; i < listModel.length; ++i) {
            this.model[i] = new ActorTableModel(listModel[i]);
            this.table[i] = new JTable(this.model[i]);
            this.table[i].getColumnModel().getColumn(0).setPreferredWidth(40);
            this.table[i].getColumnModel().getColumn(0).setMaxWidth(40);
            this.table[i].getColumnModel().getColumn(0).setMinWidth(40);
            this.table[i].getColumnModel().getColumn(1).setPreferredWidth(150);
            this.table[i].getColumnModel().getColumn(1).setMaxWidth(2000);
            this.table[i].getColumnModel().getColumn(1).setMinWidth(20);
            JPanel content = new JPanel(new BorderLayout());
            content.add((Component)this.table[i], "Center");
            content.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), titles[i]));
            this.add(content);
        }
    }

    class ActorTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private VtkObjectListModel model;
        private String[] columnNames;

        public ActorTableModel(VtkObjectListModel model) {
            this.model = model;
            model.addListDataListener(this);
            this.columnNames = new String[]{"Visible", "Actor name"};
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            CassandraObject vtkObject2 = this.model.getVtkObject(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return Boolean.valueOf((String)vtkObject2.getMetaData().get("ACTOR_VISIBLE"));
                }
                case 1: {
                    return vtkObject2.getName();
                }
            }
            return null;
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            TableModelEvent te = new TableModelEvent(this, e.getIndex0(), e.getIndex1());
            this.fireTableChanged(te);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public Class getColumnClass(int c) {
            if (c == 0) {
                return Boolean.class;
            }
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            CassandraObject vtkObject2 = this.model.getVtkObject(row);
            ActorList.this.pipeLineManager.setActorVisible(vtkObject2, (boolean)((Boolean)value));
            ActorList.this.pipeLineManager.validateViewAndGo();
            this.fireTableCellUpdated(row, col);
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }
}

