/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.CassandraTreeModel;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.PluginPopupMenuManager;
import com.artenum.cassandra.ui.VtkObjectPopupMenuDipatcher;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class CassandraTree
extends JTree {
    private CassandraTreeModel treeModel;
    private VtkObjectPopupMenuDipatcher vtkPopupMenu;
    private PluginPopupMenuManager pluginPopupMenu;

    public CassandraTree(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.treeModel = new CassandraTreeModel(pipeLineManager, pluginManager);
        this.vtkPopupMenu = new VtkObjectPopupMenuDipatcher(pipeLineManager, pluginManager);
        this.pluginPopupMenu = new PluginPopupMenuManager();
        this.addMouseListener(new PopupListener());
        this.setModel(this.treeModel);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (CassandraTree.this.getPathForLocation(e.getX(), e.getY()) == null) {
                    return;
                }
                Object node = ((DefaultMutableTreeNode)CassandraTree.this.getPathForLocation(e.getX(), e.getY()).getLastPathComponent()).getUserObject();
                if (node instanceof CassandraObject) {
                    CassandraTree.this.vtkPopupMenu.showPopupMenu(e.getComponent(), e.getX(), e.getY(), (CassandraObject)node);
                }
                if (node instanceof CassandraPlugin) {
                    CassandraTree.this.pluginPopupMenu.showPopupMenu(e.getComponent(), e.getX(), e.getY(), (CassandraPlugin)node);
                }
            }
        }
    }
}

