/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.ui.dialog.LookUpTableControlDialog;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.CassandraToolBox;
import com.artenum.cassandra.util.VtkObjectInformationPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarsToColors;

public class LookupTablePopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String LOOKUP_TABLE_SHOW_CONTROL = "lookup.table.control";
    public static final String LOOKUP_TABLE_REMOVE = "lookup.table.remove";
    public static final String LOOKUP_TABLE_GET_INFO = "lookup.table.get.info";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private CassandraObject currentVtkObject;
    private Hashtable controlDialogTable;
    private JMenuItem showControl;
    private RenameVtkObject lookupTableRename;
    private JMenuItem lookupTableGetInfo;
    private JMenuItem lookupTableRemove;
    private JMenu mapperList;

    public LookupTablePopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.controlDialogTable = new Hashtable();
        this.showControl = new JMenuItem("Show control");
        this.showControl.setActionCommand(LOOKUP_TABLE_SHOW_CONTROL);
        this.showControl.addActionListener(this);
        this.add(this.showControl);
        this.mapperList = new JMenu("Link to mapper...");
        this.add(this.mapperList);
        this.lookupTableRename = new RenameVtkObject("Rename", "Rename lookup table", null);
        this.add(this.lookupTableRename);
        this.lookupTableGetInfo = new JMenuItem("Get information");
        this.lookupTableGetInfo.setActionCommand(LOOKUP_TABLE_GET_INFO);
        this.lookupTableGetInfo.addActionListener(this);
        this.add(this.lookupTableGetInfo);
        this.addSeparator();
        this.lookupTableRemove = new JMenuItem("Remove");
        this.lookupTableRemove.setActionCommand(LOOKUP_TABLE_REMOVE);
        this.lookupTableRemove.addActionListener(this);
        this.add(this.lookupTableRemove);
    }

    private void updateMapperList() {
        CassandraObject mapper2 = null;
        this.mapperList.removeAll();
        JMenuItem item = null;
        for (CassandraObject mapper2 : this.pipeLineManager.getMapperList().getData()) {
            item = new JMenuItem(mapper2.getName());
            item.addActionListener(new LookupTableSetter((vtkMapper)mapper2.getVtkObject()));
            this.mapperList.add(item);
        }
    }

    @Override
    public void setCurrentVtkOject(CassandraObject currentVtkObject) {
        this.currentVtkObject = currentVtkObject;
        this.lookupTableRename.setVtkObject(currentVtkObject);
        this.updateMapperList();
        if (this.controlDialogTable.get(currentVtkObject) != null) {
            ((LookUpTableControlDialog)this.controlDialogTable.get(currentVtkObject)).setLookupTable(currentVtkObject);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(LOOKUP_TABLE_REMOVE)) {
            this.cascadeRemoveManager.removeLookupTable(this.currentVtkObject);
        } else if (command.equals(LOOKUP_TABLE_GET_INFO)) {
            VtkObjectInformationPane infoPane = new VtkObjectInformationPane(this.currentVtkObject);
            infoPane.showMessageDialog();
        } else if (command.equals(LOOKUP_TABLE_SHOW_CONTROL)) {
            ((LookUpTableControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setVisible(true);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if ((LookUpTableControlDialog)this.controlDialogTable.get(this.currentVtkObject) == null) {
            this.controlDialogTable.put(this.currentVtkObject, new LookUpTableControlDialog(CassandraToolBox.getParentFrame(invoker), this.pipeLineManager));
            ((LookUpTableControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setLookupTable(this.currentVtkObject);
        }
        this.updateMapperList();
        super.show(invoker, x, y);
    }

    private class LookupTableSetter
    implements ActionListener {
        private vtkMapper mapper;

        public LookupTableSetter(vtkMapper mapper) {
            this.mapper = mapper;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mapper.SetLookupTable((vtkScalarsToColors)((vtkLookupTable)LookupTablePopupMenu.this.currentVtkObject.getVtkObject()));
            CassandraToolBox.updateMapper(LookupTablePopupMenu.this.pipeLineManager, (vtkLookupTable)LookupTablePopupMenu.this.currentVtkObject.getVtkObject());
            LookupTablePopupMenu.this.pipeLineManager.notifyConnectivityChange(LookupTablePopupMenu.this.currentVtkObject);
            LookupTablePopupMenu.this.pipeLineManager.validateViewAndGo();
        }
    }
}

