/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.ui.dialog.ScalarBarControlDialog;
import com.artenum.cassandra.ui.popup.ActorPopupMenu;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.CassandraToolBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkLookupTable;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class ScalarBarPopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String SCALAR_BAR_REMOVE = "scalar.bar.remove";
    public static final String SCALAR_BAR_CONTROL = "scalar.bar.control";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private CassandraObject currentVtkObject;
    private Hashtable controlDialogTable;
    private ActorPopupMenu actorMenu;
    private JMenuItem showControl;
    private RenameVtkObject scalarBarRename;
    private JMenuItem scalarBarRemove;
    private JMenu lookupTableList;

    public ScalarBarPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.controlDialogTable = new Hashtable();
        this.actorMenu = new ActorPopupMenu(pipeLineManager, cascadeRemoveManager);
        this.add(this.actorMenu.getActorVisibleMenuItem());
        this.add(this.actorMenu.getActorOpacityMenuItem());
        this.addSeparator();
        this.showControl = new JMenuItem("Show control");
        this.showControl.setActionCommand(SCALAR_BAR_CONTROL);
        this.showControl.addActionListener(this);
        this.add(this.showControl);
        this.lookupTableList = new JMenu("Link to lookup table...");
        this.add(this.lookupTableList);
        this.scalarBarRename = new RenameVtkObject("Rename", "Rename scalar bar", null);
        this.add(this.scalarBarRename);
        this.addSeparator();
        this.scalarBarRemove = new JMenuItem("Remove");
        this.scalarBarRemove.setActionCommand(SCALAR_BAR_REMOVE);
        this.scalarBarRemove.addActionListener(this);
        this.add(this.scalarBarRemove);
    }

    @Override
    public void setCurrentVtkOject(CassandraObject currentVtkObject) {
        this.currentVtkObject = currentVtkObject;
        this.scalarBarRename.setVtkObject(currentVtkObject);
        this.updateLookupTableList();
        this.actorMenu.setCurrentVtkOject(currentVtkObject);
        if (this.controlDialogTable.get(currentVtkObject) != null) {
            ((ScalarBarControlDialog)this.controlDialogTable.get(currentVtkObject)).setScalarBar(currentVtkObject);
        }
    }

    private void updateLookupTableList() {
        CassandraObject lookupTable2 = null;
        this.lookupTableList.removeAll();
        JMenuItem item = null;
        for (CassandraObject lookupTable2 : this.pipeLineManager.getLookupTableList().getData()) {
            item = new JMenuItem(lookupTable2.getName());
            item.addActionListener(new LookupTableSetter((vtkLookupTable)lookupTable2.getVtkObject()));
            this.lookupTableList.add(item);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(SCALAR_BAR_REMOVE)) {
            this.cascadeRemoveManager.removeScalarBar(this.currentVtkObject);
        } else if (command.equals(SCALAR_BAR_CONTROL)) {
            ((ScalarBarControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setVisible(true);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if ((ScalarBarControlDialog)this.controlDialogTable.get(this.currentVtkObject) == null) {
            this.controlDialogTable.put(this.currentVtkObject, new ScalarBarControlDialog(CassandraToolBox.getParentFrame(invoker), this.pipeLineManager));
            ((ScalarBarControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setScalarBar(this.currentVtkObject);
        }
        super.show(invoker, x, y);
    }

    private class LookupTableSetter
    implements ActionListener {
        private vtkLookupTable lookupTable;

        public LookupTableSetter(vtkLookupTable lookupTable) {
            this.lookupTable = lookupTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((vtkScalarBarActor)ScalarBarPopupMenu.this.currentVtkObject.getVtkObject()).SetLookupTable((vtkScalarsToColors)this.lookupTable);
            ScalarBarPopupMenu.this.pipeLineManager.notifyConnectivityChange(ScalarBarPopupMenu.this.currentVtkObject);
            ScalarBarPopupMenu.this.pipeLineManager.validateViewAndGo();
        }
    }
}

