/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.util.FileItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.prefs.Preferences;
import javax.swing.JMenu;

public class RecentFilesManager
extends JMenu
implements ActionListener {
    public static final String PROPERTIES_PREFIX = "com.artenum.cassandra.recent.files";
    public final String LENGTH_FLAG = "length";
    public static final String RECENT_SELECTED_FILE_ACTION = "recent.selected.file.action";
    private ArrayList<File> recentFileList = new ArrayList();
    private ArrayList<ActionListener> externalActionListener = new ArrayList();
    private int nbMaxRecentFiles = 4;
    private boolean autoSave = true;
    private FileItem selectedItem;

    public RecentFilesManager() {
        this.setText("Recent files");
    }

    @Override
    public void addActionListener(ActionListener listener) {
        super.addActionListener(listener);
        this.externalActionListener.add(listener);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getItem(i) == null) continue;
            this.getItem(i).addActionListener(listener);
        }
    }

    public void addFile(File file) {
        if (this.recentFileList.size() >= this.nbMaxRecentFiles) {
            this.recentFileList.remove(0);
        }
        this.recentFileList.add(file);
        this.updateView(file);
        if (this.autoSave) {
            this.saveFileListToProperties();
        }
    }

    private void updateView(File file) {
        FileItem item = new FileItem();
        item.setFile(file);
        item.setText(file.getAbsolutePath());
        item.setActionCommand(RECENT_SELECTED_FILE_ACTION);
        item.addActionListener(this);
        Iterator<ActionListener> iter = this.externalActionListener.iterator();
        while (iter.hasNext()) {
            item.addActionListener(iter.next());
        }
        this.add(item);
    }

    public void saveFileListToProperties() {
        int listSize = 0;
        listSize = this.recentFileList.size() < this.nbMaxRecentFiles ? this.recentFileList.size() : this.nbMaxRecentFiles;
        Preferences.userRoot().putInt("com.artenum.cassandra.recent.files.length", listSize);
        for (File file : this.recentFileList) {
            Preferences.userRoot().put("com.artenum.cassandra.recent.files." + this.recentFileList.indexOf(file), file.getAbsolutePath());
        }
    }

    public void readFileListFromProperties() {
        int bookMarkTmpSize = Preferences.userRoot().getInt("com.artenum.cassandra.recent.files.length", 0);
        for (int i = 0; i < bookMarkTmpSize; ++i) {
            this.addFile(new File(Preferences.userRoot().get("com.artenum.cassandra.recent.files." + i, new File(".").getAbsolutePath())));
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.selectedItem = (FileItem)evt.getSource();
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public FileItem getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(FileItem selectedItem) {
        this.selectedItem = selectedItem;
    }
}

