/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.jyconsole.JyConsole;
import com.artenum.jyconsole.ui.PreferenceDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class PopupMenu
extends MouseAdapter
implements ActionListener {
    private JyConsole console;
    private JPopupMenu popupMenu;
    private PreferenceDialog prefDialog;

    public PopupMenu(JyConsole jyConsole) {
        this.console = jyConsole;
        this.popupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Load a script");
        jMenuItem.setActionCommand("LOAD_SCRIPT");
        jMenuItem.addActionListener(this);
        this.popupMenu.add(jMenuItem);
        this.prefDialog = new PreferenceDialog(jyConsole);
        JMenuItem jMenuItem2 = new JMenuItem("Change style");
        jMenuItem2.setActionCommand("STYLE");
        jMenuItem2.addActionListener(this);
        this.popupMenu.add(jMenuItem2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("LOAD_SCRIPT")) {
            JFileChooser jFileChooser = new JFileChooser();
            if (this.console.getPreferences().get("jyconsole.pref.script.dir") != null) {
                jFileChooser.setCurrentDirectory(new File((String)this.console.getPreferences().get("jyconsole.pref.script.dir")));
            }
            if (jFileChooser.showOpenDialog(this.console) == 0) {
                this.console.executePythonFile(jFileChooser.getSelectedFile());
            }
        } else if (string.equals("STYLE")) {
            this.prefDialog.setVisible(true);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

