/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.nisaba.util;

import com.artenum.nisaba.util.VectorUtilDouble;
import java.util.Vector;

public class MatrixUtilDouble {
    private MatrixUtilDouble() {
    }

    public static final double[] applyTransform3(double[] matrix3, double[] vect3) {
        double[] result = new double[]{matrix3[0] * vect3[0] + matrix3[1] * vect3[1] + matrix3[2] * vect3[2], matrix3[3] * vect3[0] + matrix3[4] * vect3[1] + matrix3[5] * vect3[2], matrix3[6] * vect3[0] + matrix3[7] * vect3[1] + matrix3[8] * vect3[2]};
        return result;
    }

    public static final double detM3(double[] matrix) {
        double a = matrix[0];
        double b = matrix[1];
        double c = matrix[2];
        double d = matrix[3];
        double e = matrix[4];
        double f = matrix[5];
        double g = matrix[6];
        double h = matrix[7];
        double i = matrix[8];
        return a * (e * i - f * h) - b * (d * i - f * g) + c * (d * h - e * g);
    }

    public static double detM4(double[] m) {
        return m[3] * m[6] * m[9] * m[12] - m[2] * m[7] * m[9] * m[12] - m[3] * m[5] * m[10] * m[12] + m[1] * m[7] * m[10] * m[12] + m[2] * m[5] * m[11] * m[12] - m[1] * m[6] * m[11] * m[12] - m[3] * m[6] * m[8] * m[13] + m[2] * m[7] * m[8] * m[13] + m[3] * m[4] * m[10] * m[13] - m[0] * m[7] * m[10] * m[13] - m[2] * m[4] * m[11] * m[13] + m[0] * m[6] * m[11] * m[13] + m[3] * m[5] * m[8] * m[14] - m[1] * m[7] * m[8] * m[14] - m[3] * m[4] * m[9] * m[14] + m[0] * m[7] * m[9] * m[14] + m[1] * m[4] * m[11] * m[14] - m[0] * m[5] * m[11] * m[14] - m[2] * m[5] * m[8] * m[15] + m[1] * m[6] * m[8] * m[15] + m[2] * m[4] * m[9] * m[15] - m[0] * m[6] * m[9] * m[15] - m[1] * m[4] * m[10] * m[15] + m[0] * m[5] * m[10] * m[15];
    }

    public static final double[] matrix3Inv(double[] matrix) {
        double[] result = new double[9];
        double detM = MatrixUtilDouble.detM3(matrix);
        VectorUtilDouble.div(result, detM);
        return result;
    }

    public static double[] invert(double[] matrix) {
        int p;
        double a;
        int matrixSize = (int)Math.sqrt(matrix.length);
        double[] result = new double[matrix.length];
        double[] tmpMatrix = new double[matrix.length];
        Vector<Integer> I = new Vector<Integer>();
        Vector<Integer> J = new Vector<Integer>();
        for (int i = 0; i < matrixSize; ++i) {
            for (int j = 0; j < matrixSize; ++j) {
                tmpMatrix[i * matrixSize + j] = matrix[i * matrixSize + j];
                result[i * matrixSize + j] = i == j ? 1.0 : 0.0;
            }
        }
        boolean bk = true;
        boolean bl = true;
        int cnt_row = 0;
        int cnt_col = 0;
        for (int k = 0; k < matrixSize && bk; ++k) {
            if (I.contains(k)) continue;
            I.addElement(k);
            ++cnt_row;
            bl = true;
            for (int l = 0; l < matrixSize && bl; ++l) {
                if (J.contains(l) || (a = tmpMatrix[k * matrixSize + l]) == 0.0) continue;
                J.addElement(l);
                ++cnt_col;
                bl = false;
                for (p = 0; p < matrixSize; ++p) {
                    if (p == k) continue;
                    double tmp = tmpMatrix[p * matrixSize + l];
                    for (int q = 0; q < matrixSize; ++q) {
                        tmpMatrix[p * matrixSize + q] = tmpMatrix[p * matrixSize + q] - tmpMatrix[k * matrixSize + q] * (tmp / a);
                        result[p * matrixSize + q] = result[p * matrixSize + q] - result[k * matrixSize + q] * (tmp / a);
                    }
                }
            }
            if (cnt_row == cnt_col) continue;
            bk = false;
            k = matrixSize;
        }
        if (!bk) {
            System.out.println("Matrix is singular");
            for (int i = 0; i < matrixSize; ++i) {
                for (int j = 0; j < matrixSize; ++j) {
                    result[j * matrixSize + i] = matrix[j * matrixSize + i];
                }
            }
            return null;
        }
        for (int l = 0; l < matrixSize; ++l) {
            for (int k = 0; k < matrixSize; ++k) {
                a = tmpMatrix[k * matrixSize + l];
                if (a == 0.0) continue;
                tmpMatrix[k * matrixSize + l] = 1.0;
                for (p = 0; p < matrixSize; ++p) {
                    result[k * matrixSize + p] = result[k * matrixSize + p] / a;
                }
                if (k != l) {
                    MatrixUtilDouble.exchange_row(tmpMatrix, k + 1, l + 1, matrixSize);
                    MatrixUtilDouble.exchange_row(result, k + 1, l + 1, matrixSize);
                }
                k = matrixSize;
            }
        }
        return result;
    }

    public static void exchange_row(double[] matrix, int k, int l, int n) {
        if (k <= 0 || l <= 0 || k > n || l > n || k == l) {
            return;
        }
        for (int j = 0; j < n; ++j) {
            double tmp = matrix[(k - 1) * n + j];
            matrix[n * (k - 1) + j] = matrix[n * (l - 1) + j];
            matrix[n * (l - 1) + j] = tmp;
        }
    }

    public static double[] generateZXFrame3(double[] zDirection, double[] xMainDirection) {
        double[] z = VectorUtilDouble.copy(zDirection);
        double[] y = VectorUtilDouble.dotProduct(z, xMainDirection);
        VectorUtilDouble.normalize3(y);
        VectorUtilDouble.normalize3(z);
        double[] x = VectorUtilDouble.dotProduct3(y, z);
        return new double[]{x[0], x[1], x[2], y[0], y[1], y[2], z[0], z[1], z[2]};
    }
}

