/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.nisaba.util;

import com.artenum.nisaba.util.MatrixUtilDouble;
import com.artenum.nisaba.util.Quaternion;
import com.artenum.nisaba.util.VectorUtilDouble;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;

public class RotationTransform {
    private static final double[] globalXAxis = new double[]{1.0, 0.0, 0.0};
    private static final double[] globalYAxis = new double[]{0.0, 1.0, 0.0};
    private static final double[] globalZAxis = new double[]{0.0, 0.0, 1.0};
    private double[] rotationMatrix = new double[9];
    private static final double[] ROTATION_IDENTITY = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0};
    private static final NumberFormat nf = new DecimalFormat("#.####");

    public RotationTransform() {
        this.setToIdentity();
    }

    public RotationTransform(RotationTransform t) {
        this();
        for (int i = 0; i < 9; ++i) {
            this.rotationMatrix[i] = t.rotationMatrix[i];
        }
    }

    public RotationTransform(Quaternion quaternion) {
        this();
        this.rotation(quaternion);
    }

    public RotationTransform(double ... rot) {
        this();
        this.rotation(rot);
    }

    public void setToIdentity() {
        this.rotationMatrix = VectorUtilDouble.copy(ROTATION_IDENTITY);
    }

    public Quaternion getQuaternion() {
        double z;
        double y;
        double x;
        double w;
        double S;
        double m00 = this.rotationMatrix[0];
        double m01 = this.rotationMatrix[1];
        double m02 = this.rotationMatrix[2];
        double m10 = this.rotationMatrix[3];
        double m11 = this.rotationMatrix[4];
        double m12 = this.rotationMatrix[5];
        double m20 = this.rotationMatrix[6];
        double m21 = this.rotationMatrix[7];
        double m22 = this.rotationMatrix[8];
        double tr = m00 + m11 + m22;
        if (tr > 0.0) {
            S = Math.sqrt(tr + 1.0) * 2.0;
            w = 0.25 * S;
            x = (m21 - m12) / S;
            y = (m02 - m20) / S;
            z = (m10 - m01) / S;
        } else if (m00 > m11 & m00 > m22) {
            S = Math.sqrt(1.0 + m00 - m11 - m22) * 2.0;
            w = (m21 - m12) / S;
            x = 0.25 * S;
            y = (m01 + m10) / S;
            z = (m02 + m20) / S;
        } else if (m11 > m22) {
            S = Math.sqrt(1.0 + m11 - m00 - m22) * 2.0;
            w = (m02 - m20) / S;
            x = (m01 + m10) / S;
            y = 0.25 * S;
            z = (m12 + m21) / S;
        } else {
            S = Math.sqrt(1.0 + m22 - m00 - m11) * 2.0;
            w = (m10 - m01) / S;
            x = (m02 + m20) / S;
            y = (m12 + m21) / S;
            z = 0.25 * S;
        }
        Quaternion q = new Quaternion();
        q.setQuaternionXYZW(x, y, z, w);
        q.normalize();
        return q;
    }

    public RotationTransform rotation(double angle, double[] axis) {
        return this.rotation(new Quaternion(angle, axis));
    }

    public RotationTransform rotation(Quaternion quaternion) {
        quaternion.getTransform(this.rotationMatrix);
        return this;
    }

    public RotationTransform rotation(double[] transformMatrix) {
        for (int i = 0; i < 9; ++i) {
            this.rotationMatrix[i] = transformMatrix[i];
        }
        return this;
    }

    public RotationTransform rotationX(double angle) {
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        this.rotationMatrix = new double[]{1.0, 0.0, 0.0, 0.0, ca, sa, 0.0, -sa, ca};
        return this;
    }

    public RotationTransform rotationY(double angle) {
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        this.rotationMatrix = new double[]{ca, 0.0, sa, 0.0, 1.0, 0.0, -sa, 0.0, ca};
        return this;
    }

    public RotationTransform rotationZ(double angle) {
        double ca = Math.cos(angle);
        double sa = Math.sin(angle);
        this.rotationMatrix = new double[]{ca, sa, 0.0, -sa, ca, 0.0, 0.0, 0.0, 1.0};
        return this;
    }

    public RotationTransform rotationZXZ(double z1, double x2, double z3) {
        double ca = Math.cos(z1);
        double sa = Math.sin(z1);
        double cb = Math.cos(x2);
        double sb = Math.sin(x2);
        double cc = Math.cos(z3);
        double sc = Math.sin(z3);
        this.rotationMatrix = new double[]{ca * cc - sa * sc * cb, -sa * cc - ca * cb * sc, sb * sc, ca * sc + sa * cb * cc, -sa * sc + ca * cb * cc, -sb * cc, sa * sb, ca * sb, cb};
        return this;
    }

    public void getRotation(double[] outputMatrix3) {
        for (int i = 0; i < 9; ++i) {
            outputMatrix3[i] = this.rotationMatrix[i];
        }
    }

    public void addGlobalRotationTransform(RotationTransform t) {
        double[] newRotationMatrix = new double[9];
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                newRotationMatrix[i + 3 * j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    int n = i + 3 * j;
                    newRotationMatrix[n] = newRotationMatrix[n] + this.rotationMatrix[3 * j + k] * t.rotationMatrix[i + 3 * k];
                }
            }
        }
        this.rotation(newRotationMatrix);
    }

    public void addLocalRotationTransform(RotationTransform t) {
        double[] newRotationMatrix = new double[9];
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 3; ++i) {
                newRotationMatrix[i + 3 * j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    int n = i + 3 * j;
                    newRotationMatrix[n] = newRotationMatrix[n] + t.rotationMatrix[3 * j + k] * this.rotationMatrix[i + 3 * k];
                }
            }
        }
        this.rotation(newRotationMatrix);
    }

    public double[] applyRotation(double[] vect3) {
        return MatrixUtilDouble.applyTransform3(this.rotationMatrix, vect3);
    }

    public double[] getRotationXYZ() {
        return new double[]{-Math.atan2(this.rotationMatrix[5], this.rotationMatrix[8]), -Math.asin(-this.rotationMatrix[2]), -Math.atan2(this.rotationMatrix[1], this.rotationMatrix[0])};
    }

    public double[] getRotationZXZ() {
        double tolerance = 1.0E-6;
        if (Math.abs(this.rotationMatrix[8] - 1.0) < 1.0E-6) {
            return new double[]{this.rotationMatrix[3] > 0.0 ? Math.acos(this.rotationMatrix[0]) : -Math.acos(this.rotationMatrix[0]), 0.0, 0.0};
        }
        double z1 = Math.atan2(this.rotationMatrix[6], this.rotationMatrix[7]);
        double x2 = Math.acos(this.rotationMatrix[8]);
        double z3 = Math.atan2(-this.rotationMatrix[2], this.rotationMatrix[5]);
        return new double[]{z1, x2, z3 + Math.PI};
    }

    public double[] getRotationAxisAngle() {
        double angle = Math.acos((this.rotationMatrix[0] + this.rotationMatrix[4] + this.rotationMatrix[8] - 1.0) / 2.0);
        double sin2angle = 2.0 * Math.sin(angle);
        return new double[]{(this.rotationMatrix[7] - this.rotationMatrix[5]) / sin2angle, (this.rotationMatrix[2] - this.rotationMatrix[6]) / sin2angle, (this.rotationMatrix[3] - this.rotationMatrix[1]) / sin2angle, angle};
    }

    public static boolean compare(RotationTransform t1, RotationTransform t2, double tolerance) {
        for (int i = 0; i < 9; ++i) {
            if (!(Math.abs(t1.rotationMatrix[i] - t2.rotationMatrix[i]) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public boolean compare(RotationTransform t2, double tolerance) {
        return RotationTransform.compare(this, t2, tolerance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.rotationMatrix);
        return result;
    }

    public double[] getXAxis() {
        return new double[]{this.rotationMatrix[0], this.rotationMatrix[1], this.rotationMatrix[2]};
    }

    public double[] getYAxis() {
        return new double[]{this.rotationMatrix[3], this.rotationMatrix[4], this.rotationMatrix[5]};
    }

    public double[] getZAxis() {
        return new double[]{this.rotationMatrix[6], this.rotationMatrix[7], this.rotationMatrix[8]};
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RotationTransform other = (RotationTransform)obj;
        return Arrays.equals(this.rotationMatrix, other.rotationMatrix);
    }

    public String toString(double value) {
        return nf.format(value);
    }

    public String toString() {
        return "rot:\t| " + this.toString(this.rotationMatrix[0]) + " " + this.toString(this.rotationMatrix[1]) + " " + this.toString(this.rotationMatrix[2]) + " |\n" + "\t| " + this.toString(this.rotationMatrix[3]) + " " + this.toString(this.rotationMatrix[4]) + " " + this.toString(this.rotationMatrix[5]) + " |\n" + "\t| " + this.toString(this.rotationMatrix[6]) + " " + this.toString(this.rotationMatrix[7]) + " " + this.toString(this.rotationMatrix[8]) + " |";
    }

    public void setRotation(double angle, double[] axis) {
        this.rotation(new Quaternion(angle, axis));
    }

    public void addRotation(double angle, double[] axis) {
        this.addGlobalRotationTransform(new RotationTransform().rotation(new Quaternion(angle, axis)));
    }

    public double[] getLocalXAxis() {
        return this.getXAxis();
    }

    public double[] getLocalYAxis() {
        return this.getYAxis();
    }

    public double[] getLocalZAxis() {
        return this.getZAxis();
    }

    public void addLocalXRotation(double angle) {
        this.addRotation(angle, this.getLocalXAxis());
    }

    public void addLocalYRotation(double angle) {
        this.addRotation(angle, this.getLocalYAxis());
    }

    public void addLocalZRotation(double angle) {
        this.addRotation(angle, this.getLocalZAxis());
    }

    public void addAbsoluteXRotation(double angle) {
        this.addRotation(angle, globalXAxis);
    }

    public void addAbsoluteYRotation(double angle) {
        this.addRotation(angle, globalYAxis);
    }

    public void addAbsoluteZRotation(double angle) {
        this.addRotation(angle, globalZAxis);
    }

    public double[] getLocalZXZAngles() {
        return this.getRotationZXZ();
    }

    public double[] getGlobalZXZAngles() {
        double[] zxz = this.getRotationZXZ();
        return new double[]{zxz[2], zxz[1], zxz[0]};
    }

    public double[] getGlobalAngleAxis() {
        return this.getQuaternion().getAxis();
    }
}

