/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.SimpleObjectFactory;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;
import org.jfree.xml.writer.XmlWriteHandler;
import org.jfree.xml.writer.coretypes.BasicStrokeWriteHandler;
import org.jfree.xml.writer.coretypes.ColorWriteHandler;
import org.jfree.xml.writer.coretypes.FontWriteHandler;
import org.jfree.xml.writer.coretypes.GenericWriteHandler;
import org.jfree.xml.writer.coretypes.GradientPaintWriteHandler;
import org.jfree.xml.writer.coretypes.InsetsWriteHandler;
import org.jfree.xml.writer.coretypes.ListWriteHandler;
import org.jfree.xml.writer.coretypes.Point2DWriteHandler;
import org.jfree.xml.writer.coretypes.Rectangle2DWriteHandler;
import org.jfree.xml.writer.coretypes.RenderingHintsWriteHandler;

public abstract class RootXmlWriteHandler {
    private SimpleObjectFactory classToHandlerMapping = new SimpleObjectFactory();

    public RootXmlWriteHandler() {
        MultiplexMappingEntry[] paintEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("color", Color.class.getName()), new MultiplexMappingEntry("gradientPaint", GradientPaint.class.getName())};
        this.addMultiplexMapping(Paint.class, "type", paintEntries);
        this.addManualMapping(GradientPaint.class, GradientPaintWriteHandler.class);
        this.addManualMapping(Color.class, ColorWriteHandler.class);
        MultiplexMappingEntry[] point2DEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Point2D.Float.class.getName()), new MultiplexMappingEntry("double", Point2D.Double.class.getName())};
        this.addMultiplexMapping(Point2D.class, "type", point2DEntries);
        this.addManualMapping(Point2D.Float.class, Point2DWriteHandler.class);
        this.addManualMapping(Point2D.Double.class, Point2DWriteHandler.class);
        MultiplexMappingEntry[] strokeEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("basic", BasicStroke.class.getName())};
        this.addMultiplexMapping(Stroke.class, "type", strokeEntries);
        this.addManualMapping(BasicStroke.class, BasicStrokeWriteHandler.class);
        MultiplexMappingEntry[] rectangle2DEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Rectangle2D.Float.class.getName()), new MultiplexMappingEntry("double", Rectangle2D.Double.class.getName())};
        this.addMultiplexMapping(Rectangle2D.class, "type", rectangle2DEntries);
        this.addManualMapping(Rectangle2D.Float.class, Rectangle2DWriteHandler.class);
        this.addManualMapping(Rectangle2D.Double.class, Rectangle2DWriteHandler.class);
        MultiplexMappingEntry[] listEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("array-list", ArrayList.class.getName()), new MultiplexMappingEntry("linked-list", LinkedList.class.getName()), new MultiplexMappingEntry("vector", Vector.class.getName()), new MultiplexMappingEntry("stack", Stack.class.getName())};
        this.addMultiplexMapping(List.class, "type", listEntries);
        this.addManualMapping(LinkedList.class, ListWriteHandler.class);
        this.addManualMapping(Vector.class, ListWriteHandler.class);
        this.addManualMapping(ArrayList.class, ListWriteHandler.class);
        this.addManualMapping(Stack.class, ListWriteHandler.class);
        this.addManualMapping(RenderingHints.class, RenderingHintsWriteHandler.class);
        this.addManualMapping(Insets.class, InsetsWriteHandler.class);
        this.addManualMapping(Font.class, FontWriteHandler.class);
    }

    protected abstract ObjectFactory getFactoryLoader();

    protected void addManualMapping(Class classToWrite, Class handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (classToWrite == null) {
            throw new NullPointerException("classToWrite must not be null.");
        }
        if (!XmlWriteHandler.class.isAssignableFrom(handler)) {
            throw new IllegalArgumentException("The given handler is no XmlWriteHandler.");
        }
        this.classToHandlerMapping.addManualMapping(new ManualMappingDefinition(classToWrite, null, handler.getName()));
    }

    protected void addMultiplexMapping(Class baseClass, String typeAttr, MultiplexMappingEntry[] mdef) {
        this.classToHandlerMapping.addMultiplexMapping(new MultiplexMappingDefinition(baseClass, typeAttr, mdef));
    }

    protected XmlWriteHandler getMapping(Class classToWrite) throws XMLWriterException {
        if (classToWrite == null) {
            throw new NullPointerException("ClassToWrite is null.");
        }
        ManualMappingDefinition manualMapping = this.classToHandlerMapping.getManualMappingDefinition(classToWrite);
        if (manualMapping == null) {
            manualMapping = this.getFactoryLoader().getManualMappingDefinition(classToWrite);
        }
        if (manualMapping != null) {
            return this.loadHandlerClass(manualMapping.getWriteHandler());
        }
        if (this.classToHandlerMapping.isGenericHandler(classToWrite)) {
            return new GenericWriteHandler(this.classToHandlerMapping.getFactoryForClass(classToWrite));
        }
        if (this.getFactoryLoader().isGenericHandler(classToWrite)) {
            return new GenericWriteHandler(this.getFactoryLoader().getFactoryForClass(classToWrite));
        }
        throw new XMLWriterException("Unable to handle " + classToWrite);
    }

    public void write(String tagName, Object object, Class baseClass, XMLWriter writer) throws IOException, XMLWriterException {
        if (object == null) {
            return;
        }
        if (tagName == null) {
            throw new NullPointerException("RootXmlWriteHandler.write(..) : tagName is null");
        }
        if (writer == null) {
            throw new NullPointerException("RootXmlWriteHandler.write(..) : writer is null");
        }
        if (!baseClass.isInstance(object)) {
            throw new ClassCastException("Object is no instance of " + baseClass);
        }
        Class<?> classToWrite = object.getClass();
        XmlWriteHandler handler = this.getMapping(classToWrite);
        handler.setRootHandler(this);
        String attributeName = null;
        String attributeValue = null;
        MultiplexMappingDefinition mplex = this.getFactoryLoader().getMultiplexDefinition(baseClass);
        if (mplex == null) {
            mplex = this.classToHandlerMapping.getMultiplexDefinition(baseClass);
        }
        if (mplex != null) {
            MultiplexMappingEntry entry = mplex.getEntryForClass(classToWrite.getName());
            if (entry != null) {
                attributeName = mplex.getAttributeName();
                attributeValue = entry.getAttributeValue();
            } else {
                throw new XMLWriterException("Unable to find child mapping for multiplexer " + baseClass + " to child " + classToWrite);
            }
        }
        handler.write(tagName, object, writer, attributeName, attributeValue);
        writer.allowLineBreak();
    }

    protected XmlWriteHandler loadHandlerClass(String className) throws XMLWriterException {
        if (className == null) {
            throw new XMLWriterException("LoadHanderClass: Class name not defined");
        }
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            return (XmlWriteHandler)c.newInstance();
        }
        catch (Exception e) {
            throw new XMLWriterException("LoadHanderClass: Unable to instantiate " + className, e);
        }
    }
}

