/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.iterator.SingleVertexIterator;
import com.artenum.penelope.plugin.vtk.VtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.VtkGridBuilder;
import com.artenum.penelope.plugin.vtk.VtkToolBox;
import java.util.Iterator;
import vtk.vtkCellData;
import vtk.vtkDataArray;
import vtk.vtkDataSet;
import vtk.vtkUnstructuredGrid;

public class FaceVtkDataSetBuilder
implements VtkDataSetBuilder<Face> {
    private VtkGridBuilder gridBuilder;

    @Override
    public vtkDataSet buildVtkDataSet(DataField<?, Face> datafield, MeshType localisation) {
        vtkUnstructuredGrid faceDataSet = this.buildVtkUnstructuredGrid(datafield, localisation);
        vtkCellData getCellData = faceDataSet.GetCellData();
        vtkDataArray mapData = VtkToolBox.mapData(datafield);
        getCellData.SetScalars(mapData);
        return faceDataSet;
    }

    @Override
    public vtkUnstructuredGrid buildVtkUnstructuredGrid(DataField<?, Face> datafield, MeshType localisation) {
        vtkUnstructuredGrid grid = null;
        if (localisation != MeshType.FACE) {
            throw new UnsupportedOperationException("Unsupported visualisation location: " + localisation);
        }
        Iterator meshElementIterator = datafield.getMeshMask().getMeshElementIterator();
        SingleVertexIterator vertexIterator = new SingleVertexIterator(meshElementIterator);
        Iterator meshElementIterator2 = datafield.getMeshMask().getMeshElementIterator();
        this.gridBuilder = new VtkGridBuilder((Iterator<Vertex>)vertexIterator, meshElementIterator2, localisation);
        grid = this.gridBuilder.buildVtkUnstructuredGrid();
        return grid;
    }

    @Override
    public MeshType[] getAvailableVisualisationLocations() {
        return new MeshType[]{MeshType.FACE};
    }

    @Override
    public VtkGridBuilder getGridBuilder() {
        return this.gridBuilder;
    }
}

