/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import vtk.vtkIdList;
import vtk.vtkPoints;
import vtk.vtkUnstructuredGrid;

public class VtkGridBuilder {
    private static final int VTK_TYPE_NODE = 1;
    private static final int VTK_TYPE_EDGE = 3;
    private static final int VTK_TYPE_FACE = 5;
    private static final int VTK_TYPE_CELL = 10;
    private Iterator<Vertex> vertexIterator;
    private Iterator<? extends Edge> meshElementIterator;
    private final Map<Integer, Integer> penelopeVertexIdToVtkNodeId;
    private final Map<Integer, Integer> vtkCellIdToMeshElementPenelopeId;
    private final MeshType localisation;

    public VtkGridBuilder(Mesh mesh, MeshType aLocalisation) {
        this.vertexIterator = mesh.getVertexIterator();
        this.vtkCellIdToMeshElementPenelopeId = new HashMap<Integer, Integer>();
        this.penelopeVertexIdToVtkNodeId = new HashMap<Integer, Integer>();
        this.localisation = aLocalisation;
        switch (this.localisation) {
            case VERTEX: {
                break;
            }
            case EDGE: {
                this.meshElementIterator = mesh.getEdgeIterator();
                break;
            }
            case FACE: {
                this.meshElementIterator = mesh.getFaceIterator();
                break;
            }
            case POLYHEDRON: {
                this.meshElementIterator = mesh.getPolyhedronIterator();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported localisation: " + this.localisation);
            }
        }
    }

    public VtkGridBuilder(Iterator<Vertex> aVertexIterator, Iterator<? extends Edge> aMeshElementIterator, MeshType aLocalisation) {
        this.localisation = aLocalisation;
        this.penelopeVertexIdToVtkNodeId = new HashMap<Integer, Integer>();
        this.vertexIterator = aVertexIterator;
        this.meshElementIterator = aMeshElementIterator;
        this.vtkCellIdToMeshElementPenelopeId = new HashMap<Integer, Integer>();
    }

    public vtkUnstructuredGrid buildVtkUnstructuredGrid() {
        switch (this.localisation) {
            case VERTEX: {
                return this.buildVtkUnstructuredGridOnVertices();
            }
            case EDGE: {
                return this.buildVtkUnstructuredGridOnMeshElement();
            }
            case FACE: {
                return this.buildVtkUnstructuredGridOnMeshElement();
            }
            case POLYHEDRON: {
                return this.buildVtkUnstructuredGridOnMeshElement();
            }
        }
        throw new UnsupportedOperationException("Unsupported localisation: " + this.localisation);
    }

    private vtkUnstructuredGrid buildVtkUnstructuredGridOnVertices() {
        vtkUnstructuredGrid grid = new vtkUnstructuredGrid();
        vtkPoints points = new vtkPoints();
        grid.SetPoints(points);
        int counter = 0;
        while (this.vertexIterator.hasNext()) {
            Vertex currentVertex = this.vertexIterator.next();
            Point point = currentVertex.getPoint();
            double[] coord = point.getCoord();
            double xCoord = coord[0];
            double yCoord = coord[1];
            double zCoord = coord[2];
            points.InsertPoint(counter, xCoord, yCoord, zCoord);
            vtkIdList idList = new vtkIdList();
            idList.InsertNextId(counter);
            int vtkCellId = grid.InsertNextCell(this.getVtkLocalisation(MeshType.VERTEX), idList);
            this.vtkCellIdToMeshElementPenelopeId.put(vtkCellId, currentVertex.getId());
            ++counter;
        }
        return grid;
    }

    private vtkUnstructuredGrid buildVtkUnstructuredGridOnMeshElement() {
        vtkUnstructuredGrid grid = new vtkUnstructuredGrid();
        vtkPoints buildVtkPoints = this.buildVtkPoints();
        grid.SetPoints(buildVtkPoints);
        boolean addMeshElement = true;
        int vtkLocalisation = this.getVtkLocalisation(this.localisation);
        while (this.meshElementIterator.hasNext()) {
            Edge currentMeshElement = this.meshElementIterator.next();
            addMeshElement = true;
            vtkIdList idList = new vtkIdList();
            for (Vertex currentVertex : currentMeshElement.getVertices()) {
                Integer value = this.penelopeVertexIdToVtkNodeId.get(currentVertex.getId());
                if (value != null) {
                    idList.InsertNextId(value.intValue());
                    continue;
                }
                addMeshElement = false;
            }
            if (!addMeshElement) continue;
            int vtkMeshELementId = grid.InsertNextCell(vtkLocalisation, idList);
            this.vtkCellIdToMeshElementPenelopeId.put(vtkMeshELementId, currentMeshElement.getId());
        }
        this.meshElementIterator = null;
        return grid;
    }

    private vtkPoints buildVtkPoints() {
        vtkPoints points = new vtkPoints();
        int counter = 0;
        while (this.vertexIterator.hasNext()) {
            Vertex currentVertex = this.vertexIterator.next();
            this.penelopeVertexIdToVtkNodeId.put(currentVertex.getId(), counter);
            double[] coord = currentVertex.getPoint().getCoord();
            points.InsertPoint(counter, coord[0], coord[1], coord[2]);
            ++counter;
        }
        this.vertexIterator = null;
        return points;
    }

    private int getVtkLocalisation(MeshType penelopeLocalisation) {
        switch (penelopeLocalisation) {
            case VERTEX: {
                return 1;
            }
            case EDGE: {
                return 3;
            }
            case FACE: {
                return 5;
            }
            case POLYHEDRON: {
                return 10;
            }
        }
        throw new UnsupportedOperationException("Unsupported localisation: " + penelopeLocalisation);
    }

    public void clear() {
        this.vertexIterator = null;
        this.meshElementIterator = null;
        this.penelopeVertexIdToVtkNodeId.clear();
        this.vtkCellIdToMeshElementPenelopeId.clear();
    }

    public Map<Integer, Integer> getPenelopeVertexIdToVtkNodeId() {
        return this.penelopeVertexIdToVtkNodeId;
    }

    public Map<Integer, Integer> getVtkCellIdToMeshElementPenelopeId() {
        return this.vtkCellIdToMeshElementPenelopeId;
    }
}

