/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.geo.io;

import com.artenum.penelope.plugin.gmsh.geo.model.GeoEdge;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoElement;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoLineLoop;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoModel;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoPlaneSurface;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoPoint;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoRuledSurface;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoSurfaceLoop;
import com.artenum.penelope.plugin.gmsh.geo.model.GeoVolume;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;

public class GeoFileWriter {
    private File outputFile = null;
    private GeoModel cadModel = null;
    private String outputString = "";

    public GeoFileWriter(GeoModel cadModel) {
        this.cadModel = cadModel;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setOutputPath(String outputPath) {
        this.outputFile = new File(outputPath);
    }

    public void write() throws IOException {
        if (this.outputFile != null) {
            FileWriter writer = new FileWriter(this.outputFile);
            BufferedWriter bufWriter = new BufferedWriter(writer);
            bufWriter.write(this.export());
            bufWriter.flush();
            bufWriter.close();
        }
    }

    public String export() {
        this.outputString = "";
        this.writePoints();
        this.writeEdges();
        this.writeLineLoops();
        this.writePlaneSurfaces();
        this.writeRuledSurface();
        this.writeFaceLoop();
        this.writeVolumes();
        return this.outputString;
    }

    public void writePoints() {
        GeoPoint tmpPoint2 = null;
        for (GeoPoint tmpPoint2 : this.cadModel.getPointsList()) {
            this.outputString = this.outputString + "Point (" + tmpPoint2.getId() + ") = {" + tmpPoint2.getCoord()[0] + ", " + tmpPoint2.getCoord()[1] + ", " + tmpPoint2.getCoord()[2] + ", " + tmpPoint2.getLocalResolution() + "};" + "\n";
        }
    }

    public void writeEdges() {
        String tmpIdsList = "";
        Object var2_2 = null;
        GeoPoint tmpPoint22 = null;
        Iterator<GeoPoint> pointIterator = null;
        for (GeoEdge geoEdge : this.cadModel.getLinesList()) {
            tmpIdsList = "";
            for (GeoPoint tmpPoint22 : geoEdge.getPointsOfEdge()) {
                if (tmpPoint22 != null) {
                    tmpIdsList = tmpIdsList + tmpPoint22.getId() + ", ";
                    continue;
                }
                System.err.println("NULL point found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Line (" + geoEdge.getId() + ") = {" + tmpIdsList + "};" + "\n";
        }
        for (GeoEdge geoEdge : this.cadModel.getCirclesList()) {
            tmpIdsList = "";
            for (GeoPoint tmpPoint22 : geoEdge.getPointsOfEdge()) {
                if (tmpPoint22 != null) {
                    tmpIdsList = tmpIdsList + tmpPoint22.getId() + ", ";
                    continue;
                }
                System.err.println("NULL point found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Circle (" + geoEdge.getId() + ") = {" + tmpIdsList + "};" + "\n";
        }
    }

    public void writeLineLoops() {
        String tmpIdsList = "";
        GeoLineLoop tmpLoop2 = null;
        for (GeoLineLoop tmpLoop2 : this.cadModel.getLineLoopsList()) {
            tmpIdsList = "";
            Iterator<GeoElement> edgesIter = tmpLoop2.getElementsOnLoop().iterator();
            if (edgesIter == null) {
                System.err.println("ITERATOR NULL");
            }
            while (edgesIter.hasNext()) {
                GeoElement tmpElm = edgesIter.next();
                int elmOrientation = tmpLoop2.getOrientationForElement(tmpElm);
                if (tmpElm != null) {
                    tmpIdsList = tmpIdsList + elmOrientation * tmpElm.getId() + ", ";
                    continue;
                }
                System.err.println("NULL element found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Line Loop (" + tmpLoop2.getId() + ") = {" + tmpIdsList + "};" + "\n";
        }
    }

    public void writePlaneSurfaces() {
        String tmpIdsList = "";
        GeoLineLoop tmpLoop2 = null;
        GeoPlaneSurface tmpPlaneSurface2 = null;
        for (GeoPlaneSurface tmpPlaneSurface2 : this.cadModel.getPlaneSurfacesList()) {
            tmpIdsList = "";
            for (GeoLineLoop tmpLoop2 : tmpPlaneSurface2.getLineLoopsOnFace()) {
                if (tmpLoop2 != null) {
                    tmpIdsList = tmpIdsList + tmpLoop2.getId() + ", ";
                    continue;
                }
                System.err.println("NULL line loop found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Plane Surface (" + tmpPlaneSurface2.getId() + ")  = {" + tmpIdsList + "};" + "\n";
        }
    }

    public void writeRuledSurface() {
        String tmpIdsList = "";
        GeoLineLoop tmpLoop2 = null;
        GeoRuledSurface tmpRuledSurface2 = null;
        for (GeoRuledSurface tmpRuledSurface2 : this.cadModel.getRuledSurfacesList()) {
            tmpIdsList = "";
            for (GeoLineLoop tmpLoop2 : tmpRuledSurface2.getLineLoopsOnFace()) {
                if (tmpLoop2 != null) {
                    tmpIdsList = tmpIdsList + tmpLoop2.getId() + ", ";
                    continue;
                }
                System.err.println("NULL line loop found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Ruled Surface (" + tmpRuledSurface2.getId() + ")  = {" + tmpIdsList + "};" + "\n";
        }
    }

    public void writeFaceLoop() {
        String tmpIdsList = "";
        GeoSurfaceLoop tmpSurfaceLoop2 = null;
        for (GeoSurfaceLoop tmpSurfaceLoop2 : this.cadModel.getSurfaceLoopsList()) {
            tmpIdsList = "";
            Iterator<GeoElement> facesIter = tmpSurfaceLoop2.getElementsOnLoop().iterator();
            if (facesIter == null) {
                System.err.println("ITERATOR NULL");
            }
            while (facesIter.hasNext()) {
                GeoElement tmpElm = facesIter.next();
                if (tmpElm != null) {
                    tmpIdsList = tmpIdsList + tmpElm.getId() + ", ";
                    continue;
                }
                System.err.println("NULL element found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Surface Loop (" + tmpSurfaceLoop2.getId() + ") = {" + tmpIdsList + "};" + "\n";
        }
    }

    public void writeVolumes() {
        String tmpIdsList = "";
        GeoVolume tmpVolume2 = null;
        GeoSurfaceLoop tmpSurfaceLoop2 = null;
        for (GeoVolume tmpVolume2 : this.cadModel.getVolumesList()) {
            tmpIdsList = "";
            for (GeoSurfaceLoop tmpSurfaceLoop2 : tmpVolume2.getSurfaceLoops()) {
                if (tmpSurfaceLoop2 != null) {
                    tmpIdsList = tmpIdsList + tmpSurfaceLoop2.getId() + ", ";
                    continue;
                }
                System.err.println("NULL line loop found");
                tmpIdsList = tmpIdsList + "NULL" + ", ";
            }
            tmpIdsList = tmpIdsList.substring(0, tmpIdsList.length() - 2);
            this.outputString = this.outputString + "Volume (" + tmpVolume2.getId() + ")  = {" + tmpIdsList + "};" + "\n";
        }
    }
}

