/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import java.util.Map;
import java.util.TreeMap;

public class GeometryIdMapper {
    private final Map<Integer, Integer> gmshVertexIdToPenelopeId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> gmshEdgeIdToPenelopeId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> gmshFaceIdToPenelopeId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> gmshPolyhedronIdToPenelopeId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> penelopeVertexIdToGmshId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> penelopeEdgeIdToGmshId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> penelopeFaceIdToGmshId = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> penelopePolyhedronIdToGmshId = new TreeMap<Integer, Integer>();

    public Map<Integer, Integer> getEdgeIdMap() {
        return this.gmshEdgeIdToPenelopeId;
    }

    public Map<Integer, Integer> getFaceIdMap() {
        return this.gmshFaceIdToPenelopeId;
    }

    public Integer getPenelopeVertexId(int gmshId) {
        return this.gmshVertexIdToPenelopeId.get(gmshId);
    }

    public Integer getPenelopeEdgeId(int gmshId) {
        return this.gmshEdgeIdToPenelopeId.get(gmshId);
    }

    public Integer getPenelopeFaceId(int gmshId) {
        return this.gmshFaceIdToPenelopeId.get(gmshId);
    }

    public Integer getPenelopePolyhedronId(int gmshId) {
        return this.gmshPolyhedronIdToPenelopeId.get(gmshId);
    }

    public Integer getGmshEdgeId(Integer penelopeIdSearched) {
        return this.penelopeEdgeIdToGmshId.get(penelopeIdSearched);
    }

    public Integer getGmshVertexId(Integer penelopeIdSearched) {
        return this.penelopeVertexIdToGmshId.get(penelopeIdSearched);
    }

    public Integer getGmshFaceId(Integer penelopeIdSearched) {
        return this.penelopeFaceIdToGmshId.get(penelopeIdSearched);
    }

    public Integer getGmshPolyhedronId(Integer penelopeIdSearched) {
        return this.penelopePolyhedronIdToGmshId.get(penelopeIdSearched);
    }

    public void addVertexIdMapping(int gmshId, int penelopeId) {
        this.gmshVertexIdToPenelopeId.put(gmshId, penelopeId);
        this.penelopeVertexIdToGmshId.put(penelopeId, gmshId);
    }

    public void addEdgeIdMapping(int gmshId, int penelopeId) {
        this.gmshEdgeIdToPenelopeId.put(gmshId, penelopeId);
        this.penelopeEdgeIdToGmshId.put(penelopeId, gmshId);
    }

    public void addFaceIdMapping(int gmshId, int penelopeId) {
        this.gmshFaceIdToPenelopeId.put(gmshId, penelopeId);
        this.penelopeFaceIdToGmshId.put(penelopeId, gmshId);
    }

    public void addPolyhedronIdMapping(int gmshId, int penelopeId) {
        this.gmshPolyhedronIdToPenelopeId.put(gmshId, penelopeId);
        this.penelopePolyhedronIdToGmshId.put(penelopeId, gmshId);
    }
}

