/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.gmsh.mesh;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.mesh.UnstructuredMesh;
import com.artenum.penelope.mesh.element.Node;
import com.artenum.penelope.mesh.element.Segment;
import com.artenum.penelope.mesh.element.Tetrahedron;
import com.artenum.penelope.mesh.element.Triangle;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshElement;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Point;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.io.FileFormatException;
import com.artenum.penelope.mesh.mask.EdgeMeshMask;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import com.artenum.penelope.mesh.mask.PolyhedronMeshMask;
import com.artenum.penelope.mesh.mask.VertexMeshMask;
import com.artenum.penelope.plugin.gmsh.mesh.GMSHFilePart22;
import com.artenum.penelope.plugin.gmsh.mesh.GeometryIdMapper;
import com.artenum.penelope.plugin.gmsh.mesh.GmshDataSection;
import com.artenum.penelope.plugin.gmsh.mesh.GmshMeshBuilder;
import com.artenum.penelope.plugin.gmsh.mesh.MeshFileEntity;
import com.artenum.penelope.plugin.gmsh.mesh.PhysicalName;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GmshMeshBuilder22
implements GmshMeshBuilder {
    private final MeshFileEntity currentMeshFileEntity = new MeshFileEntity();
    private final List<GmshDataSection> nodeData = new ArrayList<GmshDataSection>();
    private final List<GmshDataSection> elementData = new ArrayList<GmshDataSection>();
    private GmshDataSection currentElementDataSection = null;
    private GmshDataSection currentNodeDataSection = null;
    private final Set<Integer> elementFilter = new HashSet<Integer>();
    private int sectionHeaderPart = 0;
    private final Mesh mesh;
    private final File inputFile;
    private LineNumberReader lineReader;
    private final boolean storeOriginalIds;
    private final GeometryIdMapper idMapper;
    private GMSHFilePart22 currentFilePart;
    private final List<Vertex> point15List;
    private int currentId;
    private int[] groups;

    public GmshMeshBuilder22(File fileToRead) {
        this(fileToRead, (Mesh)new UnstructuredMesh(), true);
    }

    public GmshMeshBuilder22(File fileToRead, boolean storeIds) {
        this(fileToRead, (Mesh)new UnstructuredMesh(), storeIds);
    }

    public GmshMeshBuilder22(File fileToRead, Mesh aMesh, boolean storeIds) {
        this.mesh = aMesh == null ? new UnstructuredMesh() : aMesh;
        this.inputFile = fileToRead;
        this.storeOriginalIds = storeIds;
        this.idMapper = new GeometryIdMapper();
        this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
        this.point15List = new ArrayList<Vertex>();
    }

    public Mesh buildMeshAndIdReset() throws IOException, FileFormatException {
        this.buildMeshNoIdReset();
        this.mesh.clearIdentifiers();
        return this.mesh;
    }

    public Mesh buildMeshNoIdReset() throws IOException, FileFormatException {
        FileReader in = new FileReader(this.inputFile);
        this.lineReader = new LineNumberReader(in);
        this.readMesh();
        in.close();
        this.lineReader.close();
        this.mesh.finalizeMesh();
        return this.mesh;
    }

    private void readMesh() throws IOException {
        MeshFileEntity fileElement = null;
        DataFieldManager dataFieldManager = this.mesh.getDataFieldManager();
        while ((fileElement = this.nextFileEntity()) != null) {
            if (fileElement.isNodeElement()) {
                Vertex vertex = fileElement.getVertex();
                int readId = vertex.getId();
                int penelopeId = this.mesh.addMeshElementAndClearConnectivity(vertex);
                if (this.storeOriginalIds) {
                    this.idMapper.addVertexIdMapping(readId, penelopeId);
                }
            }
            if (fileElement.isMeshElement()) {
                int readId = fileElement.getMeshElement().getId();
                int penelopeId = -1;
                switch (fileElement.getMeshElement().getMeshType()) {
                    case VERTEX: {
                        Vertex vertex = (Vertex)fileElement.getMeshElement();
                        int gmshId = vertex.getId();
                        Integer penelopeNodeElementId = this.idMapper.getPenelopeVertexId(gmshId);
                        Vertex vertexById = this.mesh.getVertexById(penelopeNodeElementId.intValue());
                        for (int group : this.groups) {
                            MeshMask vertexMeshMask = this.mesh.getDataFieldManager().getVertexMeshMaskById(group);
                            if (vertexMeshMask == null) {
                                vertexMeshMask = new VertexMeshMask(group, this.mesh);
                                this.mesh.getDataFieldManager().addVertexMeshMask(vertexMeshMask);
                            }
                            vertexMeshMask.addMeshElementId(vertexById.getId());
                            dataFieldManager.addMeshMaskToVertexId(vertexMeshMask, vertexById.getId());
                        }
                        this.point15List.add(vertexById);
                        break;
                    }
                    case EDGE: {
                        Edge edge = (Edge)fileElement.getMeshElement();
                        penelopeId = this.mesh.addMeshElementAndClearConnectivity(edge);
                        if (this.storeOriginalIds) {
                            this.idMapper.addEdgeIdMapping(readId, penelopeId);
                        }
                        for (int group : this.groups) {
                            MeshMask edgeMeshMask = this.mesh.getDataFieldManager().getEdgeMeshMaskById(group);
                            if (edgeMeshMask == null) {
                                edgeMeshMask = new EdgeMeshMask(group, this.mesh);
                                this.mesh.getDataFieldManager().addEdgeMeshMask(edgeMeshMask);
                            }
                            edgeMeshMask.addMeshElementId(penelopeId);
                            dataFieldManager.addMeshMaskToEdgeId(edgeMeshMask, penelopeId);
                        }
                        break;
                    }
                    case FACE: {
                        Face face = (Face)fileElement.getMeshElement();
                        penelopeId = this.mesh.addMeshElementAndClearConnectivity(face);
                        if (this.storeOriginalIds) {
                            this.idMapper.addFaceIdMapping(readId, penelopeId);
                        }
                        for (int group : this.groups) {
                            MeshMask faceMeshMask = this.mesh.getDataFieldManager().getFaceMeshMaskById(group);
                            if (faceMeshMask == null) {
                                faceMeshMask = new FaceMeshMask(group, this.mesh);
                                this.mesh.getDataFieldManager().addFaceMeshMask(faceMeshMask);
                            }
                            faceMeshMask.addMeshElementId(penelopeId);
                            dataFieldManager.addMeshMaskToFaceId(faceMeshMask, penelopeId);
                        }
                        break;
                    }
                    case POLYHEDRON: {
                        Polyhedron polyhedron = (Polyhedron)fileElement.getMeshElement();
                        penelopeId = this.mesh.addMeshElementAndClearConnectivity(polyhedron);
                        if (this.storeOriginalIds) {
                            this.idMapper.addPolyhedronIdMapping(readId, penelopeId);
                        }
                        for (int group : this.groups) {
                            MeshMask polyhedronMeshMask = this.mesh.getDataFieldManager().getPolyhedronMeshMaskById(group);
                            if (polyhedronMeshMask == null) {
                                polyhedronMeshMask = new PolyhedronMeshMask(group, this.mesh);
                                this.mesh.getDataFieldManager().addPolyhedronMeshMask(polyhedronMeshMask);
                            }
                            polyhedronMeshMask.addMeshElementId(penelopeId);
                            dataFieldManager.addMeshMaskToPolyhedronId(polyhedronMeshMask, penelopeId);
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Read " + fileElement.isMeshElement() + " is not implmented");
                    }
                }
                if (fileElement.hasPhysicalTags()) {
                    // empty if block
                }
            }
            if (!fileElement.isPhysicalName()) continue;
            System.out.println("add group name " + fileElement.getPhysicalName().getName() + " with id " + fileElement.getPhysicalName().getId());
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            System.out.println("                Physicals are not yet implemented: use MeshGroups");
            System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
    }

    private boolean readNextLine() throws IOException {
        boolean returnValue;
        String currentLine = this.lineReader.readLine();
        while (currentLine != null && currentLine.trim().length() == 0) {
            currentLine = this.lineReader.readLine();
        }
        this.currentMeshFileEntity.initialize();
        if (currentLine == null) {
            this.currentMeshFileEntity.setFinalEntity();
            return true;
        }
        try {
            returnValue = this.treatLine(currentLine);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return returnValue;
    }

    public void addElementFilter(int elementType) {
        this.elementFilter.add(elementType);
    }

    public void removeElementFilter(int elementType) {
        this.elementFilter.remove(elementType);
    }

    public Set<Integer> getElementFilter() {
        return this.elementFilter;
    }

    protected boolean treatLine(String currentLine) throws FileFormatException {
        switch (this.currentFilePart) {
            case OUT_OF_SECTION: {
                for (GMSHFilePart22 filePart : GMSHFilePart22.values()) {
                    if (filePart.getStartTag() == null || filePart.getStartTag().compareToIgnoreCase(currentLine) != 0) continue;
                    this.currentFilePart = filePart;
                    this.sectionHeaderPart = 0;
                    return true;
                }
                break;
            }
            case HEADER_SECTION: {
                return this.treatHeaderSection(currentLine);
            }
            case NODE_SECTION: {
                return this.treatNodeSection(currentLine);
            }
            case ELEMENT_SECTION: {
                return this.treatElementSection(currentLine);
            }
            case PHYSICAL_NAME_SECTION: {
                return this.treatPhysicalNameSection(currentLine);
            }
            case NODE_DATA_SECTION: {
                return this.treatNodeDataSection(currentLine);
            }
            case ELEMENT_DATA_SECTION: {
                return this.treatElementDataSection(currentLine);
            }
        }
        return false;
    }

    private boolean treatElementDataSection(String currentLine) throws FileFormatException {
        String[] tokens;
        if (GMSHFilePart22.ELEMENT_DATA_SECTION.getEndTag().compareToIgnoreCase(currentLine) == 0) {
            this.elementData.add(this.currentElementDataSection);
            this.currentElementDataSection = null;
            this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
            return false;
        }
        if (this.currentElementDataSection == null) {
            this.currentElementDataSection = new GmshDataSection(GmshDataSection.GmshDataSectionType.ELEMENT);
            this.currentElementDataSection.readInit(this.idMapper);
        }
        for (String token : tokens = GmshMeshBuilder22.split(currentLine)) {
            if (token == null || this.currentElementDataSection.treatHeaderSectionToken(token, tokens.length)) continue;
            return false;
        }
        return true;
    }

    private boolean treatNodeDataSection(String currentLine) throws FileFormatException {
        String[] tokens;
        if (GMSHFilePart22.NODE_DATA_SECTION.getEndTag().compareToIgnoreCase(currentLine) == 0) {
            this.nodeData.add(this.currentNodeDataSection);
            this.currentNodeDataSection = null;
            this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
            return false;
        }
        if (this.currentNodeDataSection == null) {
            this.currentNodeDataSection = new GmshDataSection(GmshDataSection.GmshDataSectionType.NODE);
            this.currentNodeDataSection.readInit(this.idMapper);
        }
        for (String token : tokens = GmshMeshBuilder22.split(currentLine)) {
            if (token == null || this.currentNodeDataSection.treatHeaderSectionToken(token, tokens.length)) continue;
            return false;
        }
        return true;
    }

    private boolean treatPhysicalNameSection(String currentLine) throws FileFormatException {
        if (GMSHFilePart22.PHYSICAL_NAME_SECTION.getEndTag().compareToIgnoreCase(currentLine) == 0) {
            this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
            return false;
        }
        if (this.sectionHeaderPart == 0) {
            this.sectionHeaderPart = -1;
            int nbPhysical = Integer.parseInt(currentLine.trim());
            this.currentMeshFileEntity.setPhysicalNameCount(nbPhysical);
            return true;
        }
        this.parsePhysicalName(currentLine);
        return true;
    }

    private boolean treatElementSection(String currentLine) throws FileFormatException {
        if (GMSHFilePart22.ELEMENT_SECTION.getEndTag().compareToIgnoreCase(currentLine) == 0) {
            this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
            return false;
        }
        if (this.sectionHeaderPart == 0) {
            this.sectionHeaderPart = -1;
            int nbElement = Integer.parseInt(currentLine.trim());
            this.currentMeshFileEntity.setMeshElementCount(nbElement);
            return true;
        }
        this.parseMeshElement(currentLine);
        return true;
    }

    private boolean treatNodeSection(String currentLine) throws FileFormatException {
        if (GMSHFilePart22.NODE_SECTION.getEndTag().compareToIgnoreCase(currentLine) == 0) {
            this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
            return false;
        }
        if (this.sectionHeaderPart == 0) {
            this.sectionHeaderPart = -1;
            int nbNode = Integer.parseInt(currentLine.trim());
            this.currentMeshFileEntity.setNodeElementCount(nbNode);
            return true;
        }
        this.parseNodeElement(currentLine);
        return true;
    }

    private boolean treatHeaderSection(String currentLine) throws FileFormatException {
        if (GMSHFilePart22.HEADER_SECTION.getEndTag().compareToIgnoreCase(currentLine) == 0) {
            this.currentFilePart = GMSHFilePart22.OUT_OF_SECTION;
            return false;
        }
        String[] splitLine = GmshMeshBuilder22.split(currentLine);
        if (splitLine.length != 3) {
            throw new FileFormatException("invalid header line. 3 elements expected instead of " + splitLine.length + " line = " + currentLine);
        }
        if (!splitLine[0].startsWith("2")) {
            throw new FileFormatException("version " + splitLine[0] + " is not handled (2.XXX expected)");
        }
        if (splitLine[1].compareTo("0") != 0) {
            throw new FileFormatException("file type " + splitLine[1] + " is not handled (0 expected)");
        }
        if (splitLine[2].compareTo("8") != 0) {
            throw new FileFormatException("data size " + splitLine[2] + " is not handled (8 expected)");
        }
        return true;
    }

    private void parsePhysicalName(String line) throws FileFormatException {
        String[] splitLine = GmshMeshBuilder22.split(line);
        if (splitLine.length != 3) {
            throw new FileFormatException("invalid physical line " + line);
        }
        int id = Integer.parseInt(splitLine[1]);
        String name = splitLine[2].trim();
        PhysicalName physicalName = new PhysicalName(id, name);
        this.currentMeshFileEntity.setPhysicalName(physicalName);
    }

    private void parseMeshElement(String line) throws FileFormatException {
        int[] tags;
        int numberOfTags;
        int elementType;
        int elementId;
        String[] splitLine = GmshMeshBuilder22.split(line);
        if (splitLine.length < 3) {
            throw new FileFormatException("invalid node line #" + this.lineReader.getLineNumber() + " : '" + line + "'");
        }
        this.groups = new int[1];
        try {
            elementId = Integer.parseInt(splitLine[0]);
            elementType = Integer.parseInt(splitLine[1]);
            numberOfTags = Integer.parseInt(splitLine[2]);
            int firstTagIndex = 3;
            tags = new int[numberOfTags];
            for (int tagIndex = 0; tagIndex < numberOfTags; ++tagIndex) {
                tags[tagIndex] = Integer.parseInt(splitLine[3 + tagIndex]);
            }
        }
        catch (Exception e) {
            throw new FileFormatException((Throwable)e);
        }
        if (numberOfTags > 0) {
            this.groups[0] = tags[0];
        }
        this.currentMeshFileEntity.setPhysicalTags(this.groups);
        int firstNodeIndex = 3 + numberOfTags;
        Node currentMeshElement = null;
        switch (elementType) {
            case 1: {
                int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 0]));
                int nodeId2 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 1]));
                currentMeshElement = new Segment(elementId, this.mesh, this.mesh.getVertexById(nodeId1), this.mesh.getVertexById(nodeId2));
                break;
            }
            case 2: {
                int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 0]));
                int nodeId2 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 1]));
                int nodeId3 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 2]));
                currentMeshElement = new Triangle(elementId, this.mesh, this.mesh.getVertexById(nodeId1), this.mesh.getVertexById(nodeId2), this.mesh.getVertexById(nodeId3));
                break;
            }
            case 4: {
                int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 0]));
                int nodeId2 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 1]));
                int nodeId3 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 2]));
                int nodeId4 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 3]));
                currentMeshElement = new Tetrahedron(elementId, this.mesh, this.mesh.getVertexById(nodeId1), this.mesh.getVertexById(nodeId2), this.mesh.getVertexById(nodeId3), this.mesh.getVertexById(nodeId4));
                break;
            }
            case 15: {
                int nodeId1 = this.idMapper.getPenelopeVertexId(Integer.parseInt(splitLine[firstNodeIndex + 0]));
                Point point = this.mesh.getVertexById(nodeId1).getPoint();
                currentMeshElement = new Node(Integer.parseInt(splitLine[0]), this.mesh, point);
                break;
            }
            default: {
                throw new FileFormatException("Type of mesh element " + splitLine[1] + " not supported line #" + this.lineReader.getLineNumber());
            }
        }
        if (this.elementFilter.size() == 0 || this.elementFilter.contains(currentMeshElement.getMeshType())) {
            this.currentMeshFileEntity.setMeshElement((MeshElement)currentMeshElement);
        }
    }

    private void parseNodeElement(String line) throws FileFormatException {
        String[] splitLine = GmshMeshBuilder22.split(line);
        if (splitLine.length != 4 && splitLine.length != 5) {
            throw new FileFormatException("invalid node line " + line);
        }
        this.currentId = Integer.parseInt(splitLine[0]);
        Node currentNode = new Node(this.currentId, this.mesh, new double[]{Float.parseFloat(splitLine[1]), Float.parseFloat(splitLine[2]), Float.parseFloat(splitLine[3])});
        this.currentMeshFileEntity.setNodeElement((Vertex)currentNode);
    }

    private MeshFileEntity nextFileEntity() throws IOException {
        while (!this.readNextLine()) {
        }
        if (this.currentMeshFileEntity.isFinalNode()) {
            return null;
        }
        return this.currentMeshFileEntity;
    }

    protected static final String[] split(String lineToSplit) {
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern regex = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'");
        Matcher regexMatcher = regex.matcher(lineToSplit);
        while (regexMatcher.find()) {
            if (regexMatcher.group(1) != null) {
                matchList.add(regexMatcher.group(1));
                continue;
            }
            if (regexMatcher.group(2) != null) {
                matchList.add(regexMatcher.group(2));
                continue;
            }
            matchList.add(regexMatcher.group());
        }
        String[] tokens = new String[matchList.size()];
        for (int index = 0; index < matchList.size(); ++index) {
            tokens[index] = (String)matchList.get(index);
        }
        return tokens;
    }

    public List<GmshDataSection> getNodeDataSections() {
        return this.nodeData;
    }

    public List<GmshDataSection> getElementDataSections() {
        return this.elementData;
    }

    @Override
    public GeometryIdMapper getIdMapper() {
        return this.idMapper;
    }

    @Override
    public List<Vertex> getPoint15List() {
        return this.point15List;
    }

    public Mesh getMesh() {
        return this.mesh;
    }
}

