/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.probingline;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.probingline.ProbingLinePlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import vtk.vtkDataSet;

public class ProbingLineControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private ProbingLinePlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JFormattedTextField aX;
    private JFormattedTextField aY;
    private JFormattedTextField aZ;
    private JFormattedTextField bX;
    private JFormattedTextField bY;
    private JFormattedTextField bZ;
    private JFormattedTextField resolution;
    private JCheckBox viewPlot2D;
    private JRadioButton indexRBut;
    private JRadioButton xRBut;
    private JRadioButton yRBut;
    private JRadioButton zRBut;
    private JRadioButton sRBut;
    private JCheckBox widgetCheckBox;
    public final String UPDATE = "command.update";
    public final String EXPORT = "command.export";
    public final String CANCEL = "command.cancel";

    public ProbingLineControlUI(PipeLineManager pipeLineManager, ProbingLinePlugin plugin, Frame owner) {
        super(owner, "Probe configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), plugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener((ActionListener)((Object)this));
        line.add((Component)this.inputDataset, "Center");
        line.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(line);
        JPanel lineSettingPan = new JPanel();
        lineSettingPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Line settings"));
        lineSettingPan.setLayout(new BorderLayout());
        line = new JPanel(new GridLayout(3, 4));
        DecimalFormat format = new DecimalFormat("#.###");
        this.aX = new JFormattedTextField(format);
        this.aX.setValue(0.0);
        this.aY = new JFormattedTextField(format);
        this.aY.setValue(0.0);
        this.aZ = new JFormattedTextField(format);
        this.aZ.setValue(0.0);
        this.bX = new JFormattedTextField(format);
        this.bX.setValue(1.0);
        this.bY = new JFormattedTextField(format);
        this.bY.setValue(1.0);
        this.bZ = new JFormattedTextField(format);
        this.bZ.setValue(1.0);
        line.add(new JPanel());
        line.add(new JLabel("X", 0));
        line.add(new JLabel("Y", 0));
        line.add(new JLabel("Z", 0));
        line.add(new JLabel("A", 0));
        line.add(this.aX);
        line.add(this.aY);
        line.add(this.aZ);
        line.add(new JLabel("B", 0));
        line.add(this.bX);
        line.add(this.bY);
        line.add(this.bZ);
        lineSettingPan.add((Component)line, "Center");
        JPanel resolutionPan = new JPanel();
        resolutionPan.setLayout(new BoxLayout(resolutionPan, 2));
        resolutionPan.add(Box.createHorizontalGlue());
        resolutionPan.add(new JLabel("Resolution"));
        this.resolution = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.resolution.setValue(new Integer(256));
        resolutionPan.add(this.resolution);
        this.getContentPane().add(lineSettingPan);
        JPanel plotPanel = new JPanel();
        plotPanel.setLayout(new BoxLayout(plotPanel, 3));
        plotPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "2D Plot"));
        JPanel plotPan1 = new JPanel();
        plotPan1.setLayout(new BoxLayout(plotPan1, 2));
        this.viewPlot2D = new JCheckBox("View plot", true);
        plotPan1.add(this.viewPlot2D);
        plotPan1.add(Box.createHorizontalGlue());
        plotPanel.add(plotPan1);
        JPanel plotPane2 = new JPanel();
        plotPane2.setLayout(new BoxLayout(plotPane2, 2));
        ButtonGroup group = new ButtonGroup();
        this.indexRBut = new JRadioButton("index");
        plotPane2.add(this.indexRBut);
        group.add(this.indexRBut);
        this.xRBut = new JRadioButton("X");
        plotPane2.add(this.xRBut);
        group.add(this.xRBut);
        this.yRBut = new JRadioButton("Y");
        plotPane2.add(this.yRBut);
        group.add(this.yRBut);
        this.zRBut = new JRadioButton("Z");
        plotPane2.add(this.zRBut);
        group.add(this.zRBut);
        this.sRBut = new JRadioButton("S", true);
        plotPane2.add(this.sRBut);
        group.add(this.sRBut);
        plotPane2.add(Box.createHorizontalGlue());
        plotPanel.add(plotPane2);
        this.getContentPane().add(plotPanel);
        JPanel widgetLine = new JPanel();
        widgetLine.setLayout(new BoxLayout(widgetLine, 2));
        widgetLine.add(Box.createHorizontalGlue());
        this.widgetCheckBox = new JCheckBox("Active 3D widget");
        this.widgetCheckBox.addItemListener((ItemListener)((Object)this));
        widgetLine.add(this.widgetCheckBox);
        this.getContentPane().add(widgetLine);
        JPanel ctrLine = new JPanel();
        JButton export = new JButton("Export");
        export.setActionCommand("command.export");
        export.addActionListener((ActionListener)((Object)this));
        JButton update = new JButton("Update");
        update.setActionCommand("command.update");
        update.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("command.cancel");
        cancel.addActionListener((ActionListener)((Object)this));
        ctrLine.setLayout(new BoxLayout(ctrLine, 2));
        ctrLine.add(export);
        ctrLine.add(Box.createHorizontalGlue());
        ctrLine.add(update);
        ctrLine.add(cancel);
        this.getContentPane().add(Box.createVerticalGlue());
        this.getContentPane().add(ctrLine);
        this.pack();
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent e) {
        this.performAction(e.getActionCommand());
    }

    public void setSelectedInput(CassandraObject selectedInput) {
        if (selectedInput != null) {
            this.inputDataset.getModel().setSelectedItem(selectedInput);
        } else {
            System.out.println("Selection is null");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void performAction(String command) {
        double[] startPt = new double[]{((Number)this.aX.getValue()).doubleValue(), ((Number)this.aY.getValue()).doubleValue(), ((Number)this.aZ.getValue()).doubleValue()};
        double[] endPt = new double[]{((Number)this.bX.getValue()).doubleValue(), ((Number)this.bY.getValue()).doubleValue(), ((Number)this.bZ.getValue()).doubleValue()};
        int res = ((Number)this.resolution.getValue()).intValue();
        if (command.equals("command.update")) {
            if (this.inputDataset.getSelectedItem() == null) {
                JOptionPane.showMessageDialog(new JFrame(), "Please select a valid input dataset.", "Input Filter Selection Error", 0);
                return;
            }
            int plotType = -1;
            if (this.indexRBut.isSelected()) {
                plotType = 0;
            } else if (this.xRBut.isSelected()) {
                plotType = 1;
            } else if (this.yRBut.isSelected()) {
                plotType = 2;
            } else if (this.zRBut.isSelected()) {
                plotType = 3;
            } else if (this.sRBut.isSelected()) {
                plotType = 4;
            } else {
                System.out.println("Type not supported");
            }
            this.plugin.updateProbe((vtkDataSet)((CassandraObject)this.datasetModel.getSelectedItem()).getVtkObject(), startPt, endPt, res, this.viewPlot2D.isSelected(), plotType);
            this.pipeLineManager.validateViewAndGo();
            return;
        }
        if (command.equals("command.cancel")) {
            this.plugin.show3DWidget(false);
            this.dispose();
            return;
        }
        if (!command.equals("command.export")) return;
        this.plugin.export();
    }

    public void update3DWidgetStatus() {
        this.plugin.show3DWidget(this.widgetCheckBox.isSelected());
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.widgetCheckBox) {
            this.plugin.show3DWidget(this.widgetCheckBox.isSelected());
        } else {
            System.out.println("Item not found");
        }
    }

    public void setPoint1(double[] pt) {
        this.aX.setValue(pt[0]);
        this.aY.setValue(pt[1]);
        this.aZ.setValue(pt[2]);
    }

    public void setPoint1(double x, double y, double z) {
        this.aX.setValue(x);
        this.aY.setValue(y);
        this.aZ.setValue(z);
    }

    public void setPoint2(double[] pt) {
        this.bX.setValue(pt[0]);
        this.bY.setValue(pt[1]);
        this.bZ.setValue(pt[2]);
    }

    public void setPoint2(double x, double y, double z) {
        this.bX.setValue(x);
        this.bY.setValue(y);
        this.bZ.setValue(z);
    }

    public void stateChanged(ChangeEvent arg0) {
    }
}

