/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.graph;

import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import com.artenum.graph.interfaces.GraphModel;
import com.artenum.graph.interfaces.GraphViewListener;
import com.artenum.graph.listener.GroupDragListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.JPanel;

public class SimpleGraphPanel
extends JPanel
implements GraphViewListener,
MouseMotionListener,
MouseListener {
    protected GraphModel model;
    protected boolean groupSelection = false;
    protected GroupDragListener groupDragListener;
    protected Stroke selectionStroke = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f);
    private boolean startSelecting = false;
    private Point startingPoint;
    private Point currentPoint;
    private Rectangle rectangle;

    public SimpleGraphPanel(GraphModel graphModel) {
        super(null);
        this.model = graphModel;
        graphModel.addViewListener(this);
        this.groupDragListener = new GroupDragListener(graphModel, this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setGroupDragListener(GroupDragListener groupDragListener) {
        this.groupDragListener = groupDragListener;
        this.model.reload();
    }

    public GraphModel getGraphModel() {
        return this.model;
    }

    public boolean isGroupSelectionAllowed() {
        return this.groupSelection;
    }

    public void enableGroupSelection(boolean bl) {
        this.groupSelection = bl;
    }

    public void enableGroupDragging(boolean bl) {
        this.groupDragListener.setGroupDragEnable(bl);
    }

    public void setSelectionStroke(Stroke stroke) {
        this.selectionStroke = stroke;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Object[] objectArray = this.model.getConnections().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.drawConnection(graphics, (Connection)objectArray[i]);
        }
    }

    public void reload() {
        this.removeAll();
        Object[] objectArray = this.model.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            this.addCell((Cell)objectArray[i]);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Rectangle rectangle = componentArray[i].getBounds();
            double d3 = rectangle.getWidth() + rectangle.getLocation().getX();
            double d4 = rectangle.getHeight() + rectangle.getLocation().getY();
            if (d < d3) {
                d = d3;
            }
            if (!(d2 < d4)) continue;
            d2 = d4;
        }
        return new Dimension((int)d + 5, (int)d2 + 5);
    }

    protected void drawConnection(Graphics graphics, Connection connection) {
        Point point = connection.getSource().getConnectionPoint(connection);
        Point point2 = connection.getTarget().getConnectionPoint(connection);
        graphics.setColor(Color.BLACK);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void addCell(Cell cell) {
        Component component = cell.getUI();
        cell.addGroupDragListener(this.groupDragListener);
        this.add(component);
        component.setBounds(new Rectangle(component.getPreferredSize()));
        this.validate();
        this.repaint();
    }

    public void removeCell(Cell cell) {
        this.remove(cell.getUI());
        this.validate();
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.groupSelection) {
            return;
        }
        if (!this.startSelecting) {
            this.startingPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.currentPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
            this.rectangle = this.computeRectangle();
            this.drawRect(this.getForeground(), this.getBackground());
        }
        this.startSelecting = true;
        this.drawRect(this.getForeground(), this.getBackground());
        this.currentPoint = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.rectangle = this.computeRectangle();
        this.drawRect(this.getBackground(), this.getForeground());
        Iterator iterator = this.model.getCellList().iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            Rectangle rectangle = cell.getUI().getBounds();
            cell.setSelected(this.rectangle.contains(rectangle));
        }
    }

    private Rectangle computeRectangle() {
        int n = Math.min(this.startingPoint.x, this.currentPoint.x);
        int n2 = Math.min(this.startingPoint.y, this.currentPoint.y);
        int n3 = Math.abs(this.startingPoint.x - this.currentPoint.x);
        int n4 = Math.abs(this.startingPoint.y - this.currentPoint.y);
        return new Rectangle(n, n2, n3, n4);
    }

    private void drawRect(Color color, Color color2) {
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.setColor(color);
        graphics2D.setXORMode(color2);
        graphics2D.setStroke(this.selectionStroke);
        graphics2D.drawRect((int)this.rectangle.getX(), (int)this.rectangle.getY(), (int)this.rectangle.getWidth(), (int)this.rectangle.getHeight());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.startSelecting = false;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Iterator iterator = this.model.getCellList().iterator();
        while (iterator.hasNext()) {
            Cell cell = (Cell)iterator.next();
            cell.setSelected(false);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }
}

