/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;

public class PropertyLoader {
    public static void loadProperties(String fileToLoad) throws IOException, FileNotFoundException {
        PropertyLoader.loadProperties(new File(fileToLoad));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(File fileToLoad) throws IOException, FileNotFoundException {
        FileInputStream fis = null;
        Properties props = new Properties();
        try {
            fis = new FileInputStream(fileToLoad);
            props.load(fis);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            System.setProperty(key, props.getProperty(key));
        }
    }

    public static void validateProperties(HashMap<String, String> defaultPropMap) {
        for (String key : defaultPropMap.keySet()) {
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, defaultPropMap.get(key));
            System.out.println("Property unvalidated. Set to " + System.getProperty(key));
        }
    }
}

