/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.plugin.vtk.VtkDataSetBuilder;
import com.artenum.penelope.plugin.vtk.VtkGridBuilder;
import com.artenum.penelope.plugin.vtk.VtkToolBox;
import java.util.Iterator;
import vtk.vtkDataSet;
import vtk.vtkUnstructuredGrid;

public class EdgeVtkDataSetBuilder
implements VtkDataSetBuilder<Edge> {
    private VtkGridBuilder gridBuilder;

    @Override
    public vtkDataSet buildVtkDataSet(DataField<?, Edge> datafield, MeshType localisation) {
        vtkUnstructuredGrid edgeDataSet = this.buildVtkUnstructuredGrid(datafield, localisation);
        edgeDataSet.GetCellData().SetScalars(VtkToolBox.mapData(datafield));
        return edgeDataSet;
    }

    @Override
    public vtkUnstructuredGrid buildVtkUnstructuredGrid(DataField<?, Edge> datafield, MeshType localisation) {
        vtkUnstructuredGrid grid = null;
        if (localisation != MeshType.EDGE) {
            throw new UnsupportedOperationException("Unsupported visualisation location: " + localisation);
        }
        Iterator meshElementIterator = datafield.getMeshMask().getMeshElementIterator();
        this.gridBuilder = new VtkGridBuilder(datafield.getMeshMask().getMesh().getVertexIterator(), meshElementIterator, localisation);
        grid = this.gridBuilder.buildVtkUnstructuredGrid();
        return grid;
    }

    @Override
    public MeshType[] getAvailableVisualisationLocations() {
        return new MeshType[]{MeshType.EDGE};
    }

    @Override
    public VtkGridBuilder getGridBuilder() {
        return this.gridBuilder;
    }
}

