/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.isolevel;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.isolevel.IsoLevelPlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vtk.vtkDataSet;

public class IsoLevelControlUI
extends PlugInControlUI {
    private PipeLineManager pipeLineManager;
    private IsoLevelPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JFormattedTextField minRange;
    private JFormattedTextField maxRange;
    private JCheckBox computeNormal;
    private JTabbedPane levelType;
    private JSlider levelSlider;
    private JFormattedTextField levelValue;
    private JFormattedTextField nbLevel;

    public IsoLevelControlUI(PipeLineManager pipeLineManager, IsoLevelPlugin plugin, Frame owner) {
        super(owner, "Iso level configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = plugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), plugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel line = new JPanel(new BorderLayout());
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener((ActionListener)((Object)this));
        line.add((Component)this.inputDataset, "Center");
        line.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel(new GridLayout(2, 2));
        line.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Range"));
        this.minRange = new JFormattedTextField((Object)"0");
        this.minRange.setValue(new Double(-1.0));
        this.maxRange = new JFormattedTextField((Object)"0");
        this.maxRange.setValue(new Double(1.0));
        line.add(new JLabel("Min"));
        line.add(new JLabel("Max"));
        line.add(this.minRange);
        line.add(this.maxRange);
        this.getContentPane().add(line);
        JPanel simpleIsoLevel = new JPanel(new BorderLayout());
        this.levelValue = new JFormattedTextField((Object)"0");
        this.levelValue.setValue(new Double(0.0));
        Hashtable<Integer, JLabel> label = new Hashtable<Integer, JLabel>();
        label.put(new Integer(0), new JLabel("0%"));
        label.put(new Integer(50), new JLabel("50%"));
        label.put(new Integer(100), new JLabel("100%"));
        this.levelSlider = new JSlider(0, 100, 50);
        this.levelSlider.setMinorTickSpacing(1);
        this.levelSlider.setMajorTickSpacing(10);
        this.levelSlider.setLabelTable(label);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.addChangeListener((ChangeListener)((Object)this));
        this.levelSlider.setToolTipText("Move inside the range");
        simpleIsoLevel.add((Component)this.levelValue, "North");
        simpleIsoLevel.add((Component)this.levelSlider, "Center");
        JPanel multiIsoLevel = new JPanel();
        multiIsoLevel.setLayout(new BoxLayout(multiIsoLevel, 1));
        line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        this.nbLevel = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.nbLevel.setValue(new Integer(10));
        line.add(new JLabel("Nb levels : "));
        line.add(this.nbLevel);
        line.add(Box.createVerticalGlue());
        multiIsoLevel.add(line);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        this.levelType = new JTabbedPane();
        this.levelType.addTab("Simple iso-level", simpleIsoLevel);
        this.levelType.addTab("Multi iso-level", multiIsoLevel);
        this.getContentPane().add(this.levelType);
        line = new JPanel(new BorderLayout());
        line.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(line);
        line = new JPanel();
        this.computeNormal = new JCheckBox("Computes normals");
        JButton update = new JButton("Update");
        update.setActionCommand("UPDATE");
        update.addActionListener((ActionListener)((Object)this));
        JButton cancel = new JButton("Cancel");
        cancel.setActionCommand("CANCEL");
        cancel.addActionListener((ActionListener)((Object)this));
        line.setLayout(new BoxLayout(line, 2));
        line.add(this.computeNormal);
        line.add(Box.createHorizontalGlue());
        line.add(update);
        line.add(cancel);
        this.getContentPane().add(line);
        this.pack();
        Dimension d = this.getSize();
        this.setSize(d.width, d.height);
        this.setLocationRelativeTo(null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        int levelFlag = 0;
        if (command.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                levelFlag = this.levelType.getSelectedIndex();
                this.plugin.setControls(this.computeNormal.isSelected(), false);
                int nbLevelValue = ((Number)this.nbLevel.getValue()).intValue();
                double minValue = ((Number)this.minRange.getValue()).doubleValue();
                double maxValue = ((Number)this.maxRange.getValue()).doubleValue();
                this.plugin.updateIsoLevel((vtkDataSet)((CassandraObject)this.datasetModel.getSelectedItem()).getVtkObject(), this.updateLevelValue(), nbLevelValue, levelFlag, minValue, maxValue);
                this.pipeLineManager.validateViewAndGo();
                return;
            }
            JOptionPane.showMessageDialog(new JFrame(), "Please select a valid input dataset.", "Input Filter Selection Error", 0);
            return;
        }
        if (command.equals("CANCEL")) {
            this.dispose();
            return;
        }
        if (this.datasetModel.getSelectedItem() == null) return;
        double[] range = ((vtkDataSet)((CassandraObject)this.datasetModel.getSelectedItem()).getVtkObject()).GetScalarRange();
        if (range == null) return;
        this.minRange.setValue(new Double(range[0]));
        this.maxRange.setValue(new Double(range[1]));
    }

    public void stateChanged(ChangeEvent e) {
        double level = this.updateLevelValue();
        if (this.inputDataset.getSelectedItem() != null) {
            int nbLevelValue = ((Number)this.nbLevel.getValue()).intValue();
            double minValue = ((Number)this.minRange.getValue()).doubleValue();
            double maxValue = ((Number)this.maxRange.getValue()).doubleValue();
            this.plugin.updateIsoLevel((vtkDataSet)((CassandraObject)this.inputDataset.getSelectedItem()).getVtkObject(), level, 1, 0, minValue, maxValue);
            this.pipeLineManager.validateViewAndGo();
        }
    }

    public void setLevelType(int levelType) {
        if (levelType >= 0 && levelType < this.levelType.getTabCount()) {
            this.levelType.setSelectedIndex(levelType);
        } else {
            System.out.println("Error, index not found. Set to one unique leve by default");
            this.levelType.setSelectedIndex(0);
        }
    }

    private double updateLevelValue() {
        double value = this.levelSlider.getValue();
        double minValue = ((Number)this.minRange.getValue()).doubleValue();
        double maxValue = ((Number)this.maxRange.getValue()).doubleValue();
        double step = (maxValue - minValue) / 100.0;
        double result = value * step + minValue;
        this.levelValue.setValue(new Double(result));
        return result;
    }

    public void itemStateChanged(ItemEvent arg0) {
    }

    public void setSelectedInput(CassandraObject selectedInput) {
        if (selectedInput != null) {
            this.inputDataset.getModel().setSelectedItem(selectedInput);
        } else {
            System.out.println("Selection is null");
        }
    }
}

