/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.isolevel;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.SimplePlugInProperty;
import com.artenum.cassandra.plugin.isolevel.IsoLevelControlUI;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkObject;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class IsoLevelPlugin
implements CassandraPlugin,
RemoveListener {
    private String name;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private IsoLevelControlUI controlUI;
    private int nbUpdate = 0;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkPlane plane;
    private vtkCutter planeCut;
    private vtkPolyDataMapper isoLevelMapper;
    private vtkActor isoLevelActor;
    private vtkContourFilter contour;
    private vtkPolyDataNormals normals;
    private vtkAssembly assembly;
    private CassandraObject outputCassActor;
    private CassandraObject outputCassMapper;
    private CassandraObject outputCassDataset;
    private CassandraObject outputCassDatasetN;
    private CassandraObject outputCassLookupTable;
    private CassandraObject outputCassScalarBar;
    private CassandraObject cassFilter;
    private Filter filterImpl;
    private boolean normalFlag;
    private Point cellPosition;
    private double minValue;
    private double maxValue;
    public static final String PERSISTENCE_KEY_INPUT_DATASET = "persistence.key.inputVtkDataSet";
    public static final String PERSISTENCE_KEY_INOUT = "persistence.key.insideOut";
    public static final String PERSISTENCE_KEY_OUPUT_DATASET = "persistence.key.outputDataSet";
    public static final String PERSISTENCE_KEY_OUPUT_MAPPER = "persistence.key.outputMapper";
    public static final String PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE = "persistence.key.outputlookUpTable";
    public static final String PERSISTENCE_KEY_OUTPUT_ACTOR = "persistence.key.outputActor";
    public static final String PERSISTENCE_KEY_OUTPUT_SCALAR_BAR = "persistence.key.ouputScalarBar";
    public static final String PERSISTENCE_KEY_CELL_POS_X = "persistence.key.cell.PosX";
    public static final String PERSISTENCE_KEY_CELL_POS_Y = "persistence.key.cell.PosY";
    public static final String PERSISTENCE_KEY_LEVEL_VALUE = "persistence.key.level.value";
    public static final String PERSISTENCE_KEY_LEVEL_FLAG = "persistence.key.level.flag";
    public static final String PERSISTENCE_KEY_LEVEL_NUMBER = "persistence.key.level.number";
    public static final String PERSISTENCE_KEY_LEVEL_MIN = "persistence.key.level.min";
    public static final String PERSISTENCE_KEY_LEVEL_MAX = "persistence.key.level.max";

    public IsoLevelPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        this.initPipeline();
    }

    public IsoLevelPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, boolean initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline) {
            this.initPipeline();
        }
    }

    public IsoLevelPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, int initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline == 1) {
            this.initPipeline();
        }
    }

    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.name = "Iso level";
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.filterImpl.setParentPlugin((CassandraPlugin)this);
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new IsoLevelControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Iso level menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsoLevelPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IsoLevelPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
    }

    public void initPipeline() {
        if (this.contour == null) {
            this.contour = new vtkContourFilter();
            this.outputCassDataset = this.pipelineManager.addDataSet((Object)this.contour.GetOutput(), "Contour");
        } else {
            this.outputCassDataset = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.contour.GetOutput());
        }
        this.contour.SetValue(0, 0.1);
        this.normals = new vtkPolyDataNormals();
        this.normals.SetInput((vtkDataObject)this.contour.GetOutput());
        this.normals.SetFeatureAngle(45.0);
        if (this.isoLevelMapper == null) {
            this.isoLevelMapper = new vtkPolyDataMapper();
            this.outputCassMapper = this.pipelineManager.addMapper((Object)this.isoLevelMapper, "IsoLevel");
        } else {
            this.outputCassMapper = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.isoLevelMapper);
        }
        this.isoLevelMapper.ScalarVisibilityOn();
        this.isoLevelMapper.ColorByArrayComponent("Magnitude", 0);
        if (this.isoLevelActor == null) {
            this.isoLevelActor = new vtkActor();
            this.outputCassActor = this.pipelineManager.addActor((Object)this.isoLevelActor, "IsoLevel");
        } else {
            this.outputCassActor = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.isoLevelActor);
        }
        this.isoLevelActor.SetMapper((vtkMapper)this.isoLevelMapper);
        this.filterImpl.getOutputDataSet().add(this.contour.GetOutput());
        this.filterImpl.getOutputDataSet().add(this.normals.GetOutput());
        this.filterImpl.addRemoveListener((RemoveListener)this);
        if (this.lookupTable == null) {
            this.lookupTable = new vtkLookupTable();
            this.outputCassLookupTable = this.pipelineManager.addLookupTable(this.lookupTable, "IsoLevel");
        } else {
            this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.lookupTable);
        }
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.isoLevelMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        if (this.scalarBar == null) {
            this.scalarBar = new vtkScalarBarActor();
            this.outputCassScalarBar = this.pipelineManager.addScalarBar(this.scalarBar, "Iso Level");
        } else {
            this.outputCassScalarBar = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.scalarBar);
        }
        this.scalarBar.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.pipelineManager.setActorVisible(this.outputCassScalarBar, true);
        this.outputCassDatasetN = this.normals.GetOutput() == null ? this.pipelineManager.addDataSet((Object)this.normals.GetOutput(), "Normal") : this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.normals.GetOutput());
        this.cassFilter = this.pipelineManager.addFilter(this.filterImpl, "IsoLevel");
        this.cassFilter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.outputCassActor.setValide(false);
    }

    @Deprecated
    public void setInternalPipelineComponents(vtkContourFilter contour, vtkDataSetMapper cutMapper, vtkActor cutActor) {
        this.contour = contour;
    }

    public void updateIsoLevel(vtkDataSet vtkDataSet2, double level, int nbLevel, int levelFlag, double min, double max) {
        if (vtkDataSet2 == null) {
            System.out.println("Error input data set null");
            return;
        }
        this.minValue = min;
        this.maxValue = max;
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.isoLevelMapper.GetLookupTable());
        this.lookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.scalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.pipelineManager.notifyConnectivityChange(this.outputCassDataset);
        this.cellPosition = ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).getPosition();
        this.outputCassActor.setValide(true);
        this.contour.SetInput((vtkDataObject)vtkDataSet2);
        this.setNormal(this.normalFlag);
        this.contour.ComputeScalarsOn();
        this.isoLevelMapper.ColorByArrayComponent("Magnitude", 0);
        if (levelFlag == 0) {
            this.contour.SetNumberOfContours(1);
            this.contour.SetValue(0, level);
        } else {
            this.contour.GenerateValues(nbLevel, min, max);
        }
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.isoLevelMapper.GetLookupTable().equals(this.lookupTable)) {
            this.isoLevelMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.outputCassActor)) {
            this.pipelineManager.setActorVisible(this.outputCassActor, true);
        }
        this.pipelineManager.hideInputActor(this.outputCassActor, vtkDataSet2);
        this.pipelineManager.notifyConnectivityChange(this.outputCassDataset);
    }

    public void setControls(boolean normalFlagIn, boolean scalarFlag) {
        this.normalFlag = normalFlagIn;
    }

    private void setNormal(boolean normalFlag) {
        if (normalFlag) {
            if (this.normals.GetOutput() != null) {
                this.isoLevelMapper.SetInput(this.normals.GetOutput());
            } else {
                System.out.println("No data to generate normals for!");
                this.isoLevelMapper.SetInput(this.contour.GetOutput());
            }
        } else {
            this.isoLevelMapper.SetInput(this.contour.GetOutput());
        }
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.outputCassActor);
        this.pipelineManager.removeVtkObject(this.outputCassMapper);
        this.pipelineManager.removeVtkObject(this.outputCassDataset);
        this.pipelineManager.removeVtkObject(this.cassFilter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public CassandraObject getOutputDataSet() {
        return this.outputCassDataset;
    }

    public CassandraObject getActor() {
        return this.outputCassActor;
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.isoLevelMapper.GetLookupTable());
        this.lookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.scalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        SimplePlugInProperty prop = new SimplePlugInProperty();
        prop.put((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.contour.GetInput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_DATASET, (Object)this.contour.GetOutput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_MAPPER, (Object)this.isoLevelMapper);
        prop.put((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, (Object)this.lookupTable);
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, (Object)this.isoLevelActor);
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, (Object)this.scalarBar);
        this.cellPosition = ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).getPosition();
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_X, (Object)this.cellPosition.x);
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_Y, (Object)this.cellPosition.y);
        if (this.contour.GetNumberOfContours() > 1) {
            prop.put((Object)PERSISTENCE_KEY_LEVEL_FLAG, (Object)1);
            prop.put((Object)PERSISTENCE_KEY_LEVEL_NUMBER, (Object)this.contour.GetNumberOfContours());
        } else {
            prop.put((Object)PERSISTENCE_KEY_LEVEL_FLAG, (Object)0);
            prop.put((Object)PERSISTENCE_KEY_LEVEL_NUMBER, (Object)1);
        }
        prop.put((Object)PERSISTENCE_KEY_LEVEL_MIN, (Object)this.minValue);
        prop.put((Object)PERSISTENCE_KEY_LEVEL_MAX, (Object)this.maxValue);
        return prop;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
        this.contour = new vtkContourFilter();
        this.contour.SetOutput((vtkDataObject)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_DATASET, null));
        vtkDataSet tmpInputDataSet = (vtkDataSet)prop.getSafely((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.contour.GetInput());
        this.lookupTable = (vtkLookupTable)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, null);
        this.isoLevelMapper = (vtkPolyDataMapper)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_MAPPER, null);
        this.isoLevelActor = (vtkActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, null);
        this.scalarBar = (vtkScalarBarActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, null);
        this.minValue = prop.getSafely((Object)PERSISTENCE_KEY_LEVEL_MIN, -10.0);
        this.maxValue = prop.getSafely((Object)PERSISTENCE_KEY_LEVEL_MIN, 10.0);
        int localLevelFlag = prop.getSafely((Object)PERSISTENCE_KEY_LEVEL_FLAG, 0);
        int localNbLevel = prop.getSafely((Object)PERSISTENCE_KEY_LEVEL_NUMBER, 1);
        int localLevel = prop.getSafely((Object)PERSISTENCE_KEY_LEVEL_VALUE, 1);
        this.initPipeline();
        this.controlUI.setSelectedInput(this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)tmpInputDataSet));
        this.controlUI.setLevelType(localLevelFlag);
        this.updateIsoLevel(tmpInputDataSet, localLevel, localNbLevel, localLevelFlag, this.minValue, this.maxValue);
        int cellPosX = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_X, -1);
        int cellPosY = prop.getSafely((Object)PERSISTENCE_KEY_CELL_POS_Y, -1);
        if (cellPosX > 0 && cellPosY > 0) {
            ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).setPosition(new Point(cellPosX, cellPosY));
        }
    }
}

