/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.info2d;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.info2d.Info2DControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor2D;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkLabeledDataMapper;
import vtk.vtkMapper2D;

public class Infos2DPlugin
implements CassandraPlugin,
RemoveListener {
    public static final int SHOW_ID = 0;
    public static final int SHOW_DATA_FIELD = 1;
    public static final int SHOW_NORMAL = 2;
    public static final int SHOW_SCALAR = 3;
    public static final int SHOW_TCOORD = 4;
    public static final int SHOW_TENSOR = 5;
    public static final int SHOW_VECTOR = 6;
    private String name = "Info2D";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private Info2DControlUI controlUI;
    private int nbUpdate = 0;
    private vtkDataSet datasetVTK;
    private vtkLabeledDataMapper mapperVTK;
    private vtkActor2D actorVTK;
    private CassandraObject actor;
    private CassandraObject mapper;
    private CassandraObject filter;
    private Filter filterImpl = new FilterImpl();

    public Infos2DPlugin() {
    }

    public Infos2DPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this();
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new Info2DControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("2D Info menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos2DPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Infos2DPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
        this.mapperVTK = new vtkLabeledDataMapper();
        this.mapperVTK.SetLabelFormat("%g");
        this.actorVTK = new vtkActor2D();
        this.actorVTK.SetMapper((vtkMapper2D)this.mapperVTK);
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.filterImpl.getOutputActor().add(this.actorVTK);
        this.actor = pipelineManager.addActor((Object)this.actorVTK, "Info 2D");
        this.filter = pipelineManager.addFilter(this.filterImpl, "Info 2D");
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateInfo2D(vtkDataSet inputDataSet, int option) {
        if (inputDataSet != null) {
            this.filterImpl.getInputDataSet().clear();
            this.filterImpl.getInputDataSet().add(inputDataSet);
            if (this.datasetVTK == null || !this.datasetVTK.equals(inputDataSet)) {
                this.datasetVTK = inputDataSet;
                this.mapperVTK.SetInput((vtkDataObject)this.datasetVTK);
            }
            switch (option) {
                case 0: {
                    this.mapperVTK.SetLabelModeToLabelIds();
                    break;
                }
                case 1: {
                    this.mapperVTK.SetLabelModeToLabelFieldData();
                    break;
                }
                case 2: {
                    this.mapperVTK.SetLabelModeToLabelNormals();
                    break;
                }
                case 3: {
                    this.mapperVTK.SetLabelModeToLabelScalars();
                    break;
                }
                case 4: {
                    this.mapperVTK.SetLabelModeToLabelTCoords();
                    break;
                }
                case 5: {
                    this.mapperVTK.SetLabelModeToLabelTensors();
                    break;
                }
                case 6: {
                    this.mapperVTK.SetLabelModeToLabelVectors();
                }
            }
            if (this.mapperVTK.GetInput().equals(this.datasetVTK) && this.pipelineManager.getActorList().getData().contains(this.actor)) {
                this.actor.setValide(true);
                this.pipelineManager.setActorVisible(this.actor, true);
            }
            this.pipelineManager.notifyConnectivityChange(this.filter);
        }
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.filter);
        this.pluginManager.removePlugin((CassandraPlugin)this);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        return null;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
    }
}

