/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import java.awt.Color;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;

public class Prompt
extends JPanel
implements ComponentListener {
    private static final String l1 = "&gt;&gt;&gt; ";
    private static final String ln = "<br>... ";
    private JTextPane txtCmd;
    private JLabel label;

    public Prompt(JTextPane jTextPane) {
        this.setOpaque(true);
        this.label = new JLabel();
        this.label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.showNLines(1);
        this.txtCmd = jTextPane;
        jTextPane.addComponentListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.label);
        this.add(Box.createVerticalGlue());
    }

    public void showNLines(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(l1);
        while (n-- > 1) {
            stringBuffer.append(ln);
        }
        stringBuffer.append("</html>");
        this.label.setText(stringBuffer.toString());
    }

    public void setColor(Color color, Color color2) {
        this.setBackground(color2);
        this.label.setForeground(color);
    }

    public void updateLineView() {
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(this.txtCmd.getText()));
        try {
            while (lineNumberReader.readLine() != null) {
            }
            this.showNLines(lineNumberReader.getLineNumber() + 1);
            lineNumberReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.updateLineView();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.updateLineView();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.updateLineView();
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.updateLineView();
    }
}

