/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.field.data;

import com.artenum.penelope.field.data.AbstractDataArray;
import com.artenum.penelope.field.data.DataType;
import java.util.Arrays;

public class TupleOfDoubleDataArray
extends AbstractDataArray<double[]> {
    private final double[][] tupleArray;
    private int dim = 1;

    public TupleOfDoubleDataArray(int dim) {
        this.nbData = 0;
        this.dim = dim;
        this.tupleArray = new double[dim][40960];
    }

    public TupleOfDoubleDataArray(int dim, int size) {
        this.nbData = 0;
        this.dim = dim;
        this.tupleArray = new double[dim][size];
    }

    public TupleOfDoubleDataArray(double[][] tupleArray) {
        this.tupleArray = tupleArray;
        this.dim = tupleArray.length;
        this.nbData = tupleArray[0] != null ? tupleArray[0].length : 0;
    }

    @Override
    public int getDataDimension() {
        return this.dim;
    }

    @Override
    public void set(int index, double[] tuple) {
        for (int col = 0; col < this.dim; ++col) {
            this.tupleArray[col][index] = tuple[col];
        }
        if (index > this.currentLastIndex) {
            this.currentLastIndex = index;
        }
    }

    @Override
    public double[] get(int index) {
        double[] tuple = new double[this.dim];
        for (int col = 0; col < tuple.length; ++col) {
            tuple[col] = this.tupleArray[col][index];
        }
        return tuple;
    }

    @Override
    public void add(double[] tuple) {
        if (this.currentLastIndex > this.tupleArray[0].length - 1) {
            this.extendArraySize(this.tupleArray[0].length + 40960);
        }
        for (int col = 0; col < this.dim; ++col) {
            this.tupleArray[col][this.currentLastIndex] = tuple[col];
        }
        ++this.currentLastIndex;
        ++this.nbData;
    }

    @Override
    public void extendArraySize(int newSize) {
        for (int col = 0; col < this.dim; ++col) {
            double[] newArray = new double[newSize];
            System.arraycopy(this.tupleArray[col], 0, newArray, 0, this.tupleArray[col].length);
            this.tupleArray[col] = newArray;
        }
    }

    @Override
    public void packArray() {
        for (int col = 0; col < this.dim; ++col) {
            double[] newArray = new double[this.nbData];
            System.arraycopy(this.tupleArray[col], 0, newArray, 0, this.nbData);
            this.tupleArray[col] = newArray;
        }
    }

    @Override
    public int getArraySize() {
        return this.tupleArray.length;
    }

    @Override
    public int getNbData() {
        return this.nbData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.dim;
        result = 31 * result + Arrays.hashCode((Object[])this.tupleArray);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleOfDoubleDataArray other = (TupleOfDoubleDataArray)obj;
        if (this.dim != other.dim) {
            return false;
        }
        return Arrays.equals((Object[])this.tupleArray, (Object[])other.tupleArray);
    }

    @Override
    public DataType getDataType() {
        return DataType.DOUBLE;
    }
}

