/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.mesh.BoundingBox;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.iterator.SingleEdgeIteratorFromVertexIds;
import com.artenum.penelope.mesh.iterator.SingleEdgeIteratorOnMesh;
import com.artenum.penelope.mesh.iterator.SingleFaceIteratorFromVertexIds;
import com.artenum.penelope.mesh.iterator.SingleFaceIteratorOnMesh;
import com.artenum.penelope.mesh.iterator.SinglePolyhedronIteratorFromVertexIds;
import com.artenum.penelope.mesh.util.EdgeIdentifier;
import com.artenum.penelope.mesh.util.FaceIdentifier;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UnstructuredMesh
implements Mesh {
    private static final long serialVersionUID = -7971305851085116515L;
    private String name;
    private final List<Polyhedron> polyhedronList = new ArrayList<Polyhedron>();
    private final Map<Integer, Face> faceMap = new HashMap<Integer, Face>();
    private final Map<Integer, Edge> edgeMap = new HashMap<Integer, Edge>();
    private final List<Vertex> vertexList = new ArrayList<Vertex>();
    private int nbEdges = 0;
    private int nbFaces = 0;
    private final Map<Integer, Face> cachedFaceMap;
    private final Map<Integer, Edge> cachedEdgeMap;
    private boolean cachingEnabled = false;
    private final BoundingBox boundingBox;
    private EdgeIdentifier edgeIdGenerator = new EdgeIdentifier(0);
    private FaceIdentifier faceIdGenerator = new FaceIdentifier(0);
    private Map<Vertex, TIntArrayList> edgeIdsOnVertex = new HashMap<Vertex, TIntArrayList>();
    private TIntObjectHashMap<TIntArrayList> faceIdsOnEdgeId = new TIntObjectHashMap();
    private TIntObjectHashMap<List<Polyhedron>> polyhedraOnFaceId = new TIntObjectHashMap();
    private final DataFieldManager dataFieldManager;
    private final HashMap<String, Long> memoryCostInfo;

    public UnstructuredMesh() {
        this.cachedFaceMap = new HashMap<Integer, Face>();
        this.cachedEdgeMap = new HashMap<Integer, Edge>();
        this.dataFieldManager = new DataFieldManager();
        this.memoryCostInfo = new HashMap();
        this.boundingBox = new BoundingBox();
    }

    @Override
    public int getMeshDimension() {
        int meshDimension = 0;
        if (!this.polyhedronList.isEmpty()) {
            meshDimension = 3;
        } else if (!this.faceMap.isEmpty()) {
            meshDimension = 2;
        } else if (!this.edgeMap.isEmpty()) {
            meshDimension = 1;
        }
        return meshDimension;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String nameToSet) {
        this.name = nameToSet;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Mesh [name=");
        builder.append(this.name);
        builder.append(", nbVertices=");
        builder.append(this.getNbVertices());
        builder.append(", nbEdges=");
        builder.append(this.nbEdges);
        builder.append(", nbFaces=");
        builder.append(this.nbFaces);
        builder.append(", nbPolyhedra=");
        builder.append(this.polyhedronList.size());
        builder.append(", meshDimension=");
        builder.append(this.getMeshDimension());
        builder.append("]");
        return builder.toString();
    }

    @Override
    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    @Override
    public int getSpaceDimension() {
        if (this.vertexList.isEmpty()) {
            return -1;
        }
        return this.vertexList.get(0).getPoint().getSpaceDimension();
    }

    @Override
    public Map<String, Long> getMemoryCostInfo() {
        return this.memoryCostInfo;
    }

    private int addMeshElement(Polyhedron polyhedronToAdd) {
        polyhedronToAdd.setId(this.polyhedronList.size());
        this.polyhedronList.add(polyhedronToAdd);
        this.expandBoundingBox(polyhedronToAdd);
        return polyhedronToAdd.getId();
    }

    private int addMeshElement(Face faceToAdd) {
        int id = this.faceIdGenerator.getFaceId(faceToAdd.getVertices());
        faceToAdd.setId(id);
        this.faceMap.put(faceToAdd.getId(), faceToAdd);
        this.expandBoundingBox(faceToAdd);
        return faceToAdd.getId();
    }

    private int addMeshElement(Edge edgeToAdd) {
        int id = this.edgeIdGenerator.getEdgeId(edgeToAdd.getVertices());
        edgeToAdd.setId(id);
        this.edgeMap.put(edgeToAdd.getId(), edgeToAdd);
        this.expandBoundingBox(edgeToAdd);
        return edgeToAdd.getId();
    }

    private int addMeshElement(Vertex vertexToAdd) {
        vertexToAdd.setId(this.vertexList.size());
        this.vertexList.add(vertexToAdd);
        this.boundingBox.addPoint(vertexToAdd.getPoint());
        return vertexToAdd.getId();
    }

    @Override
    public int addMeshElementAndClearConnectivity(Polyhedron polyhedronToAdd) {
        int answer = this.addMeshElement(polyhedronToAdd);
        this.invalidateConnectivity();
        return answer;
    }

    @Override
    public int addMeshElementAndClearConnectivity(Face faceToAdd) {
        int answer = this.addMeshElement(faceToAdd);
        this.invalidateConnectivity();
        return answer;
    }

    @Override
    public int addMeshElementAndClearConnectivity(Edge edgeToAdd) {
        int answer = this.addMeshElement(edgeToAdd);
        this.invalidateConnectivity();
        return answer;
    }

    @Override
    public int addMeshElementAndClearConnectivity(Vertex vertexToAdd) {
        int answer = this.addMeshElement(vertexToAdd);
        this.invalidateConnectivity();
        return answer;
    }

    @Override
    public int addMeshElementAndUpdateConnectivity(Polyhedron polyhedronToAdd) {
        int answer = this.addMeshElement(polyhedronToAdd);
        Face firstFaceOnPolyhedron = polyhedronToAdd.getFaceAt(0);
        Face secondFaceOnPolyhedron = polyhedronToAdd.getFaceAt(1);
        Face thirdFaceOnPolyhedron = polyhedronToAdd.getFaceAt(2);
        Face fourthFaceOnPolyhedron = polyhedronToAdd.getFaceAt(3);
        this.updateBottomUpConnectivityOnPolyhedron(polyhedronToAdd, firstFaceOnPolyhedron);
        this.updateBottomUpConnectivityOnPolyhedron(polyhedronToAdd, secondFaceOnPolyhedron);
        this.updateBottomUpConnectivityOnPolyhedron(polyhedronToAdd, thirdFaceOnPolyhedron);
        this.updateBottomUpConnectivityOnPolyhedron(polyhedronToAdd, fourthFaceOnPolyhedron);
        return answer;
    }

    private void updateBottomUpConnectivityOnPolyhedron(Polyhedron polyhedronToAdd, Face faceOnPolyhedron) {
        List<Polyhedron> polyhedronOnFace = this.polyhedraOnFaceId.get(faceOnPolyhedron.getId());
        if (polyhedronOnFace == null) {
            polyhedronOnFace = new ArrayList<Polyhedron>();
            polyhedronOnFace.add(polyhedronToAdd);
            this.polyhedraOnFaceId.put(faceOnPolyhedron.getId(), polyhedronOnFace);
        } else {
            polyhedronOnFace.add(polyhedronToAdd);
        }
    }

    @Override
    public int addMeshElementAndUpdateConnectivity(Face faceToAdd) {
        int answer = this.addMeshElement(faceToAdd);
        Edge firstEdgeOnFace = faceToAdd.getEdgeAt(0);
        Edge secondEdgeOnFace = faceToAdd.getEdgeAt(1);
        Edge thirdEdgeOnFace = faceToAdd.getEdgeAt(2);
        this.updateBottomUpConnectivityOnFace(faceToAdd, firstEdgeOnFace);
        this.updateBottomUpConnectivityOnFace(faceToAdd, secondEdgeOnFace);
        this.updateBottomUpConnectivityOnFace(faceToAdd, thirdEdgeOnFace);
        return answer;
    }

    private void updateBottomUpConnectivityOnFace(Face faceToAdd, Edge edgeOnFace) {
        TIntArrayList faceIdsOnEdge = this.faceIdsOnEdgeId.get(edgeOnFace.getId());
        if (faceIdsOnEdge == null) {
            faceIdsOnEdge = new TIntArrayList();
            faceIdsOnEdge.add(faceToAdd.getId());
            this.faceIdsOnEdgeId.put(edgeOnFace.getId(), faceIdsOnEdge);
        } else {
            faceIdsOnEdge.add(faceToAdd.getId());
        }
    }

    @Override
    public int addMeshElementAndUpdateConnectivity(Edge edgeToAdd) {
        int answer = this.addMeshElement(edgeToAdd);
        Vertex startVertex = edgeToAdd.getVertexAt(0);
        Vertex endVertex = edgeToAdd.getVertexAt(1);
        this.updateBottomUpConnectivityOnEdge(edgeToAdd, startVertex);
        this.updateBottomUpConnectivityOnEdge(edgeToAdd, endVertex);
        return answer;
    }

    private void updateBottomUpConnectivityOnEdge(Edge edgeToAdd, Vertex vertexOnEdge) {
        TIntArrayList edgeIdsOnVertexOnEdge = this.edgeIdsOnVertex.get(vertexOnEdge);
        if (edgeIdsOnVertexOnEdge == null) {
            edgeIdsOnVertexOnEdge = new TIntArrayList();
            edgeIdsOnVertexOnEdge.add(edgeToAdd.getId());
            this.edgeIdsOnVertex.put(vertexOnEdge, edgeIdsOnVertexOnEdge);
        } else {
            edgeIdsOnVertexOnEdge.add(edgeToAdd.getId());
        }
    }

    @Override
    public int addMeshElementAndUpdateConnectivity(Vertex vertexToAdd) {
        return this.addMeshElement(vertexToAdd);
    }

    @Override
    public void finalizeMesh() {
        this.nbEdges = this.updateEdgeIds();
        this.nbFaces = this.updateFaceIds();
        this.computeConnectivity();
    }

    @Override
    public void clearIdentifiers() {
        this.edgeIdGenerator = null;
        this.faceIdGenerator = null;
    }

    @Override
    public void invalidateConnectivity() {
        this.edgeIdsOnVertex.clear();
        this.faceIdsOnEdgeId.clear();
        this.polyhedraOnFaceId.clear();
    }

    @Override
    public Map<Vertex, TIntArrayList> getEdgeIdsOnVertex() {
        return this.edgeIdsOnVertex;
    }

    @Override
    public TIntObjectHashMap<TIntArrayList> getFaceIdsOnEdgeId() {
        return this.faceIdsOnEdgeId;
    }

    @Override
    public TIntObjectHashMap<List<Polyhedron>> getPolyhedraOnFaceId() {
        return this.polyhedraOnFaceId;
    }

    @Override
    public boolean isCachingEnabled() {
        return this.cachingEnabled;
    }

    @Override
    public void setCachingEnabled(boolean enableCaching) {
        this.cachingEnabled = enableCaching;
        if (!this.cachingEnabled) {
            this.clearCache();
        }
    }

    @Override
    public void clearCache() {
        this.cachedEdgeMap.clear();
        this.cachedFaceMap.clear();
    }

    @Override
    public List<Vertex> getVertices() {
        return this.vertexList;
    }

    @Override
    public int getNbVertices() {
        return this.vertexList.size();
    }

    @Override
    public Vertex getVertexById(int vertexId) {
        return this.vertexList.get(vertexId);
    }

    @Override
    public Vertex[] getVerticesByIds(int[] ids) {
        Vertex[] vertexArray = new Vertex[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            vertexArray[i] = this.getVertexById(ids[i]);
        }
        return vertexArray;
    }

    @Override
    public Iterator<Vertex> getVertexIterator() {
        return this.vertexList.iterator();
    }

    @Override
    public Vertex[] getVerticesFromEdgeId(int edgeId) {
        Vertex[] answer;
        Edge edge = this.edgeMap.get(edgeId);
        if (edge == null) {
            edge = this.cachedEdgeMap.get(edgeId);
            if (edge == null) {
                TIntArrayList faceIdsList = this.faceIdsOnEdgeId.get(edgeId);
                Integer faceId = faceIdsList.get(0);
                List<Polyhedron> polyhedraOnFace = this.polyhedraOnFaceId.get(faceId);
                Polyhedron polyhedron = polyhedraOnFace.get(0);
                int edgePosition = polyhedron.getEdgePosition(edgeId);
                answer = polyhedron.getVerticesOnEdgeAt(edgePosition);
            } else {
                answer = edge.getVertices();
            }
        } else {
            answer = edge.getVertices();
        }
        return answer;
    }

    @Override
    public Vertex[] getVerticesFromFaceId(int faceId) {
        Vertex[] answer;
        Face face = this.faceMap.get(faceId);
        if (face == null) {
            face = this.cachedFaceMap.get(faceId);
            if (face == null) {
                List<Polyhedron> polyhedraOnFace = this.polyhedraOnFaceId.get(faceId);
                Polyhedron polyhedron = polyhedraOnFace.get(0);
                int facePosition = polyhedron.getFacePosition(faceId);
                answer = polyhedron.getVerticesOnFaceAt(facePosition);
            } else {
                answer = face.getVertices();
            }
        } else {
            answer = face.getVertices();
        }
        return answer;
    }

    @Override
    public Vertex[] getVerticesFromPolyhedronId(int polyhedronId) {
        Polyhedron polyhedron = this.getPolyhedronById(polyhedronId);
        return polyhedron.getVertices();
    }

    @Override
    public int getNbEdges() {
        return this.nbEdges;
    }

    @Override
    public Edge getEdgeById(int edgeId) {
        Integer edgeIdInteger = new Integer(edgeId);
        Edge edge = this.edgeMap.get(edgeIdInteger);
        if (edge == null && (edge = this.cachedEdgeMap.get(edgeIdInteger)) == null) {
            TIntArrayList tIntArrayList = this.faceIdsOnEdgeId.get(edgeIdInteger);
            Integer faceId = tIntArrayList.get(0);
            Face face = this.getFaceById(faceId);
            int edgePosition = face.getEdgePosition(edgeId);
            edge = face.getEdgeAt(edgePosition);
            if (this.isCachingEnabled()) {
                this.cachedEdgeMap.put(edge.getId(), edge);
            }
        }
        return edge;
    }

    @Override
    public Edge[] getEdgesByIds(int[] ids) {
        Edge[] edges = new Edge[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            edges[i] = this.getEdgeById(ids[i]);
        }
        return edges;
    }

    @Override
    public Iterator<Edge> getEdgeIterator() {
        return new SingleEdgeIteratorOnMesh(this, this.faceIdsOnEdgeId, this.edgeMap, this.cachedEdgeMap);
    }

    @Override
    public Iterator<Edge> getEdgeIteratorStored() {
        return this.edgeMap.values().iterator();
    }

    @Override
    public int getEdgeIdFromVertices(Vertex[] vertices) {
        return this.edgeIdGenerator.getEdgeId(vertices);
    }

    @Override
    public int[] getEdgesIdsFromFaceId(int faceId) {
        int[] answer;
        Face face = this.faceMap.get(faceId);
        if (face == null) {
            face = this.cachedFaceMap.get(faceId);
            if (face == null) {
                List<Polyhedron> polyhedraOnFace = this.polyhedraOnFaceId.get(faceId);
                Polyhedron polyhedron = polyhedraOnFace.get(0);
                int facePosition = polyhedron.getFacePosition(faceId);
                answer = polyhedron.getEdgeIdsOnFaceAt(facePosition);
            } else {
                answer = face.getEdgeIds();
            }
        } else {
            answer = face.getEdgeIds();
        }
        return answer;
    }

    @Override
    public int[] getEdgesIdsFromPolyhedronId(int polyhedronId) {
        Polyhedron polyhedron = this.getPolyhedronById(polyhedronId);
        return polyhedron.getEdgeIds();
    }

    @Override
    public int getNbFaces() {
        return this.nbFaces;
    }

    @Override
    public Face getFaceById(int faceId) {
        Integer faceIdInteger = new Integer(faceId);
        Face face = this.faceMap.get(faceIdInteger);
        if (face == null && (face = this.cachedFaceMap.get(faceIdInteger)) == null) {
            List<Polyhedron> polyhedraOnFace = this.polyhedraOnFaceId.get(faceIdInteger);
            Polyhedron polyhedron = polyhedraOnFace.get(0);
            int facePosition = polyhedron.getFacePosition(faceId);
            face = polyhedron.getFaceAt(facePosition);
            if (this.isCachingEnabled()) {
                this.cachedFaceMap.put(face.getId(), face);
            }
        }
        return face;
    }

    @Override
    public Face[] getFacesByIds(int[] ids) {
        Face[] faces = new Face[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            faces[i] = this.getFaceById(ids[i]);
        }
        return faces;
    }

    @Override
    public Iterator<Face> getFaceIterator() {
        return new SingleFaceIteratorOnMesh(this, this.polyhedraOnFaceId, this.faceMap, this.cachedFaceMap);
    }

    @Override
    public Iterator<Face> getFaceIteratorStored() {
        return this.faceMap.values().iterator();
    }

    @Override
    public int getFaceIdFromVertices(Vertex[] vertices) {
        return this.faceIdGenerator.getFaceId(vertices);
    }

    @Override
    public int[] getFaceIdsFromPolyhedronId(int polyhedronId) {
        Polyhedron polyhedron = this.getPolyhedronById(polyhedronId);
        return polyhedron.getFaceIds();
    }

    @Override
    public int getNbPolyhedra() {
        return this.polyhedronList.size();
    }

    @Override
    public Polyhedron getPolyhedronById(int polyhedronId) {
        return this.polyhedronList.get(polyhedronId);
    }

    @Override
    public Polyhedron[] getPolyhedraByIds(int[] polyhedronIds) {
        Polyhedron[] polyhedra = new Polyhedron[polyhedronIds.length];
        for (int i = 0; i < polyhedronIds.length; ++i) {
            polyhedra[i] = this.getPolyhedronById(polyhedronIds[i]);
        }
        return polyhedra;
    }

    @Override
    public Iterator<Polyhedron> getPolyhedronIterator() {
        return this.polyhedronList.iterator();
    }

    @Override
    public List<Edge> getEdgesOnVertex(int vertexId) {
        final ArrayList<Edge> edges = new ArrayList<Edge>();
        TIntArrayList edgeIdsOnVertexList = this.edgeIdsOnVertex.get(this.getVertexById(vertexId));
        if (edgeIdsOnVertexList == null) {
            edgeIdsOnVertexList = new TIntArrayList();
        }
        edgeIdsOnVertexList.forEach(new TIntProcedure(){

            @Override
            public boolean execute(int edgeId) {
                Edge edgeById = UnstructuredMesh.this.getEdgeById(edgeId);
                if (!edges.contains(edgeById)) {
                    edges.add(edgeById);
                }
                return true;
            }
        });
        return edges;
    }

    @Override
    public Iterator<Edge> getEdgeIteratorOnVertices(int[] vertexIds) {
        return new SingleEdgeIteratorFromVertexIds(this, vertexIds);
    }

    @Override
    public List<Face> getFacesOnVertex(int vertexId) {
        final ArrayList<Face> faceList = new ArrayList<Face>();
        Vertex vertexById = this.getVertexById(vertexId);
        TIntArrayList edgeIds = this.edgeIdsOnVertex.get(vertexById);
        if (edgeIds != null) {
            edgeIds.forEach(new TIntProcedure(){

                @Override
                public boolean execute(int edgeId) {
                    TIntArrayList faceIds = (TIntArrayList)UnstructuredMesh.this.faceIdsOnEdgeId.get(edgeId);
                    if (faceIds != null) {
                        faceIds.forEach(new TIntProcedure(){

                            @Override
                            public boolean execute(int faceId) {
                                Face faceById = UnstructuredMesh.this.getFaceById(faceId);
                                if (!faceList.contains(faceById)) {
                                    faceList.add(faceById);
                                }
                                return true;
                            }
                        });
                    }
                    return true;
                }
            });
        }
        return faceList;
    }

    @Override
    public Iterator<Face> getFaceIteratorOnVertices(int[] vertexIds) {
        return new SingleFaceIteratorFromVertexIds(this, vertexIds);
    }

    @Override
    public List<Face> getFacesOnEdge(int edgeId) {
        final ArrayList<Face> faceList = new ArrayList<Face>();
        TIntArrayList faceIds = this.faceIdsOnEdgeId.get(edgeId);
        if (faceIds != null) {
            faceIds.forEach(new TIntProcedure(){

                @Override
                public boolean execute(int faceId) {
                    Face faceById = UnstructuredMesh.this.getFaceById(faceId);
                    if (!faceList.contains(faceById)) {
                        faceList.add(faceById);
                    }
                    return true;
                }
            });
        }
        return faceList;
    }

    @Override
    public List<Polyhedron> getPolyhedraOnVertex(int vertexId) {
        final ArrayList<Polyhedron> polyhedra = new ArrayList<Polyhedron>();
        Vertex vertexById = this.getVertexById(vertexId);
        TIntArrayList edgeIds = this.edgeIdsOnVertex.get(vertexById);
        if (edgeIds != null) {
            edgeIds.forEach(new TIntProcedure(){

                @Override
                public boolean execute(int edgeId) {
                    TIntArrayList faceIds = (TIntArrayList)UnstructuredMesh.this.faceIdsOnEdgeId.get(edgeId);
                    if (faceIds != null) {
                        faceIds.forEach(new TIntProcedure(){

                            @Override
                            public boolean execute(int faceId) {
                                List list = (List)UnstructuredMesh.this.polyhedraOnFaceId.get(faceId);
                                if (list != null) {
                                    for (Polyhedron polyhedron : list) {
                                        if (polyhedra.contains(polyhedron)) continue;
                                        polyhedra.add(polyhedron);
                                    }
                                }
                                return true;
                            }
                        });
                    }
                    return true;
                }
            });
        }
        return polyhedra;
    }

    @Override
    public Iterator<Polyhedron> getPolyhedronIteratorOnVertices(int[] vertexIds) {
        return new SinglePolyhedronIteratorFromVertexIds(this, vertexIds);
    }

    @Override
    public List<Polyhedron> getPolyhedraOnEdge(int edgeId) {
        final ArrayList<Polyhedron> polyhedra = new ArrayList<Polyhedron>();
        TIntArrayList faceIds = this.faceIdsOnEdgeId.get(edgeId);
        if (faceIds != null) {
            faceIds.forEach(new TIntProcedure(){

                @Override
                public boolean execute(int faceId) {
                    List list = (List)UnstructuredMesh.this.polyhedraOnFaceId.get(faceId);
                    if (list != null) {
                        for (Polyhedron polyhedron : list) {
                            if (polyhedra.contains(polyhedron)) continue;
                            polyhedra.add(polyhedron);
                        }
                    }
                    return true;
                }
            });
        }
        return polyhedra;
    }

    @Override
    public List<Polyhedron> getPolyhedraOnFace(int faceId) {
        List<Polyhedron> result = this.polyhedraOnFaceId.get(faceId);
        if (result == null) {
            result = new ArrayList<Polyhedron>();
        }
        return result;
    }

    @Override
    public List<Polyhedron> getPolyhedronList() {
        return this.polyhedronList;
    }

    @Override
    public DataFieldManager getDataFieldManager() {
        return this.dataFieldManager;
    }

    private void expandBoundingBox(Edge edge) {
        for (Vertex vertex : edge.getVertices()) {
            this.boundingBox.addPoint(vertex.getPoint());
        }
    }

    private int updateEdgeIds() {
        int i;
        int id = -1;
        for (Face face : this.faceMap.values()) {
            for (i = 0; i < face.getNbEdges(); ++i) {
                Vertex[] verticesOnEdgeAt = face.getVerticesOnEdgeAt(i);
                face.getEdgeIds()[i] = id = this.edgeIdGenerator.getEdgeId(verticesOnEdgeAt);
            }
        }
        for (Polyhedron polyhedron : this.polyhedronList) {
            for (i = 0; i < polyhedron.getNbEdges(); ++i) {
                polyhedron.getEdgeIds()[i] = id = this.edgeIdGenerator.getEdgeId(polyhedron.getVerticesOnEdgeAt(i));
            }
        }
        return this.edgeIdGenerator.getNbEdges();
    }

    private int updateFaceIds() {
        int id = -1;
        for (Polyhedron polyhedron : this.polyhedronList) {
            for (int i = 0; i < polyhedron.getNbFaces(); ++i) {
                polyhedron.getFaceIds()[i] = id = this.faceIdGenerator.getFaceId(polyhedron.getVerticesOnFaceAt(i));
            }
        }
        return this.faceIdGenerator.getNbFaces();
    }

    private void buildBottomUpVertexConnectivity() {
        this.edgeIdsOnVertex = new HashMap<Vertex, TIntArrayList>(this.getNbVertices());
        for (Polyhedron polyhedron : this.polyhedronList) {
            this.fillEdgeIdsMap(polyhedron);
        }
        for (Face face : this.faceMap.values()) {
            this.fillEdgeIdsMap(face);
        }
        for (Edge edge : this.edgeMap.values()) {
            Vertex[] verticesOnEdge;
            for (Vertex vertex : verticesOnEdge = edge.getVertices()) {
                TIntArrayList tmpEdgeIdsList = this.edgeIdsOnVertex.get(vertex);
                if (tmpEdgeIdsList == null) {
                    tmpEdgeIdsList = new TIntArrayList(2);
                    this.edgeIdsOnVertex.put(vertex, tmpEdgeIdsList);
                    tmpEdgeIdsList.add(edge.getId());
                    continue;
                }
                if (tmpEdgeIdsList.contains(edge.getId())) continue;
                tmpEdgeIdsList.add(edge.getId());
            }
        }
    }

    private void fillEdgeIdsMap(Face face) {
        for (int i = 0; i < face.getNbEdges(); ++i) {
            Vertex[] verticesOnEdge;
            int edgeId = face.getEdgeIds()[i];
            for (Vertex vertex : verticesOnEdge = face.getVerticesOnEdgeAt(i)) {
                TIntArrayList tmpEdgeIdsList = this.edgeIdsOnVertex.get(this.getVertexById(vertex.getId()));
                if (tmpEdgeIdsList == null) {
                    tmpEdgeIdsList = new TIntArrayList(2);
                    this.edgeIdsOnVertex.put(this.getVertexById(vertex.getId()), tmpEdgeIdsList);
                    tmpEdgeIdsList.add(edgeId);
                    continue;
                }
                if (tmpEdgeIdsList.contains(edgeId)) continue;
                tmpEdgeIdsList.add(edgeId);
            }
        }
    }

    private void buildBottomUpEdgeConnectivity() {
        this.faceIdsOnEdgeId = new TIntObjectHashMap(this.getNbEdges());
        for (Polyhedron polyhedron : this.polyhedronList) {
            for (int i = 0; i < polyhedron.getNbFaces(); ++i) {
                int faceId = polyhedron.getFaceIds()[i];
                int[] edgeIdsOnFace = polyhedron.getEdgeIdsOnFaceAt(i);
                this.fillFaceIdsMap(faceId, edgeIdsOnFace);
            }
        }
        for (Face face : this.faceMap.values()) {
            int faceId = face.getId();
            int[] edgeIdsOnFace = face.getEdgeIds();
            this.fillFaceIdsMap(faceId, edgeIdsOnFace);
        }
    }

    private void fillFaceIdsMap(int faceId, int[] edgeIdsOnFace) {
        for (int edgeId : edgeIdsOnFace) {
            TIntArrayList tmpFaceIdsList = this.faceIdsOnEdgeId.get(edgeId);
            if (tmpFaceIdsList == null) {
                tmpFaceIdsList = new TIntArrayList(2);
                this.faceIdsOnEdgeId.put(edgeId, tmpFaceIdsList);
                tmpFaceIdsList.add(faceId);
                continue;
            }
            if (tmpFaceIdsList.contains(faceId)) continue;
            tmpFaceIdsList.add(faceId);
        }
    }

    private void buildBottomUpFaceConnectivity() {
        this.polyhedraOnFaceId = new TIntObjectHashMap(this.getNbFaces());
        List<Polyhedron> tmpPolyhedronList = null;
        for (Polyhedron polyhedron : this.polyhedronList) {
            for (int faceId : polyhedron.getFaceIds()) {
                Integer faceIdInteger = new Integer(faceId);
                tmpPolyhedronList = this.polyhedraOnFaceId.get(faceIdInteger);
                if (tmpPolyhedronList == null) {
                    tmpPolyhedronList = new ArrayList<Polyhedron>(2);
                    this.polyhedraOnFaceId.put(faceIdInteger, tmpPolyhedronList);
                    tmpPolyhedronList.add(polyhedron);
                    continue;
                }
                if (tmpPolyhedronList.contains(polyhedron)) continue;
                tmpPolyhedronList.add(polyhedron);
            }
        }
    }

    private void computeConnectivity() {
        this.buildBottomUpFaceConnectivity();
        this.buildBottomUpEdgeConnectivity();
        this.buildBottomUpVertexConnectivity();
    }
}

