/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Polyhedron;
import java.util.Iterator;
import java.util.List;

public class BasicFaceIdsIterator
implements Iterator<Integer> {
    private final List<Polyhedron> polyhedronList;
    private int polyhedronIndex;
    private int faceIndex;
    private int nbfacesInCurrentPolyhedron;

    public BasicFaceIdsIterator(List<Polyhedron> aPolyhedronList) {
        this.polyhedronList = aPolyhedronList;
        if (!this.polyhedronList.isEmpty()) {
            this.nbfacesInCurrentPolyhedron = this.polyhedronList.get(0).getNbFaces();
        }
        this.polyhedronIndex = 0;
        this.faceIndex = 0;
    }

    @Override
    public boolean hasNext() {
        boolean answer = false;
        if (this.polyhedronIndex != this.polyhedronList.size()) {
            answer = true;
        }
        return answer;
    }

    @Override
    public Integer next() {
        Polyhedron polyhedron = this.polyhedronList.get(this.polyhedronIndex);
        int[] faceIds = polyhedron.getFaceIds();
        int answer = faceIds[this.faceIndex];
        if (this.faceIndex != this.nbfacesInCurrentPolyhedron - 1) {
            ++this.faceIndex;
        } else {
            ++this.polyhedronIndex;
            this.faceIndex = 0;
        }
        return answer;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

