/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Mesh;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntObjectMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SingleEdgeIteratorOnMesh
implements Iterator<Edge> {
    private final Mesh mesh;
    private Edge currentEdge;
    private final Set<Integer> alreadyUsedEdgeIds;
    private final TIntIterator edgeIdsOfFacesIterator;
    private final Iterator<Edge> edgeMapIterator;
    private final Iterator<Edge> cachedEdgeMapIterator;
    private boolean nextDone = true;

    public SingleEdgeIteratorOnMesh(Mesh aMesh, TIntObjectMap<TIntArrayList> aFaceIdsOnEdgeId, Map<Integer, Edge> aEdgeMap, Map<Integer, Edge> aCachedEdgeMap) {
        this.mesh = aMesh;
        this.currentEdge = null;
        this.alreadyUsedEdgeIds = new TreeSet<Integer>();
        this.edgeIdsOfFacesIterator = aFaceIdsOnEdgeId.keySet().iterator();
        this.edgeMapIterator = aEdgeMap.values().iterator();
        this.cachedEdgeMapIterator = aCachedEdgeMap.values().iterator();
    }

    @Override
    public boolean hasNext() {
        boolean continueLoop = true;
        if (this.nextDone) {
            while (continueLoop) {
                Edge edge;
                continueLoop = false;
                if (this.edgeIdsOfFacesIterator.hasNext()) {
                    Integer edgeId = this.edgeIdsOfFacesIterator.next();
                    if (!this.alreadyUsedEdgeIds.contains(edgeId)) {
                        this.currentEdge = this.mesh.getEdgeById(edgeId);
                        this.alreadyUsedEdgeIds.add(edgeId);
                        this.nextDone = false;
                        continueLoop = false;
                        return true;
                    }
                    continueLoop = true;
                }
                if (this.edgeMapIterator.hasNext()) {
                    edge = this.edgeMapIterator.next();
                    if (!this.alreadyUsedEdgeIds.contains(edge.getId())) {
                        this.currentEdge = this.mesh.getEdgeById(edge.getId());
                        this.alreadyUsedEdgeIds.add(edge.getId());
                        this.nextDone = false;
                        continueLoop = false;
                        return true;
                    }
                    continueLoop = true;
                }
                if (!this.cachedEdgeMapIterator.hasNext()) continue;
                edge = this.cachedEdgeMapIterator.next();
                if (!this.alreadyUsedEdgeIds.contains(edge.getId())) {
                    this.currentEdge = this.mesh.getEdgeById(edge.getId());
                    this.alreadyUsedEdgeIds.add(edge.getId());
                    this.nextDone = false;
                    continueLoop = false;
                    return true;
                }
                continueLoop = true;
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    public Edge next() {
        this.nextDone = true;
        return this.currentEdge;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

