/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.util;

import com.artenum.nisaba.util.VectorUtilDouble;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Filter;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Vertex;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OrientLocalNormals
implements Filter {
    private Mesh mesh = null;

    public OrientLocalNormals() {
    }

    public OrientLocalNormals(Mesh meshIn) {
        this.mesh = meshIn;
    }

    public void setMesh(Mesh meshIn) {
        this.mesh = meshIn;
    }

    public void orientMesh(MeshMask<Face> meshMaskIn, boolean inverseOrientation) {
        System.out.print("Orienting faces... ");
        HashMap<Integer, double[]> triangleNormal = new HashMap<Integer, double[]>();
        this.computeNormalOfFace(meshMaskIn, triangleNormal, inverseOrientation);
        this.orientEdgesInTriangles(meshMaskIn, triangleNormal);
        System.out.println("DONE");
    }

    private void orientEdgesInTriangles(MeshMask<Face> originalMeshMask, Map<Integer, double[]> localNormalsMap) {
        Iterator<Face> meshElementIterator = originalMeshMask.getMeshElementIterator();
        while (meshElementIterator.hasNext()) {
            Face face = meshElementIterator.next();
            double[] normalVector = localNormalsMap.get(face.getId());
            this.checkNormalQuality(face, normalVector);
        }
    }

    private void computeNormalOfFace(MeshMask<Face> meshMask, Map<Integer, double[]> triangleNormal, boolean inverseOrientation) {
        Vertex finishedVertexOfSecondVector;
        Iterator<Face> faceIterator = meshMask.getMeshElementIterator();
        if (!faceIterator.hasNext()) {
            throw new IllegalArgumentException("The input face mesh mask is empty, its id is : " + meshMask.getId());
        }
        Face currentFace = faceIterator.next();
        Edge[] edges = currentFace.getEdges();
        Edge firstEdge = edges[0];
        Edge secondEdge = edges[1];
        Edge thirdEdge = edges[2];
        double[] firstVector = new double[3];
        double[] secondVector = new double[3];
        Vertex firstVertexInsideFirstEdge = firstEdge.getVertexAt(0);
        Vertex secondVertexInsideFirstEdge = firstEdge.getVertexAt(1);
        if (secondEdge.getVertexAt(0).equals(secondVertexInsideFirstEdge)) {
            finishedVertexOfSecondVector = secondEdge.getVertexAt(1);
        } else if (thirdEdge.getVertexAt(0).equals(secondVertexInsideFirstEdge)) {
            finishedVertexOfSecondVector = thirdEdge.getVertexAt(1);
        } else {
            throw new UnsupportedOperationException("We consider splitting is only on triangle which has the following configuration :\nEach edge of triangle has 2 local vertices called vertex0 and vertex1. Their order is the same in all edges of the same triangle.");
        }
        double[] coordOfSecondVertexInFirstEdge = secondVertexInsideFirstEdge.getPoint().getCoord();
        double[] coordOfFirstVertexInsideFirstEdge = firstVertexInsideFirstEdge.getPoint().getCoord();
        double[] coordOfFinishedVertexOfSecondVector = finishedVertexOfSecondVector.getPoint().getCoord();
        firstVector[0] = coordOfSecondVertexInFirstEdge[0] - coordOfFirstVertexInsideFirstEdge[0];
        firstVector[1] = coordOfSecondVertexInFirstEdge[1] - coordOfFirstVertexInsideFirstEdge[1];
        firstVector[2] = coordOfSecondVertexInFirstEdge[2] - coordOfFirstVertexInsideFirstEdge[2];
        secondVector[0] = coordOfFinishedVertexOfSecondVector[0] - coordOfSecondVertexInFirstEdge[0];
        secondVector[1] = coordOfFinishedVertexOfSecondVector[1] - coordOfSecondVertexInFirstEdge[1];
        secondVector[2] = coordOfFinishedVertexOfSecondVector[2] - coordOfSecondVertexInFirstEdge[2];
        double[] computeVectorProduct = inverseOrientation ? VectorUtilDouble.dotProduct(secondVector, firstVector) : VectorUtilDouble.dotProduct(firstVector, secondVector);
        triangleNormal.put(currentFace.getId(), computeVectorProduct);
        List<Face> facesOnFirstEdge = this.mesh.getFacesOnEdge(firstEdge.getId());
        boolean fromVertex0ToVertex1 = true;
        for (Face face : facesOnFirstEdge) {
            this.computeRecursivlyNormal(firstEdge, face, currentFace, meshMask.getId(), triangleNormal, true, inverseOrientation);
        }
        List<Face> facesOnAnotherEdge = this.mesh.getFacesOnEdge(secondEdge.getId());
        for (Face face2 : facesOnAnotherEdge) {
            this.computeRecursivlyNormal(secondEdge, face2, currentFace, meshMask.getId(), triangleNormal, true, inverseOrientation);
        }
        List<Face> facesOnAnotherEdge2 = this.mesh.getFacesOnEdge(thirdEdge.getId());
        for (Face face2 : facesOnAnotherEdge2) {
            this.computeRecursivlyNormal(thirdEdge, face2, currentFace, meshMask.getId(), triangleNormal, true, inverseOrientation);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeRecursivlyNormal(Edge firstEdge, Face currentFace, Face previousFace, int meshMaskId, Map<Integer, double[]> triangleNormal, boolean fromVertex0ToVertex1, boolean inverseOrientation) {
        boolean fromVertex0ToVertex1InNewEdge;
        Vertex vertex0OfEdgeNextCommonEdge;
        Vertex vertex1OfEdgeNextCommonEdge;
        boolean confirmMeshMaskId = this.confirmMeshMaskId(currentFace, meshMaskId);
        if (!confirmMeshMaskId) {
            return;
        }
        if (triangleNormal.containsKey(currentFace.getId())) {
            return;
        }
        int currentEdgeId = firstEdge.getId();
        int edgePositionInCurrentFace = currentFace.getEdgePosition(currentEdgeId);
        Edge commonEdgeInCurrentFace = currentFace.getEdgeAt(edgePositionInCurrentFace);
        Vertex vertex0OfCommonEdgeInCurrentFace = commonEdgeInCurrentFace.getVertexAt(0);
        Vertex vertex1OfCommonEdgeInCurrentFace = commonEdgeInCurrentFace.getVertexAt(1);
        int edgePositionInPreviousFace = previousFace.getEdgePosition(currentEdgeId);
        Edge commonEdgeInPreviousFace = previousFace.getEdgeAt(edgePositionInPreviousFace);
        Vertex vertex0OfCommonEdgeInPreviousFace = commonEdgeInPreviousFace.getVertexAt(0);
        Vertex vertex1OfCommonEdgeInPreviousFace = commonEdgeInPreviousFace.getVertexAt(1);
        double[] secondVector = new double[3];
        double[] firstVector = new double[3];
        int edgePositionTmp = (edgePositionInCurrentFace + 1) % currentFace.getNbEdges();
        Edge edge2InCurrentFace = currentFace.getEdgeAt(edgePositionTmp);
        edgePositionTmp = (edgePositionTmp + 1) % currentFace.getNbEdges();
        Edge edge3InCurrentFace = currentFace.getEdgeAt(edgePositionTmp);
        if (fromVertex0ToVertex1) {
            if (vertex0OfCommonEdgeInCurrentFace.equals(vertex0OfCommonEdgeInPreviousFace)) {
                if (edge2InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) {
                    vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
                } else {
                    if (!edge3InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                    vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
                }
                firstVector[0] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                firstVector[1] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                firstVector[2] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                secondVector[0] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                secondVector[1] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                secondVector[2] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                fromVertex0ToVertex1InNewEdge = false;
            } else {
                if (!vertex0OfCommonEdgeInCurrentFace.equals(vertex1OfCommonEdgeInPreviousFace)) throw new UnsupportedOperationException();
                if (edge2InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) {
                    vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
                } else {
                    if (!edge3InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                    vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                    vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
                }
                firstVector[0] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                firstVector[1] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                firstVector[2] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                secondVector[0] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
                secondVector[1] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
                secondVector[2] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
                fromVertex0ToVertex1InNewEdge = true;
            }
        } else if (vertex0OfCommonEdgeInCurrentFace.equals(vertex0OfCommonEdgeInPreviousFace)) {
            if (edge2InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) {
                vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
            } else {
                if (!edge3InCurrentFace.getVertexAt(0).equals(vertex1OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
            }
            firstVector[0] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            firstVector[1] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            firstVector[2] = vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            secondVector[0] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            secondVector[1] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            secondVector[2] = vertex0OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            fromVertex0ToVertex1InNewEdge = true;
        } else {
            if (!vertex0OfCommonEdgeInCurrentFace.equals(vertex1OfCommonEdgeInPreviousFace)) throw new UnsupportedOperationException();
            if (edge2InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) {
                vertex1OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge2InCurrentFace.getVertexAt(0);
            } else {
                if (!edge3InCurrentFace.getVertexAt(1).equals(vertex0OfCommonEdgeInCurrentFace)) throw new UnsupportedOperationException();
                vertex1OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(1);
                vertex0OfEdgeNextCommonEdge = edge3InCurrentFace.getVertexAt(0);
            }
            firstVector[0] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            firstVector[1] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            firstVector[2] = vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2] - vertex1OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            secondVector[0] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[0] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[0];
            secondVector[1] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[1] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[1];
            secondVector[2] = vertex1OfCommonEdgeInCurrentFace.getPoint().getCoord()[2] - vertex0OfEdgeNextCommonEdge.getPoint().getCoord()[2];
            fromVertex0ToVertex1InNewEdge = false;
        }
        double[] computeVectorProduct = inverseOrientation ? VectorUtilDouble.dotProduct(secondVector, firstVector) : VectorUtilDouble.dotProduct(firstVector, secondVector);
        triangleNormal.put(currentFace.getId(), computeVectorProduct);
        for (Face face : this.mesh.getFacesOnEdge(edge2InCurrentFace.getId())) {
            this.computeRecursivlyNormal(edge2InCurrentFace, face, currentFace, meshMaskId, triangleNormal, fromVertex0ToVertex1InNewEdge, inverseOrientation);
        }
        for (Face face : this.mesh.getFacesOnEdge(edge3InCurrentFace.getId())) {
            this.computeRecursivlyNormal(edge3InCurrentFace, face, currentFace, meshMaskId, triangleNormal, fromVertex0ToVertex1InNewEdge, inverseOrientation);
        }
    }

    private void checkNormalQuality(Face face, double[] normalVector) {
        Vertex vertex0InOriginalTriangle = face.getVertexAt(0);
        Vertex vertex1InOriginalTriangle = face.getVertexAt(1);
        Vertex vertex2InOriginalTriangle = face.getVertexAt(2);
        double[] vector0 = new double[]{vertex1InOriginalTriangle.getPoint().getCoord()[0] - vertex0InOriginalTriangle.getPoint().getCoord()[0], vertex1InOriginalTriangle.getPoint().getCoord()[1] - vertex0InOriginalTriangle.getPoint().getCoord()[1], vertex1InOriginalTriangle.getPoint().getCoord()[2] - vertex0InOriginalTriangle.getPoint().getCoord()[2]};
        double[] vector1 = new double[]{vertex2InOriginalTriangle.getPoint().getCoord()[0] - vertex1InOriginalTriangle.getPoint().getCoord()[0], vertex2InOriginalTriangle.getPoint().getCoord()[1] - vertex1InOriginalTriangle.getPoint().getCoord()[1], vertex2InOriginalTriangle.getPoint().getCoord()[2] - vertex1InOriginalTriangle.getPoint().getCoord()[2]};
        double[] vector2 = new double[]{vertex0InOriginalTriangle.getPoint().getCoord()[0] - vertex2InOriginalTriangle.getPoint().getCoord()[0], vertex0InOriginalTriangle.getPoint().getCoord()[1] - vertex2InOriginalTriangle.getPoint().getCoord()[1], vertex0InOriginalTriangle.getPoint().getCoord()[2] - vertex2InOriginalTriangle.getPoint().getCoord()[2]};
        double[] normalBetweenVector0Vector1 = VectorUtilDouble.dotProduct(vector0, vector1);
        double[] normalBetweenVector1Vector2 = VectorUtilDouble.dotProduct(vector1, vector2);
        double[] normalBetweenVector2Vector0 = VectorUtilDouble.dotProduct(vector2, vector0);
        double scalarProductBetweenCurrentNormalComputed1ReferenceNormal = VectorUtilDouble.scalarProduct(normalBetweenVector0Vector1, normalVector);
        double scalarProductBetweenCurrentNormalComputed2ReferenceNormal = VectorUtilDouble.scalarProduct(normalBetweenVector1Vector2, normalVector);
        double scalarProductBetweenCurrentNormalComputed3ReferenceNormal = VectorUtilDouble.scalarProduct(normalBetweenVector2Vector0, normalVector);
        if (scalarProductBetweenCurrentNormalComputed1ReferenceNormal < 0.0 || scalarProductBetweenCurrentNormalComputed2ReferenceNormal < 0.0 || scalarProductBetweenCurrentNormalComputed3ReferenceNormal < 0.0) {
            Edge previousEdge0 = face.getEdgeAt(0);
            Edge previousEdge1 = face.getEdgeAt(1);
            Edge previousEdge2 = face.getEdgeAt(2);
            Vertex tmpVertex = face.getVertices()[0];
            face.getVertices()[0] = face.getVertices()[1];
            face.getVertices()[1] = tmpVertex;
            Vertex[] vertices = new Vertex[]{face.getVertices()[0], face.getVertices()[1]};
            int edgeIdFromVertices = this.mesh.getEdgeIdFromVertices(vertices);
            Edge edgeById = this.mesh.getEdgeById(edgeIdFromVertices);
            Vertex tmpVertexId = edgeById.getVertices()[0];
            edgeById.getVertices()[0] = edgeById.getVertices()[1];
            edgeById.getVertices()[1] = tmpVertexId;
            Edge edge0AfterSwitch = face.getEdgeAt(0);
            Edge edge1AfterSwitch = face.getEdgeAt(1);
            Edge edge2AfterSwitch = face.getEdgeAt(2);
            if (previousEdge0.equals(edge0AfterSwitch)) {
                int tmpEdgeId = face.getEdgeIds()[1];
                face.getEdgeIds()[1] = face.getEdgeIds()[2];
                face.getEdgeIds()[2] = tmpEdgeId;
            } else if (previousEdge1.equals(edge1AfterSwitch)) {
                int tmpEdgeId = face.getEdgeIds()[0];
                face.getEdgeIds()[0] = face.getEdgeIds()[2];
                face.getEdgeIds()[2] = tmpEdgeId;
            } else if (previousEdge2.equals(edge2AfterSwitch)) {
                int tmpEdgeId = face.getEdgeIds()[0];
                face.getEdgeIds()[0] = face.getEdgeIds()[1];
                face.getEdgeIds()[1] = tmpEdgeId;
            } else {
                throw new UnsupportedOperationException("Switch of edge ids store in Face is not possible.");
            }
        }
    }

    private boolean confirmMeshMaskId(Face currentFace, int meshMaskId) {
        List<MeshMask<Face>> meshMasks = this.mesh.getDataFieldManager().getFaceMeshMasksForFaceId(currentFace.getId());
        if (meshMasks != null) {
            for (MeshMask<Face> meshMaskIdTmp : meshMasks) {
                if (meshMaskIdTmp.getId() != meshMaskId) continue;
                return true;
            }
        }
        return false;
    }
}

