/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.util;

import com.artenum.penelope.field.DataFieldManager;
import com.artenum.penelope.field.EdgeDataField;
import com.artenum.penelope.field.FaceDataField;
import com.artenum.penelope.field.PolyhedronDataField;
import com.artenum.penelope.field.VertexDataField;
import com.artenum.penelope.field.data.DataType;
import com.artenum.penelope.field.data.IntDataArray;
import com.artenum.penelope.field.interfaces.DataArray;
import com.artenum.penelope.field.interfaces.DataField;
import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.MeshMask;
import com.artenum.penelope.mesh.interfaces.Polyhedron;
import com.artenum.penelope.mesh.interfaces.Vertex;
import com.artenum.penelope.mesh.mask.EdgeMeshMask;
import com.artenum.penelope.mesh.mask.FaceMeshMask;
import java.util.List;

public class RenumberingMeshElementId {
    public static void renumberingMeshElementIdAfterMeshSplitting(Mesh meshBeforeRenumumbering, Mesh meshAfterRenumbering) {
        DataFieldManager dataFieldManagerAfterRenumbering = meshAfterRenumbering.getDataFieldManager();
        dataFieldManagerAfterRenumbering.clear();
        DataFieldManager dataFieldManagerBeforeRenumbering = meshBeforeRenumumbering.getDataFieldManager();
        List<MeshMask<Vertex>> vertexMeshMasks = dataFieldManagerBeforeRenumbering.getVertexMeshMasks();
        for (MeshMask<Vertex> meshMask : vertexMeshMasks) {
            int[] meshElementIds;
            for (int vertexId : meshElementIds = meshMask.getMeshElementIds()) {
                dataFieldManagerAfterRenumbering.addMeshMaskToVertexId(meshMask, vertexId);
            }
            dataFieldManagerAfterRenumbering.addVertexMeshMask(meshMask);
        }
        List<MeshMask<Edge>> edgeMeshMasks = dataFieldManagerBeforeRenumbering.getEdgeMeshMasks();
        for (MeshMask<Edge> meshMask : edgeMeshMasks) {
            int[] meshElementIds;
            EdgeMeshMask edgeMeshMaskAfterRenumbering = new EdgeMeshMask(meshMask.getId(), meshMask.getName(), meshMask.getDescription(), meshAfterRenumbering);
            for (int edgeIdBeforeRenumbering : meshElementIds = meshMask.getMeshElementIds()) {
                Edge edgeById = meshBeforeRenumumbering.getEdgeById(edgeIdBeforeRenumbering);
                int edgeIdFromVertices = meshAfterRenumbering.getEdgeIdFromVertices(edgeById.getVertices());
                dataFieldManagerAfterRenumbering.addMeshMaskToEdgeId(edgeMeshMaskAfterRenumbering, edgeIdFromVertices);
                edgeMeshMaskAfterRenumbering.addMeshElementId(edgeIdFromVertices);
            }
            dataFieldManagerAfterRenumbering.addEdgeMeshMask(edgeMeshMaskAfterRenumbering);
        }
        List<MeshMask<Face>> faceMeshMasks = dataFieldManagerBeforeRenumbering.getFaceMeshMasks();
        for (MeshMask<Face> meshMask : faceMeshMasks) {
            int[] meshElementIds;
            FaceMeshMask faceMeshMaskAfterRenumbering = new FaceMeshMask(meshMask.getId(), meshMask.getName(), meshMask.getDescription(), meshAfterRenumbering);
            for (int faceIdBeforeRenumbering : meshElementIds = meshMask.getMeshElementIds()) {
                Face faceById = meshBeforeRenumumbering.getFaceById(faceIdBeforeRenumbering);
                int faceIdAfterRenumbering = meshAfterRenumbering.getFaceIdFromVertices(faceById.getVertices());
                dataFieldManagerAfterRenumbering.addMeshMaskToFaceId(faceMeshMaskAfterRenumbering, faceIdAfterRenumbering);
                faceMeshMaskAfterRenumbering.addMeshElementId(faceIdAfterRenumbering);
            }
            dataFieldManagerAfterRenumbering.addFaceMeshMask(faceMeshMaskAfterRenumbering);
        }
        List<MeshMask<Polyhedron>> polyhedronMeshMasks = dataFieldManagerBeforeRenumbering.getPolyhedronMeshMasks();
        for (MeshMask<Polyhedron> meshMask : polyhedronMeshMasks) {
            int[] meshElementIds;
            for (int polyhedronId : meshElementIds = meshMask.getMeshElementIds()) {
                dataFieldManagerAfterRenumbering.addMeshMaskToPolyhedronId(meshMask, polyhedronId);
            }
            dataFieldManagerAfterRenumbering.addPolyhedronMeshMask(meshMask);
        }
        List<DataField<?, ?>> dataFieldsBeforeRenumbering = dataFieldManagerBeforeRenumbering.getDataFields();
        for (DataField<?, ?> dataField : dataFieldsBeforeRenumbering) {
            MeshType meshType = dataField.getMeshType();
            DataArray<?> dataArray = dataField.getDataArray();
            switch (meshType) {
                case VERTEX: {
                    if (dataArray.getDataType().equals((Object)DataType.INT)) {
                        VertexDataField vertexDataFieldAfterRenumbering = new VertexDataField(dataField.getId(), dataField.getName(), dataField.getDescription(), dataField.getMeshMask(), dataArray);
                        dataFieldManagerAfterRenumbering.addDataField(vertexDataFieldAfterRenumbering);
                        break;
                    }
                    throw new UnsupportedOperationException("The conversion of data filed " + dataField.getName() + " is not done");
                }
                case EDGE: {
                    IntDataArray dataArrayAfterRenumbering;
                    if (dataArray.getDataType().equals((Object)DataType.INT)) {
                        int[] meshElementIds;
                        dataArrayAfterRenumbering = new IntDataArray();
                        for (int dataArrayIndex = 0; dataArrayIndex < dataArray.getNbData(); ++dataArrayIndex) {
                            Integer edgeIdBeforeRenumbering = (Integer)dataArray.get(dataArrayIndex);
                            Edge edgeById = meshBeforeRenumumbering.getEdgeById(edgeIdBeforeRenumbering);
                            int edgeIdFromVertices = meshAfterRenumbering.getEdgeIdFromVertices(edgeById.getVertices());
                            dataArrayAfterRenumbering.add(edgeIdFromVertices);
                        }
                        MeshMask<?> meshMaskFromMeshBeforeRenumbering = dataField.getMeshMask();
                        EdgeMeshMask edgeMeshMaskAfterRenumbering = new EdgeMeshMask(meshMaskFromMeshBeforeRenumbering.getId(), meshMaskFromMeshBeforeRenumbering.getName(), meshMaskFromMeshBeforeRenumbering.getDescription(), meshAfterRenumbering);
                        for (int edgeIdBeforeRenumbering : meshElementIds = meshMaskFromMeshBeforeRenumbering.getMeshElementIds()) {
                            Edge edgeById = meshBeforeRenumumbering.getEdgeById(edgeIdBeforeRenumbering);
                            int edgeIdFromVertices = meshAfterRenumbering.getEdgeIdFromVertices(edgeById.getVertices());
                            edgeMeshMaskAfterRenumbering.addMeshElementId(edgeIdFromVertices);
                        }
                        EdgeDataField<Integer> edgeDataFieldAfterRenumbering = new EdgeDataField<Integer>(dataField.getId(), dataField.getName(), dataField.getDescription(), edgeMeshMaskAfterRenumbering, dataArrayAfterRenumbering);
                        dataFieldManagerAfterRenumbering.addDataField(edgeDataFieldAfterRenumbering);
                        break;
                    }
                    throw new UnsupportedOperationException("The conversion of data filed " + dataField.getName() + " is not done");
                }
                case FACE: {
                    IntDataArray dataArrayAfterRenumbering;
                    if (dataArray.getDataType().equals((Object)DataType.INT)) {
                        int[] meshElementIds;
                        dataArrayAfterRenumbering = new IntDataArray();
                        for (int dataArrayIndex = 0; dataArrayIndex < dataArray.getNbData(); ++dataArrayIndex) {
                            Integer faceIdBeforeRenumbering = (Integer)dataArray.get(dataArrayIndex);
                            Face faceById = meshBeforeRenumumbering.getFaceById(faceIdBeforeRenumbering);
                            int faceIdFromVertices = meshAfterRenumbering.getFaceIdFromVertices(faceById.getVertices());
                            dataArrayAfterRenumbering.add(faceIdFromVertices);
                        }
                        MeshMask<?> meshMaskFromMeshBeforeRenumbering = dataField.getMeshMask();
                        FaceMeshMask faceMeshMaskAfterRenumbering = new FaceMeshMask(meshMaskFromMeshBeforeRenumbering.getId(), meshMaskFromMeshBeforeRenumbering.getName(), meshMaskFromMeshBeforeRenumbering.getDescription(), meshAfterRenumbering);
                        for (int faceIdBeforeRenumbering : meshElementIds = meshMaskFromMeshBeforeRenumbering.getMeshElementIds()) {
                            Face faceById = meshBeforeRenumumbering.getFaceById(faceIdBeforeRenumbering);
                            int faceIdFromVertices = meshAfterRenumbering.getFaceIdFromVertices(faceById.getVertices());
                            faceMeshMaskAfterRenumbering.addMeshElementId(faceIdFromVertices);
                        }
                        FaceDataField<Integer> faceDataFieldAfterRenumbering = new FaceDataField<Integer>(dataField.getId(), dataField.getName(), dataField.getDescription(), faceMeshMaskAfterRenumbering, dataArrayAfterRenumbering);
                        dataFieldManagerAfterRenumbering.addDataField(faceDataFieldAfterRenumbering);
                        break;
                    }
                    throw new UnsupportedOperationException("The conversion of data filed " + dataField.getName() + " is not done");
                }
                case POLYHEDRON: {
                    if (dataArray.getDataType().equals((Object)DataType.INT)) {
                        PolyhedronDataField polyhedronDataFieldAfterRenumbering = new PolyhedronDataField(dataField.getId(), dataField.getName(), dataField.getDescription(), dataField.getMeshMask(), dataArray);
                        dataFieldManagerAfterRenumbering.addDataField(polyhedronDataFieldAfterRenumbering);
                        break;
                    }
                    throw new UnsupportedOperationException("The conversion of data filed " + dataField.getName() + " is not done");
                }
                case UNKNOWN: {
                    throw new UnsupportedOperationException("The data field from mesh before renumbering with the type unknown can not be convert in mesh after renumbering");
                }
            }
        }
    }
}

