/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.trash;

import com.artenum.penelope.mesh.interfaces.Simplex;
import java.util.ArrayList;
import java.util.Arrays;

public class FilterOnNbMark {
    private final int nbLimit;
    private final ArrayList<Simplex> data;
    private boolean alreadyFiltered = false;

    public FilterOnNbMark(int nbMark) {
        this.nbLimit = nbMark - 1;
        this.data = new ArrayList();
    }

    public void addObject(Simplex obj) {
        this.data.add(obj);
    }

    private void applyFilter() {
        int lastId = -1;
        int currentCount = -1;
        Object[] allData = this.data.toArray(new Simplex[0]);
        Arrays.sort(allData);
        this.data.clear();
        int index = allData.length;
        while (index > 0) {
            Object meshObj;
            if ((meshObj = allData[--index]).getId() != lastId) {
                lastId = meshObj.getId();
                currentCount = 0;
            } else {
                ++currentCount;
            }
            if (currentCount != this.nbLimit) continue;
            this.data.add((Simplex)meshObj);
        }
        this.alreadyFiltered = true;
    }

    public ArrayList<Simplex> getFilteredData() {
        if (!this.alreadyFiltered) {
            this.applyFilter();
        }
        return this.data;
    }
}

